/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.master.validator.MasterDataSaveValidator;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class VariantMaterialSaveValidator
extends MasterDataSaveValidator {
    private static final Log logger = LogFactory.getLog(VariantMaterialSaveValidator.class);
    private Map<Long, String> auxPty = new HashMap<Long, String>();

    public VariantMaterialSaveValidator() {
        this.setEntityKey("bd_material");
    }

    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("baseunit");
        propertys.add("configproperties");
        propertys.add("relconfigmaterial");
        propertys.add("isvariant");
        propertys.add("relconfigmaterial.baseunit");
        return propertys;
    }

    @Override
    public void validate() {
        HashMap<Long, ExtendedDataEntity> pkWithEntity = new HashMap<Long, ExtendedDataEntity>(8);
        List pkList = Arrays.stream(this.dataEntities).map(data -> data.getValue("id")).collect(Collectors.toList());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select FID,FRELCONFIGMATERIAL from T_BD_Material where", new Object[0]).appendIn("FRELCONFIGMATERIAL", pkList);
        ArrayList<Long> existsRelconfigmaterialList = new ArrayList<Long>();
        try (ExtendedDataEntity[] dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute("sys"), (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row materialRow = dataSet.next();
                Long relconfigMaterialPkValue = materialRow.getLong("FRELCONFIGMATERIAL");
                if (relconfigMaterialPkValue == null || relconfigMaterialPkValue <= 0L) continue;
                existsRelconfigmaterialList.add(relconfigMaterialPkValue);
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject relconfigMaterial;
            String configProperties;
            Object pkValue = dataEntity.getValue("id");
            if (existsRelconfigmaterialList.contains(pkValue) && !"2".equals(configProperties = (String)dataEntity.getValue("configproperties"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7269\u6599\u201d\u7684\u5b57\u6bb5\u201c\u5173\u8054\u914d\u7f6e\u7269\u6599\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u201c\u914d\u7f6e\u5c5e\u6027\u201d\u5e94\u8be5\u4e3a\u914d\u7f6e\u4ef6\u3002", (String)"BASEDATA-W-304674", (String)"bd-master-opplugin", (Object[])new Object[0]));
            }
            if ((relconfigMaterial = (DynamicObject)dataEntity.getValue("relconfigmaterial")) == null) continue;
            pkWithEntity.put((Long)pkValue, dataEntity);
            this.checkRelconfigMaterial(dataEntity, relconfigMaterial);
        }
        if (!pkWithEntity.isEmpty()) {
            HashSet setmid = new HashSet(8);
            setmid.addAll(pkWithEntity.keySet());
            try {
                Object obj = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"getMaterialAllBom", (Object[])new Object[]{setmid});
                if (obj instanceof Map) {
                    Map matAndbomids = (Map)obj;
                    for (Map.Entry entry : pkWithEntity.entrySet()) {
                        Set bomids = (Set)matAndbomids.get(entry.getKey());
                        if (bomids == null || bomids.isEmpty()) continue;
                        this.addErrorMessage((ExtendedDataEntity)entry.getValue(), ResManager.loadKDString((String)"\u53d8\u5f0f\u7269\u6599\u4e0d\u5141\u8bb8\u5b58\u5728BOM\u7ed3\u6784\u3002", (String)"BASEDATA-W-444025", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u5224\u65ad\u662f\u5426\u5b58\u5728BOM\u7ed3\u6784BOMSearchService.getMaterialAllBom\u63a5\u53e3\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e0d\u5b58\u5728BOM\u7ed3\u6784\u3002", (Throwable)e);
            }
        }
    }

    private void checkRelconfigMaterial(ExtendedDataEntity dataEntity, DynamicObject relconfigMaterial) {
        String relconfigMaterialProperties;
        String configProperties;
        DynamicObject baseUnit;
        Long relMaterialBaseUnitPkValue = relconfigMaterial.getLong("baseunit_id");
        if (!relMaterialBaseUnitPkValue.equals((baseUnit = (DynamicObject)dataEntity.getValue("baseunit")).getPkValue())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u5f0f\u7269\u6599\u4e0e\u201c\u5173\u8054\u914d\u7f6e\u7269\u6599\u201d\u7684\u57fa\u672c\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BASEDATA-W-168141", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
        if (!"1".equals(configProperties = (String)dataEntity.getValue("configproperties")) && StringUtils.isNotEmpty((String)configProperties)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u5f0f\u7269\u6599\u7684\u201c\u914d\u7f6e\u5c5e\u6027\u201d\u5e94\u8be5\u4e3a\u7a7a\u3002", (String)"BASEDATA-W-220157", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
        if (!"2".equals(relconfigMaterialProperties = relconfigMaterial.getString("configproperties"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u5f0f\u7269\u6599\u7684\u201c\u5173\u8054\u914d\u7f6e\u7269\u6599\u201d\u7684\u201c\u914d\u7f6e\u5c5e\u6027\u201d\u5e94\u8be5\u4e3a\u914d\u7f6e\u4ef6\u3002", (String)"BASEDATA-W-606554", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }
}

