/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fbd.pandalist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.tmc.bizrule.fbd.pandalist.PandaCheckResult;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PandaListCtrlAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(PandaListCtrlAction.class);
    private static final String PANDA_MENU = "fbd_pandamenu";
    private static final String DOT = ".";
    private static final int MATCH_FIELD_NUM = 3;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("schemeentry.bizbill", "=", (Object)this.billEntityType.getName());
        DynamicObjectCollection pandaList = QueryServiceHelper.query((String)PANDA_MENU, (String)"id,name,schemeentry.billconditionval_tag", (QFilter[])filter.toArray());
        for (DynamicObject panda : pandaList) {
            String filterStr = panda.getString("schemeentry.billconditionval_tag");
            if (!EmptyUtil.isNoEmpty(filterStr)) continue;
            CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            Set conditionFields = Optional.ofNullable(targetCondition.getFilterCondition().getFilterRow()).orElseGet(Collections::emptyList).stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toSet());
            fields.addAll(conditionFields);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Collection pandaList;
                    ArrayList results = new ArrayList(16);
                    DynamicObject bill = dataEntity.getDataEntity();
                    logger.info("\u5355\u636e\u3010{}\u3011\u5f00\u59cb\u5339\u914d", bill.get("billno"));
                    DynamicObject cache = bill;
                    if (Objects.nonNull(bill.getPkValue()) && EmptyUtil.isNoEmpty(bill.getPkValue())) {
                        cache = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getPkValue(), (DynamicObjectType)PandaListCtrlAction.this.billEntityType);
                        DynamicObject dynamicObject = cache = Objects.isNull(cache) ? bill : cache;
                    }
                    if (CollectionUtils.isEmpty((Collection)(pandaList = PandaListCtrlAction.this.loadPandaMenuByEntity(PandaListCtrlAction.this.billEntityType.getName(), PandaListCtrlAction.this.getBillMainOrgId(cache))))) continue;
                    List pandaIds = pandaList.stream().map(t -> t.get("id")).collect(Collectors.toList());
                    Map schemaMap = PandaListCtrlAction.this.loadPandaSchemaByEntity(PandaListCtrlAction.this.billEntityType.getName(), pandaIds);
                    for (DynamicObject panda : pandaList) {
                        PandaListCtrlAction.this.match(operateKey, bill, cache, panda, (List)schemaMap.get(panda.getString("number")), results);
                    }
                    if (!CollectionUtils.isNotEmpty(results)) continue;
                    Collections.sort(results);
                    PandaCheckResult result = (PandaCheckResult)results.get(0);
                    logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u6267\u884c\u65b9\u6848\u3010{}\u3011", new Object[]{bill.get("billno"), result.getPandaNumber(), result.getSchemaName()});
                    PandaListCtrlAction.this.doWriteBack(bill, result);
                    if (!result.getControl().booleanValue()) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5df2\u7ecf\u88ab\u9ed1\u767d\u540d\u5355\u7ba1\u63a7\uff0c\u9ed1\u767d\u540d\u5355\u7f16\u7801\uff1a%s\u3002", (String)"PandaListCtrlAction_1", (String)"bos-ext-tmc", (Object[])new Object[]{result.getPandaNumber()}));
                }
            }
        });
    }

    private Long getBillMainOrgId(DynamicObject bill) {
        String mainOrg = this.billEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg) || Objects.isNull(bill.getDataEntityType()) || Objects.isNull(bill.getDataEntityType().getProperties())) {
            return 0L;
        }
        if (bill.getDataEntityType().getProperties().containsKey((Object)mainOrg) && Objects.nonNull(bill.getDynamicObject(mainOrg))) {
            return (Long)bill.getDynamicObject(mainOrg).getPkValue();
        }
        return 0L;
    }

    private Collection<DynamicObject> loadPandaMenuByEntity(String entityType, Long orgId) {
        logger.info("\u52a0\u8f7d\u5355\u636e\u7c7b\u578b\u3010{}\u3011\uff0c\u521b\u5efa\u7ec4\u7ec7\u3010{}\u3011", (Object)entityType, (Object)orgId);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)PANDA_MENU, (Long)orgId);
        if (Objects.nonNull(baseDataFilter)) {
            filter.and(baseDataFilter);
        }
        filter.and("schemeentry.bizbill", "=", (Object)entityType);
        String selectProp = "id,number,menuprop,biztype,createorg,menuentry,menuentry.menuno,menuname,menucusname";
        Map setBills = BusinessDataServiceHelper.loadFromCache((String)PANDA_MENU, (String)selectProp, (QFilter[])filter.toArray());
        if (Objects.isNull(setBills)) {
            return Collections.emptyList();
        }
        return setBills.values();
    }

    private Map<String, List<DynamicObject>> loadPandaSchemaByEntity(String entityType, List<Object> pandaIds) {
        String selectProp = "number,schemeentry,schemename,bizbill,billcheck,billmatchidfield,billmatchfield,matchway,menumatchfield,billconditionval_tag,scheme,billnotifyfield,matchtip";
        QFilter filter = new QFilter("id", "in", pandaIds);
        Map setBills = BusinessDataServiceHelper.loadFromCache((String)PANDA_MENU, (String)selectProp, (QFilter[])filter.toArray());
        if (Objects.isNull(setBills)) {
            return Collections.emptyMap();
        }
        return setBills.values().stream().collect(Collectors.toMap(t -> t.getString("number"), t -> t.getDynamicObjectCollection("schemeentry").stream().filter(w -> entityType.equals(w.getString("bizbill.number"))).collect(Collectors.toList())));
    }

    private void match(String operateKey, DynamicObject bill, DynamicObject cache, DynamicObject pandaList, List<DynamicObject> schemeList, List<PandaCheckResult> results) {
        Boolean isWhiteList = pandaList.getString("menuprop").equals("W");
        DynamicObjectCollection menuList = pandaList.getDynamicObjectCollection("menuentry");
        Integer orgMatch = this.getOrgMatch(cache, pandaList);
        String billno = bill.getString("billno");
        String pandaNo = pandaList.getString("number");
        String opCheck = "," + operateKey + ",";
        for (DynamicObject schema : schemeList) {
            String schemaName = schema.getString("schemename");
            String billcheck = schema.getString("billcheck");
            if (!billcheck.contains(opCheck)) {
                logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u65b9\u6848\u3010{}\u3011\u64cd\u4f5c\u8fc7\u6ee4", new Object[]{billno, pandaNo, schemaName});
                continue;
            }
            if (!this.isFilterBill(schema.getString("billconditionval_tag"), bill, cache)) {
                logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u65b9\u6848\u3010{}\u3011\u6761\u4ef6\u8fc7\u6ee4", new Object[]{billno, pandaNo, schemaName});
                continue;
            }
            PandaCheckResult result = new PandaCheckResult(isWhiteList, orgMatch);
            String fieldKey = schema.getString("billmatchfield");
            String billField = this.getBillDynamicSafeString(this.getBillDynamicObject(bill, cache, fieldKey), fieldKey);
            this.processCheckResult(result, billField, schema, (List<DynamicObject>)menuList);
            if (result.getMatchType() >= 0) {
                result.setPandaNumber(pandaList.getString("number"));
                result.setSchemaName(schemaName);
                result.setBillMatchIdField(schema.getString("billmatchidfield"));
                result.setBillNotifyField(schema.getString("billnotifyfield"));
                result.setMatchTip(schema.getString("matchtip"));
                logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u65b9\u6848\u3010{}\u3011\u6210\u529f\u5339\u914d", new Object[]{billno, pandaNo, schemaName});
                results.add(result);
                continue;
            }
            logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u65b9\u6848\u3010{}\u3011\u5b57\u6bb5\u8fc7\u6ee4", new Object[]{billno, pandaNo, schemaName});
        }
    }

    private DynamicObject getBillDynamicObject(DynamicObject bill, DynamicObject cache, String key) {
        int idx = key.indexOf(DOT);
        key = idx > 0 ? key.substring(0, idx) : key;
        return bill.getDataEntityType().getProperties().containsKey((Object)key) ? bill : cache;
    }

    private void processCheckResult(PandaCheckResult result, String billField, DynamicObject schema, List<DynamicObject> menuList) {
        String controlScheme = schema.getString("scheme");
        if (result.getWhiteList().booleanValue()) {
            this.setWhiteMatchScore(billField, schema, menuList, result);
            Boolean match = result.getMatch();
            boolean isControl = "Y".equals(controlScheme) && match != false || "R".equals(controlScheme) && match == false;
            result.setControl(isControl);
        } else {
            int matchScore = this.getMatchBillList(billField, schema, menuList);
            result.setMatchType(matchScore);
            if (matchScore >= 0) {
                result.setMatchType(matchScore);
                result.setControl("Y".equals(controlScheme));
            }
        }
    }

    private void setWhiteMatchScore(String billField, DynamicObject schema, List<DynamicObject> menuList, PandaCheckResult result) {
        boolean isMatch;
        String matchWay = schema.getString("matchWay");
        String menuField = schema.getString("menumatchfield");
        int wayScore = "E".equals(matchWay) ? 0 : 3;
        int menuScore = this.getMenuScore(menuField);
        if (StringUtils.isBlank((CharSequence)billField)) {
            isMatch = false;
        } else {
            List menuValList = menuList.stream().map(t -> t.getString(menuField)).filter(StringUtils::isNotBlank).flatMap(t -> {
                if ("menucusname".equals(menuField)) {
                    return Arrays.stream(StringUtils.split((String)t.replaceAll("\uff1b", ";"), (String)";"));
                }
                return Stream.of(t);
            }).collect(Collectors.toList());
            isMatch = "E".equals(matchWay) ? menuValList.contains(billField) : menuValList.stream().anyMatch(billField::contains);
        }
        result.setMatchType(wayScore + menuScore);
        result.setMatch(isMatch);
    }

    private int getMatchBillList(String billField, DynamicObject schema, List<DynamicObject> menuList) {
        if (StringUtils.isBlank((CharSequence)billField)) {
            return -1;
        }
        String matchWay = schema.getString("matchWay");
        String menuField = schema.getString("menumatchfield");
        int menuScore = this.getMenuScore(menuField);
        List menuValList = menuList.stream().map(t -> t.getString(menuField)).filter(StringUtils::isNotBlank).flatMap(t -> {
            if ("menucusname".equals(menuField)) {
                return Arrays.stream(StringUtils.split((String)t.replaceAll("\uff1b", ";"), (String)";"));
            }
            return Stream.of(t);
        }).collect(Collectors.toList());
        if ("E".equals(matchWay)) {
            if (menuValList.contains(billField)) {
                return menuScore;
            }
        } else if ("M".equals(matchWay)) {
            for (String menuVal : menuValList) {
                if (!billField.contains(menuVal)) continue;
                return 3 + menuScore;
            }
        }
        return -1;
    }

    private int getMenuScore(String menuVal) {
        switch (menuVal) {
            case "menuno": {
                return 0;
            }
            case "menuname": {
                return 1;
            }
        }
        return 2;
    }

    private Integer getOrgMatch(DynamicObject bill, DynamicObject pandaList) {
        Object orgVal;
        String createOrg = pandaList.getDynamicObject("createorg").getString("number");
        String mainOrg = this.billEntityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrg) && Objects.nonNull(orgVal = this.getBillDynamicValSafe(bill, mainOrg))) {
            DynamicObject org = (DynamicObject)orgVal;
            String billOrg = org.getString("number");
            return createOrg.equals(billOrg) ? 0 : 1;
        }
        return 1;
    }

    private Object getBillDynamicValSafe(DynamicObject object, String key) {
        try {
            return object.get(key);
        }
        catch (Exception e) {
            logger.info("\u5355\u636e\u3010{}\u3011\u83b7\u53d6\u503c\u3010{}\u3011\u5931\u8d25", object.get("billno"), (Object)key);
            return null;
        }
    }

    private String getBillDynamicSafeString(DynamicObject object, String key) {
        try {
            int idx;
            String entity;
            Object enObj;
            if (key.contains(DOT) && (enObj = object.get(entity = key.substring(0, idx = key.indexOf(DOT)))) instanceof MulBasedataDynamicObjectCollection) {
                MulBasedataDynamicObjectCollection mulBase = (MulBasedataDynamicObjectCollection)enObj;
                ArrayList<String> multiList = new ArrayList<String>(mulBase.size());
                for (int i = 0; i < mulBase.size(); ++i) {
                    DynamicObject typeObj = (DynamicObject)((DynamicObject)mulBase.get(i)).get("fbasedataid");
                    if (!(typeObj instanceof DynamicObject)) continue;
                    multiList.add(this.getBillDynamicSafeString(typeObj, key.substring(idx + 1)));
                }
                return StringUtils.join(multiList, (String)";");
            }
            return object.getString(key);
        }
        catch (Exception e) {
            logger.info("\u5355\u636e\u3010{}\u3011\u83b7\u53d6\u503c\u3010{}\u3011\u5931\u8d25", object.get("billno"), (Object)key);
            return null;
        }
    }

    private boolean isFilterBill(String filterStr, DynamicObject bill, DynamicObject cache) {
        if (StringUtils.isBlank((CharSequence)filterStr)) {
            return true;
        }
        CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        ConditionFactory conditionFactory = new ConditionFactory();
        conditionFactory.init(targetCondition, this.billEntityType.getName());
        DynamicObject obj = this.convertToPlainObject(bill, cache, this.getAllFields(targetCondition));
        return conditionFactory.isMatchCondition(obj);
    }

    private List<String> getAllFields(CRCondition targetCondition) {
        Set fields = Optional.ofNullable(targetCondition.getFilterCondition().getFilterRow()).orElseGet(Collections::emptyList).stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toSet());
        fields.add("id");
        return new ArrayList<String>(fields);
    }

    private DynamicObject convertToPlainObject(DynamicObject bill, DynamicObject cache, List<String> fields) {
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        DynamicObject obj = new DynamicObject(dt, true);
        obj.beginInit();
        for (String field : fields) {
            DynamicObject object = this.getBillDynamicObject(bill, cache, field);
            Class<?> propertyType = this.getPropertyType(field, object);
            DynamicSimpleProperty property = new DynamicSimpleProperty(field, propertyType, null);
            dt.registerSimpleProperty(property);
            Object val = ILocaleString.class.equals((Object)property.getPropertyType()) ? object.getString(field) : object.get(field);
            property.setValueFast((Object)obj, val);
        }
        obj.endInit();
        return obj;
    }

    private Class<?> getPropertyType(String field, DynamicObject bill) {
        int idx = field.indexOf(DOT);
        if (idx < 0) {
            return ((IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)field)).getPropertyType();
        }
        return this.getPropertyType(field.substring(idx + 1), bill.getDynamicObject(field.substring(0, idx)));
    }

    private void doWriteBack(DynamicObject bill, PandaCheckResult result) {
        String entityType = this.billEntityType.getName();
        this.setWriteBackProp(bill, result);
        if (Objects.nonNull(bill.getPkValue()) && EmptyUtil.isNoEmpty(bill.getPkValue())) {
            Object pkVal = bill.getPkValue();
            try {
                boolean exists = QueryServiceHelper.exists((String)entityType, (Object)pkVal);
                if (!exists) {
                    return;
                }
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkVal, (String)entityType);
                if (Objects.nonNull(object)) {
                    this.setWriteBackProp(object, result);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                }
            }
            catch (Exception e) {
                logger.info("\u5355\u636e\u3010{}\u3011\u8fd8\u6ca1\u6709\u6301\u4e45\u5316\u6210\u529f\uff0c\u5931\u8d25\u539f\u56e0\u3010{}\u3011", pkVal, (Object)e.getMessage());
            }
        }
    }

    private void setWriteBackProp(DynamicObject bill, PandaCheckResult result) {
        if (StringUtils.isNotBlank((CharSequence)result.getBillMatchIdField()) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result.getBillNotifyField(), result.getMatchTip()})) {
            if (StringUtils.isNotBlank((CharSequence)result.getBillMatchIdField()) && bill.containsProperty(result.getBillMatchIdField())) {
                bill.set(result.getBillMatchIdField(), (Object)Boolean.TRUE);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result.getBillNotifyField(), result.getMatchTip()}) && bill.containsProperty(result.getBillNotifyField())) {
                bill.set(result.getBillNotifyField(), (Object)result.getMatchTip());
            }
        }
    }
}

