/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fcs;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.helper.RiskTradeWarnHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;

public class RiskTradeWarnAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(RiskTradeWarnAction.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                block4: {
                    try {
                        logger.info("\u5f00\u59cb\u98ce\u9669\u4ea4\u6613\u9884\u8b66\u670d\u52a1");
                        Set<Long> idSet = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity().getLong("id")).collect(Collectors.toSet());
                        Map<Long, String> messageMap = RiskTradeWarnHelper.getErrorMessageInfo(idSet);
                        if (!messageMap.isEmpty()) {
                            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                                DynamicObject bill = dataEntity.getDataEntity();
                                Long pkId = bill.getLong("id");
                                String controlMessage = messageMap.getOrDefault(pkId, null);
                                if (controlMessage == null) continue;
                                logger.info("\u4e25\u63a7\u63d0\u793a\u4fe1\u606f\uff1a" + controlMessage);
                                this.addErrorMessage(dataEntity, controlMessage);
                            }
                        }
                        logger.info("\u7ed3\u675f\u98ce\u9669\u4ea4\u6613\u9884\u8b66\u670d\u52a1");
                    }
                    catch (Exception ex) {
                        logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                        if (!(ex instanceof KDBizException)) break block4;
                        throw ex;
                    }
                }
            }
        });
    }
}

