/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fpm;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.bizrule.fpm.ControlLocalMessageManager;
import kd.bos.ext.tmc.model.ControlResult;
import kd.bos.ext.tmc.model.ResultCode;
import kd.bos.ext.tmc.utils.SerializeUtil;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public abstract class AbstractControlAction
extends AbstractOpBizRuleAction {
    private DynamicObject[] selectBills = null;
    private String opName = null;
    private Log logger = LogFactory.getLog(AbstractOpBizRuleAction.class);
    private String routeKey;
    protected static final String TRY_CONTROL = "tryControl";
    private List<Long> ctrRecordList;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        try {
            Object jsonStr;
            this.selectBills = e.getDataEntities();
            if (EmptyUtil.isEmpty(this.selectBills)) {
                this.logger.info("\u6267\u884c\u63a7\u5236\u524d\uff0c\u64cd\u4f5c\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a\uff0c\u6545\u7ec8\u6b62\u6267\u884c\u3002\u9700\u786e\u8ba4\u4e0a\u6e38\u5173\u8054\u4e1a\u52a1\u5f71\u54cd\u3002\u5f53\u524d\u6267\u884c\u4e1a\u52a1\uff1a{}", (Object)this.getControlType());
                return;
            }
            this.opName = String.format("%s-%s", this.operateMeta.get("key"), ((Map)this.operateMeta.get("name")).get(Lang.get().toString()));
            this.routeKey = TX.getWrittenRouteKey();
            if (EmptyUtil.isEmpty(this.routeKey) && Objects.nonNull(this.selectBills) && this.selectBills.length > 0) {
                this.routeKey = this.selectBills[0].getDataEntityType().getDBRouteKey();
            }
            if (Objects.isNull(jsonStr = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fpm", (String)"FpmControlRPCService", (String)"dispatch", (Object[])new Object[]{this.selectBills, this.routeKey, this.opName, this.getControlType(), TRY_CONTROL}))) {
                this.logger.info("{}:\u9884\u5904\u7406\u8fd4\u8fd8\u5bf9\u8c61\u4e3a\u7a7a", (Object)this.getControlType());
                return;
            }
            ControlResult result = SerializeUtil.deserialize(jsonStr.toString(), ControlResult.class);
            this.showMessage(result);
            this.ctrRecordList = result.getSuccessIdList();
            this.logger.info("{}\uff1a\u9884\u5904\u7406\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u51c6\u5907\u6ce8\u518c\u6700\u7ec8\u4e00\u81f4\u6027\u670d\u52a1\u3002\u3002\u3002", (Object)this.getControlType());
            ControlLocalMessageManager localMsgMgr = ControlLocalMessageManager.getInstance();
            String entityName = e.getDataEntities()[0].getDataEntityType().getName();
            if (Objects.nonNull(this.ctrRecordList) && this.ctrRecordList.size() > 0) {
                localMsgMgr.insertLocalTXRecord(this.routeKey, entityName, this.ctrRecordList);
                CommonParam param = new CommonParam();
                param.put((Object)"ctrRecordList", this.ctrRecordList);
                ECGlobalSession.begin((String)"fpm_control", (DBRoute)DBRoute.of((String)this.routeKey), (boolean)true);
                ECGlobalSession.register((String)"tmc", (String)"fpm", (String)"FpmControlSubmitService", (Param)param);
            }
            this.logger.info("{}\uff1a\u6700\u7ec8\u4e00\u81f4\u6027\u670d\u52a1\u7ec4\u6210\u6210\u529f\u3002\u3002\u3002", this.ctrRecordList);
        }
        finally {
            this.addRollBackListener();
        }
    }

    private void addRollBackListener() {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onRollbacked() {
                AbstractControlAction.this.logger.info("\u9884\u5904\u7406\u6b65\u9aa4\u6267\u884c\u5931\u8d25\uff0c\u51c6\u5907\u56de\u6eda:{}\u3002\u3002\u3002\u3002", (Object)AbstractControlAction.this.ctrRecordList);
                if (AbstractControlAction.this.ctrRecordList != null && AbstractControlAction.this.ctrRecordList.size() > 0) {
                    try (TXHandle tx = TX.requiresNew();){
                        try {
                            ECSession session = DtxFactory.createEC((String)"fpm_control_discard");
                            session.setDbRoute(DBRoute.of((String)AbstractControlAction.this.routeKey));
                            CommonParam param = new CommonParam();
                            param.put((Object)"ctrRecordList", (Object)AbstractControlAction.this.ctrRecordList);
                            session.register("tmc", "fpm", "FpmControlRollBackService", (Param)param);
                        }
                        catch (Throwable e1) {
                            tx.markRollback();
                            throw e1;
                        }
                    }
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
    }

    protected void showMessage(ControlResult controlResult) throws KDBizException {
        if (controlResult.getCode() == ResultCode.ERROR) {
            this.logger.info("{}:\u6267\u884c\u7ed3\u679c\u4e3a\u5931\u8d25\u72b6\u6001,\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)controlResult.getErrMsg());
            if (EmptyUtil.isNoEmpty(controlResult.getErrMsg())) {
                throw new KDBizException(controlResult.getErrMsg());
            }
            return;
        }
        Map<Long, String> errIdMsgInfo = controlResult.getErrIdMsgInfo();
        this.logger.info("\u6267\u884c\u90e8\u5206\u6210\u529f\u6216\u5168\u90e8\u6210\u529f\u3002\u3002\u3002\u3002");
        if (errIdMsgInfo != null && !errIdMsgInfo.isEmpty()) {
            String errMsg = String.join((CharSequence)";\r\n", errIdMsgInfo.values());
            throw new KDBizException(errMsg);
        }
        this.logger.info("{}:showMessage\u6267\u884c\u5b8c\u6bd5", (Object)this.getControlType());
    }

    abstract String getControlType();
}

