/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fpm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;

public class ControlLocalMessageManager {
    private static ControlLocalMessageManager instance;
    private final Map<String, Boolean> initMap = new HashMap<String, Boolean>();
    private static final String TABLE_NAME = "t_fpm_ctr_record_";
    private static final String CREATE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s')CREATE TABLE %s (FID BIGINT DEFAULT 0 NOT NULL,FENTITYTYPE VARCHAR(100) DEFAULT ' ' NOT NULL,FCREATE_TIME DATETIME);";
    private static final String PK_INDEX_SQL = "EXEC P_ALTERPK 'PK_%s', '%s', 'FID', '1'";
    private static final String INSERT_SQL = "insert into %s(FID, FENTITYTYPE) values(?, ?)";
    private static final String DELETE_SQL = "delete from %s where FID in (%s)";
    private static final String QUERY_SQL = "select fid from %s where FID in (%s)";

    private ControlLocalMessageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ControlLocalMessageManager getInstance() {
        if (instance != null) return instance;
        Class<ControlLocalMessageManager> clazz = ControlLocalMessageManager.class;
        synchronized (ControlLocalMessageManager.class) {
            if (instance != null) return instance;
            instance = new ControlLocalMessageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initTable(String routeKey) {
        if (routeKey != null && !this.isInit(routeKey)) {
            this.doInitTable(routeKey);
        } else if (routeKey == null) {
            throw new KDBizException("Control local message Table init failed, route key is null.");
        }
    }

    public void insertLocalTXRecord(String routeKey, String billType, List<Long> ctrRecordList) {
        this.initTable(routeKey);
        if (ctrRecordList == null || ctrRecordList.size() == 0) {
            return;
        }
        List paramList = ctrRecordList.stream().map(o -> new Object[]{o, billType}).collect(Collectors.toList());
        int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)this.getInsertSql(routeKey), paramList);
        if (result.length < 1) {
            throw new KDBizException("Local message record insert error");
        }
        long count = Arrays.stream(result).count();
        if (count != (long)ctrRecordList.size()) {
            throw new KDBizException("Local message record insert error");
        }
    }

    public Map<Long, Boolean> exists(String routeKey, List<Long> ctrRecordList) {
        this.initTable(routeKey);
        if (ctrRecordList == null || ctrRecordList.size() == 0) {
            return Collections.emptyMap();
        }
        HashSet<Long> dbIdList = new HashSet<Long>(ctrRecordList.size());
        DataSet ds = DB.queryDataSet((String)ControlLocalMessageManager.class.getName(), (DBRoute)DBRoute.of((String)routeKey), (String)this.getQuerySql(routeKey, ctrRecordList));
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                dbIdList.add(row.getLong(0));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(ctrRecordList.size());
        for (Long recordId : ctrRecordList) {
            resultMap.put(recordId, dbIdList.contains(recordId));
        }
        return resultMap;
    }

    public void deleteLocalTxRecord(String routeKey, List<Long> ctrRecordList) {
        this.initTable(routeKey);
        if (ctrRecordList == null || ctrRecordList.size() == 0) {
            return;
        }
        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)this.getDeleteSql(routeKey, ctrRecordList), (Object[])new Object[0]);
    }

    private synchronized void doInitTable(String routeKey) {
        if (!this.isInit(routeKey)) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    boolean exists = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)this.getTableName(routeKey));
                    if (!exists) {
                        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)this.getCreateSql(routeKey));
                        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)this.getPkIndexSql(routeKey));
                    }
                    this.initMap.put(routeKey, Boolean.TRUE);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private String getCreateSql(String routeKey) {
        String tableName = this.getTableName(routeKey);
        return String.format(CREATE_SQL, tableName, tableName);
    }

    private String getPkIndexSql(String routeKey) {
        String tableName = this.getTableName(routeKey);
        return String.format(PK_INDEX_SQL, tableName.toUpperCase(), tableName);
    }

    private String getInsertSql(String routeKey) {
        String tableName = this.getTableName(routeKey);
        return String.format(INSERT_SQL, tableName);
    }

    private String getDeleteSql(String routeKey, List<Long> ctrRecordList) {
        return String.format(DELETE_SQL, this.getTableName(routeKey), this.getInIdParameter(ctrRecordList));
    }

    private String getQuerySql(String routeKey, List<Long> ctrRecordList) {
        return String.format(QUERY_SQL, this.getTableName(routeKey), this.getInIdParameter(ctrRecordList));
    }

    private String getInIdParameter(List<Long> ctrRecordList) {
        return ctrRecordList.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private String getTableName(String routeKey) {
        if (EmptyUtil.isNoEmpty(routeKey)) {
            routeKey = routeKey.replaceAll("\\.", "_");
        }
        return TABLE_NAME + routeKey;
    }

    private boolean isInit(String routeKey) {
        return this.initMap.getOrDefault(routeKey, false);
    }
}

