/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fpm.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;

public class SyncConfig {
    public static final String PROP_HEAD = "_HEAD__";
    private String entityType;
    private List<String> updateOpList;
    private List<String> reverseOpList;
    private boolean saveImmediately;
    private boolean reverseImmediately;
    private Map<String, List<String>> propMap;

    public static void register(List<DynamicObject> dataList) {
        HashMap<String, Set<String>> opKeyMap = new HashMap<String, Set<String>>(8);
        SyncConfig.fillOpKeyMap(opKeyMap, dataList);
        List sourceTypeList = dataList.stream().map(o -> o.getDynamicObject("sourcebill")).filter(Objects::nonNull).map(o -> o.getString("number")).distinct().collect(Collectors.toList());
        List idList = dataList.stream().map(o -> o.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObject[] dbDataArr = BusinessDataServiceHelper.load((String)"fpm_smartcollect", (String)String.join((CharSequence)",", "sourcebill", "enable", "entry_syncstrategy", "entry_syncopkey"), (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", sourceTypeList), new QFilter("id", "not in", idList)});
        if (dbDataArr.length > 0) {
            SyncConfig.fillOpKeyMap(opKeyMap, Arrays.asList(dbDataArr));
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                for (Map.Entry entry : opKeyMap.entrySet()) {
                    String sourceBillType = (String)entry.getKey();
                    Set opKeySet = (Set)entry.getValue();
                    OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)sourceBillType, (String)"FundPlanETL", new ArrayList(opKeySet));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void fillOpKeyMap(Map<String, Set<String>> opKeyMap, List<DynamicObject> dataList) {
        for (DynamicObject object : dataList) {
            DynamicObject sourceBill = object.getDynamicObject("sourcebill");
            boolean enable = object.getBoolean("enable");
            if (sourceBill == null || !enable) continue;
            String sourceBillType = sourceBill.getString("number");
            Set opKeySet = opKeyMap.computeIfAbsent(sourceBillType, o -> new HashSet(8));
            DynamicObjectCollection strategyEntry = object.getDynamicObjectCollection("entry_syncstrategy");
            for (DynamicObject entry : strategyEntry) {
                String[] opKeyArr;
                String opKey = entry.getString("entry_syncopkey");
                if (EmptyUtil.isEmpty(opKey)) continue;
                for (String op : opKeyArr = opKey.split(",")) {
                    if (EmptyUtil.isEmpty(op)) continue;
                    opKeySet.add(op);
                }
            }
        }
    }

    public static List<SyncConfig> fromDynamicObject(MainEntityType entityType, DynamicObject[] dataList) {
        ArrayList<SyncConfig> configList = new ArrayList<SyncConfig>(8);
        for (DynamicObject syncData : dataList) {
            String linkEntity = syncData.getString("linkentity");
            boolean isHeadProp = entityType.getName().equals(linkEntity);
            HashSet<String> headPropSet = new HashSet<String>(8);
            for (IDataEntityProperty property : entityType.getProperties()) {
                headPropSet.add(property.getName());
            }
            HashSet<String> entryPropSet = new HashSet<String>(8);
            if (!isHeadProp) {
                EntryProp linkEntryProp = (EntryProp)entityType.getProperty(linkEntity);
                DynamicObjectType entryType = linkEntryProp.getDynamicCollectionItemPropertyType();
                for (IDataEntityProperty property : entryType.getProperties()) {
                    entryPropSet.add(property.getName());
                }
            }
            SyncConfig config = new SyncConfig();
            config.setEntityType(entityType.getName());
            config.setPropMap(new HashMap<String, List<String>>(8));
            config.setUpdateOpList(new ArrayList<String>(8));
            config.setReverseOpList(new ArrayList<String>(8));
            DynamicObjectCollection syncEntryList = syncData.getDynamicObjectCollection("entry_syncstrategy");
            for (DynamicObject entry : syncEntryList) {
                String strategy = entry.getString("entry_strategy");
                String opStr = entry.getString("entry_syncopkey");
                boolean syncImmediately = entry.getBoolean("entry_syncimm");
                List<String> opList = Arrays.asList(opStr.split(","));
                if (EmptyUtil.isEmpty(strategy) || opList.size() == 0) continue;
                if ("update".equals(strategy)) {
                    config.getUpdateOpList().addAll(opList);
                    config.setSaveImmediately(syncImmediately);
                    continue;
                }
                if (!"discard".equals(strategy)) continue;
                config.getRevertOpList().addAll(opList);
                config.setReverseImmediately(syncImmediately);
            }
            if (config.getUpdateOpList().size() == 0 && config.getRevertOpList().size() == 0) continue;
            DynamicObjectCollection mappingEntryList = syncData.getDynamicObjectCollection("entry_fieldmapping");
            for (DynamicObject mappingEntry : mappingEntryList) {
                boolean sync = mappingEntry.getBoolean("sync");
                String valType = mappingEntry.getString("valtype");
                if (!sync) continue;
                ArrayList<String> syncPropList = new ArrayList<String>(1);
                if ("CALC_FORMULA".equals(valType)) {
                    String[] syncPropArr;
                    String syncPropStr = mappingEntry.getString("syncprop");
                    for (String prop : syncPropArr = syncPropStr.split(",")) {
                        if (!EmptyUtil.isNotEmpty((CharSequence)prop)) continue;
                        syncPropList.add(prop);
                    }
                } else {
                    if (!"SOURCE_FIELD".equals(valType)) continue;
                    String syncProp = mappingEntry.getString("sourcefieldsave");
                    syncPropList.add(syncProp);
                }
                for (String syncProp : syncPropList) {
                    String propKey;
                    if (isHeadProp) {
                        if (!headPropSet.contains(syncProp)) continue;
                        propKey = PROP_HEAD;
                    } else if (headPropSet.contains(syncProp)) {
                        propKey = PROP_HEAD;
                    } else {
                        if (!entryPropSet.contains(syncProp)) continue;
                        propKey = linkEntity;
                    }
                    List propList = config.getPropMap().computeIfAbsent(propKey, o -> new ArrayList());
                    propList.add(syncProp);
                }
            }
            configList.add(config);
        }
        return configList;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public List<String> getCorePropList() {
        ArrayList<String> corePropList = new ArrayList<String>(8);
        for (Map.Entry<String, List<String>> entry : this.propMap.entrySet()) {
            String key = entry.getKey();
            if (PROP_HEAD.equals(key)) {
                corePropList.addAll((Collection<String>)entry.getValue());
                continue;
            }
            String propPrefix = key + ".";
            for (String prop : entry.getValue()) {
                corePropList.add(propPrefix + prop);
            }
            corePropList.addAll((Collection<String>)entry.getValue());
        }
        return corePropList;
    }

    public Map<String, List<String>> getPropMap() {
        return this.propMap;
    }

    public void setPropMap(Map<String, List<String>> propMap) {
        this.propMap = propMap;
    }

    public List<String> getUpdateOpList() {
        return this.updateOpList;
    }

    public void setUpdateOpList(List<String> updateOpList) {
        this.updateOpList = updateOpList;
    }

    public List<String> getRevertOpList() {
        return this.reverseOpList;
    }

    public List<String> getReverseOpList() {
        return this.reverseOpList;
    }

    public void setReverseOpList(List<String> reverseOpList) {
        this.reverseOpList = reverseOpList;
    }

    public boolean isUpdateImmediately() {
        return this.saveImmediately;
    }

    public void setSaveImmediately(boolean saveImmediately) {
        this.saveImmediately = saveImmediately;
    }

    public boolean isReverseImmediately() {
        return this.reverseImmediately;
    }

    public void setReverseImmediately(boolean reverseImmediately) {
        this.reverseImmediately = reverseImmediately;
    }
}

