/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fpm.sync;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncConfig;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncData;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncProp;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncTableManager;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SyncStatusManager {
    private static final String OPKEY_CAS_WRITEBACK = "__CAS_WRITEBACK";
    private MainEntityType entityType;
    private String routeKey;
    private String tableName;
    private String opKey;
    private String opName;
    private List<SyncConfig> configList;
    private DynamicObject[] dbDataArr;
    private boolean init;
    private boolean hasConfig;
    private List<Long> addNewIdList;
    private List<Long> updateStatusIdList;
    private List<Long> revertList;
    private boolean updateImmediately;
    private boolean revertImmediately;
    private boolean isRevertOp;
    private boolean isUpdateOp;
    private SyncTableManager tableMgr;

    public SyncStatusManager(MainEntityType entityType, String opKey, String opName) {
        this.entityType = entityType;
        this.opKey = opKey;
        this.opName = opName;
        this.routeKey = entityType.getDBRouteKey();
        this.tableName = entityType.getAlias();
        this.init = false;
        this.addNewIdList = new ArrayList<Long>(8);
        this.updateStatusIdList = new ArrayList<Long>(8);
        this.revertList = new ArrayList<Long>(8);
        this.init();
    }

    public static SyncStatusManager getCasWriteBackManager(MainEntityType entityType) {
        return new SyncStatusManager(entityType, OPKEY_CAS_WRITEBACK, ResManager.loadKDString((String)"\u51fa\u7eb3\u53cd\u5199", (String)"SyncStatusManager_0", (String)"bos-ext-tmc", (Object[])new Object[0]));
    }

    public void loadDBData(List<Long> idList) {
        this.dbDataArr = BusinessDataServiceHelper.load((String)this.entityType.getName(), (String)String.join((CharSequence)",", this.getProperties()), (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
    }

    public boolean hasConfig() {
        return this.hasConfig;
    }

    public void addNew(List<DynamicObject> dataList) {
        List idList = dataList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        this.addNewIdList.addAll(idList);
    }

    public void modify(List<DynamicObject> dataList) {
        List<Long> idList = dataList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        List<SyncData> syncDataList = this.tableMgr.querySyncData(this.routeKey, this.tableName, idList);
        Set syncIdSet = syncDataList.stream().map(SyncData::getId).collect(Collectors.toSet());
        ArrayList<DynamicObject> hasSyncRecordDataList = new ArrayList<DynamicObject>(8);
        ArrayList<Long> noRecordIdList = new ArrayList<Long>(8);
        for (DynamicObject data : dataList) {
            long id = data.getLong("id");
            if (syncIdSet.contains(id)) {
                hasSyncRecordDataList.add(data);
                continue;
            }
            noRecordIdList.add(id);
        }
        if (hasSyncRecordDataList.size() > 0) {
            this.updateStatusIdList.addAll(this.getModifiedIdList(hasSyncRecordDataList));
        }
        if (noRecordIdList.size() > 0) {
            this.addNewIdList.addAll(noRecordIdList);
        }
    }

    public void writeBack(List<Long> idList) {
        this.updateStatusIdList.addAll(idList);
    }

    public void revert(List<DynamicObject> dataList) {
        List idList = dataList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        this.revertList.addAll(idList);
    }

    public boolean isRevert() {
        return this.isRevertOp;
    }

    public boolean isUpdate() {
        return this.isUpdateOp;
    }

    public List<String> getProperties() {
        HashSet<String> coreProps = new HashSet<String>();
        for (SyncConfig syncConfig : this.configList) {
            coreProps.addAll(syncConfig.getCorePropList());
        }
        return new ArrayList<String>(coreProps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() {
        List<SyncData> syncInfo;
        block23: {
            if (!TX.inTX()) {
                return;
            }
            if (EmptyUtil.isEmpty(this.routeKey)) {
                this.routeKey = this.entityType.getDBRouteKey();
            }
            this.tableMgr.initTable(this.routeKey, this.tableName);
            if (this.addNewIdList.size() > 0) {
                this.tableMgr.insertSyncRecords(this.routeKey, this.tableName, 0, this.addNewIdList);
            }
            if (this.updateStatusIdList.size() > 0) {
                if (this.isWriteBack()) {
                    try (TXHandle tx = TX.requiresNew();){
                        try {
                            this.tableMgr.updateSyncRecords(this.routeKey, this.tableName, this.updateStatusIdList, 0);
                            if (this.updateImmediately) {
                                List<SyncData> syncInfo2 = this.tableMgr.querySyncData(this.routeKey, this.tableName, this.updateStatusIdList);
                                this.registerECService(syncInfo2, "UPDATE");
                            }
                            break block23;
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            throw e;
                        }
                    }
                }
                this.tableMgr.updateSyncRecords(this.routeKey, this.tableName, this.updateStatusIdList, 0);
                if (this.updateImmediately) {
                    syncInfo = this.tableMgr.querySyncData(this.routeKey, this.tableName, this.updateStatusIdList);
                    this.registerECService(syncInfo, "UPDATE");
                }
            }
        }
        if (this.revertList.size() > 0) {
            this.tableMgr.updateSyncRecords(this.routeKey, this.tableName, this.revertList, 2);
            if (this.revertImmediately) {
                syncInfo = this.tableMgr.querySyncData(this.routeKey, this.tableName, this.revertList);
                this.registerECService(syncInfo, "DISCARD");
            }
        }
    }

    private void registerECService(List<SyncData> syncDataList, String operateType) {
        CommonParam param = new CommonParam();
        param.put((Object)"__ENTITY_TYPE", (Object)this.entityType.getName());
        ArrayList dataList = new ArrayList(syncDataList.size());
        for (SyncData syncData : syncDataList) {
            HashMap<String, Number> syncInfoMap = new HashMap<String, Number>();
            syncInfoMap.put("__KEY_DATA_ID", syncData.getId());
            syncInfoMap.put("__KEY_VERSION", syncData.getVersion());
            dataList.add(syncInfoMap);
        }
        param.put((Object)"__DATA", dataList);
        param.put((Object)"__OPERATE_NAME", (Object)this.opName);
        param.put((Object)"__OPERATE_KEY", (Object)this.opKey);
        param.put((Object)"__OPERATE_TYPE", (Object)operateType);
        param.put((Object)"__OPERATE_TIME", (Object)new Date());
        ECGlobalSession.begin((String)"fpm_etlsync", (DBRoute)DBRoute.of((String)this.routeKey), (boolean)true);
        ECGlobalSession.setAsync((boolean)true);
        ECGlobalSession.register((String)"tmc", (String)"fpm", (String)"FpmETLSyncDataService", (Param)param);
    }

    private List<Long> getModifiedIdList(List<DynamicObject> dataList) {
        Map<String, Set<String>> propMap = this.getPropMap();
        Map idToDataMap = dataList.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        ArrayList<Long> modifyIdList = new ArrayList<Long>(10);
        List<Long> discardIdList = this.tableMgr.queryDiscardId(this.routeKey, this.tableName, new ArrayList<Long>(idToDataMap.keySet()));
        HashSet<Long> discardIdSet = new HashSet<Long>(discardIdList);
        for (DynamicObject dbData : this.dbDataArr) {
            DynamicObject data;
            long id = dbData.getLong("id");
            if (!idToDataMap.containsKey(id) || !this.dataModified(data = (DynamicObject)idToDataMap.get(id), dbData, propMap) && !discardIdSet.contains(id)) continue;
            modifyIdList.add(id);
        }
        return modifyIdList;
    }

    private boolean dataModified(DynamicObject data, DynamicObject dbData, Map<String, Set<String>> propMap) {
        for (Map.Entry<String, Set<String>> item : propMap.entrySet()) {
            Set<String> keyProps = item.getValue();
            for (String key : keyProps) {
                if ("_HEAD__".equals(item.getKey())) {
                    if (!this.dataModified(data, dbData, key)) continue;
                    return true;
                }
                DynamicObjectCollection entryList = data.getDynamicObjectCollection(item.getKey());
                DynamicObjectCollection dbEntryList = dbData.getDynamicObjectCollection(item.getKey());
                Map dbEntryMap = dbEntryList.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
                for (DynamicObject entry : entryList) {
                    DynamicObject dbEntry;
                    if (!this.dataModified(entry, dbEntry = (DynamicObject)dbEntryMap.get(entry.getLong("id")), key)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean dataModified(DynamicObject data, DynamicObject dbData, String propName) {
        if (data == null || dbData == null) {
            return true;
        }
        Object dataValue = data.get(propName);
        Object dbDataValue = dbData.get(propName);
        if (dataValue == null && dbDataValue == null) {
            return false;
        }
        if (dataValue == null || dbDataValue == null) {
            return true;
        }
        Class<?> dataValueClass = dataValue.getClass();
        if (!dataValueClass.isInstance(dbDataValue)) {
            return true;
        }
        if (dataValue instanceof BigDecimal) {
            BigDecimal dataDecimalValue = (BigDecimal)dataValue;
            BigDecimal dbDecimalValue = (BigDecimal)dbDataValue;
            return dataDecimalValue.compareTo(dbDecimalValue) != 0;
        }
        if (dataValue instanceof DynamicObject) {
            dataValue = ((DynamicObject)dataValue).getPkValue();
            dbDataValue = ((DynamicObject)dbDataValue).getPkValue();
        }
        boolean modified = !Objects.equals(dataValue, dbDataValue);
        return modified;
    }

    private Map<String, Set<String>> getPropMap() {
        HashMap<String, Set<String>> propMap = new HashMap<String, Set<String>>();
        for (SyncConfig syncConfig : this.configList) {
            Map<String, List<String>> curPropMap = syncConfig.getPropMap();
            for (Map.Entry<String, List<String>> entry : curPropMap.entrySet()) {
                Set curProp = propMap.computeIfAbsent(entry.getKey(), o -> new HashSet());
                curProp.addAll((Collection)entry.getValue());
            }
        }
        return propMap;
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.loadConfig();
        this.tableMgr = SyncTableManager.getInstance();
        this.init = true;
    }

    private void loadConfig() {
        this.configList = new ArrayList<SyncConfig>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sourceBillFilter = new QFilter("sourcebill", "=", (Object)this.entityType.getName());
        Map planMap = BusinessDataServiceHelper.loadFromCache((String)"fpm_smartcollect", (String)String.join((CharSequence)",", "sourcebill", "linkentity", "enable", SyncProp.mappingProp("sourcefieldsave"), SyncProp.mappingProp("valtype"), SyncProp.mappingProp("sync"), SyncProp.mappingProp("syncprop"), SyncProp.syncProp("entry_strategy"), SyncProp.syncProp("entry_syncopname"), SyncProp.syncProp("entry_syncimm"), SyncProp.syncProp("entry_syncopkey")), (QFilter[])new QFilter[]{enableFilter, sourceBillFilter});
        this.configList = SyncConfig.fromDynamicObject(this.entityType, planMap.values().toArray(new DynamicObject[0]));
        for (SyncConfig syncConfig : this.configList) {
            if (syncConfig.getUpdateOpList().contains(this.opKey)) {
                this.isUpdateOp = true;
            }
            if (syncConfig.isUpdateImmediately()) {
                this.updateImmediately = true;
            }
            if (this.isWriteBack() && syncConfig.isUpdateImmediately()) {
                this.updateImmediately = true;
            }
            if (!syncConfig.getRevertOpList().contains(this.opKey)) continue;
            this.isRevertOp = true;
            if (!syncConfig.isReverseImmediately()) continue;
            this.revertImmediately = true;
        }
        boolean hasOpRegister = this.isUpdateOp || this.isRevertOp;
        this.hasConfig = this.configList.size() > 0 && (hasOpRegister || this.isWriteBack());
    }

    private boolean isWriteBack() {
        return OPKEY_CAS_WRITEBACK.equals(this.opKey);
    }
}

