/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.tmc.utils.constant.ScheduleProposalConstant;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FormDesignDao {
    private static final Log logger = LogFactory.getLog(FormDesignDao.class);

    public static String getDesignFormName(String formId) {
        StringBuilder sql = new StringBuilder(100);
        sql.append("select a.FNAME as name from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID ");
        sql.append("where a.FLOCALEID = '");
        sql.append(Lang.get());
        sql.append("' and b.fnumber = ?");
        String formName = formId;
        try {
            ResultSetHandler<Object> callBackHanlder = new ResultSetHandler<Object>(){

                public String handle(ResultSet rs) throws Exception {
                    String formName = null;
                    try {
                        if (rs.next()) {
                            formName = rs.getString("name");
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return formName;
                }
            };
            formName = (String)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])new Object[]{formId}, (ResultSetHandler)callBackHanlder);
        }
        catch (Exception e1) {
            String msg = String.format("error:%s;  sql:%s", e1.getMessage(), sql);
            throw new KDException((Throwable)e1, BosErrorCode.sQL, new Object[]{msg});
        }
        return formName;
    }

    public static Map<String, String> getFormOperMap(String formNumber) {
        HashMap<String, String> operMap = new HashMap<String, String>(16);
        try {
            List ops = EntityMetadataCache.getDataEntityOperate((String)formNumber);
            for (Map each : ops) {
                Object oper = each.get("key");
                Object name = each.get("name");
                if (oper == null || name == null) continue;
                operMap.put(oper.toString(), (String)((Map)name).get(Lang.get().toString()));
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5355\u636e\u64cd\u4f5c\u5f02\u5e38," + e.getMessage());
        }
        return operMap;
    }

    public static String getOperationName(String formId, String oper) {
        if ("generatevoucher".equals(oper)) {
            return ScheduleProposalConstant.getGENVOUCHER();
        }
        String operName = FormDesignDao.getFormOperMap(formId).get(oper);
        if (operName == null) {
            return oper;
        }
        return operName;
    }
}

