/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.tmc.enums.ScheduleExecuteStatus;
import kd.bos.ext.tmc.enums.ScheduleExecuteType;
import kd.bos.ext.tmc.model.ScheduleExceOperInfo;
import kd.bos.ext.tmc.model.ScheduleProposalExecInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ScheduleSchemaExecLogDao {
    private static final Log logger = LogFactory.getLog((String)"ScheduleSchemaExecLogDao");

    public static DynamicObject insertExceSumLog(DynamicObject schedule, Date execstartdate, String taskId, ScheduleExecuteType type) {
        TaskInfo taskInfo = JobClient.queryTask((String)taskId);
        logger.info("taskInfo {}", (Object)SerializationUtils.toJsonString((Object)taskInfo));
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fcs_schedule_log");
        String tableName = obj.getDataEntityType().getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
        long id = ids[0];
        obj.set("id", (Object)id);
        obj.set("billno", (Object)Uuid16.create().toString());
        obj.set("billstatus", (Object)"A");
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        obj.set("schedule", (Object)schedule);
        obj.set("tasktype", (Object)schedule.getString("tasktype"));
        obj.set("type", (Object)type.getValue());
        obj.set("maintaskid", (Object)taskId);
        DynamicObjectCollection taskEntrys = schedule.getDynamicObjectCollection("taskentry");
        DynamicObjectCollection entry = obj.getDynamicObjectCollection("entryentity");
        for (DynamicObject taskEntry : taskEntrys) {
            DynamicObject row = entry.addNew();
            row.set("seq", (Object)taskEntry.getInt("seq"));
            row.set("taskid", (Object)taskEntry.getString("id"));
            row.set("taskname", (Object)taskEntry.getString("taskname"));
            row.set("executestatus", (Object)ScheduleExecuteStatus.PROCESSING.getStatus());
            row.set("starttime", (Object)execstartdate);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        DB.execute((DBRoute)DBRoute.of((String)"tmc"), (String)" update t_fcs_schedule_log_entry set fendtime = ? where fid = ?", (Object[])new Object[]{null, id});
        return obj;
    }

    public static long insertOperSumLog(Long schemaId, Long schemasumlogid, Date execstartdate, ScheduleExceOperInfo src, Integer billQty, String execdetail) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fcs_scheduleopersum_log");
        String tableName = obj.getDataEntityType().getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
        long id = ids[0];
        obj.set("id", (Object)id);
        obj.set("schedule", (Object)schemaId);
        obj.set("bizapp", (Object)src.getAppId());
        obj.set("bussiness", (Object)src.getBussiness());
        obj.set("oper", (Object)src.getOper());
        obj.set("opername", (Object)src.getOperName());
        obj.set("schemasumlogid", (Object)schemasumlogid);
        if (execstartdate == null) {
            execstartdate = new Date();
        }
        obj.set("execstartdate", (Object)execstartdate);
        obj.set("execstatus", (Object)ScheduleExecuteStatus.PROCESSING.getStatus());
        obj.set("billqty", (Object)billQty);
        obj.set("execdetail", (Object)execdetail);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return id;
    }

    public static void updateAllProcessingSchemaFail(Long schemaId, Long sumLogId) {
        Date nowDate = new Date();
        QFilter schemaIdFilter = new QFilter("schedule.id", "=", (Object)schemaId);
        QFilter execstatusFilter = new QFilter("entryentity.executestatus", "=", (Object)ScheduleExecuteStatus.PROCESSING.getStatus());
        QFilter sumLogIdFilter = new QFilter("id", "!=", (Object)sumLogId);
        String errMsg = ResManager.loadKDString((String)"\u8d85\u65f6\u81ea\u52a8\u9000\u51fa\u3002", (String)"ScheduleSchemaExecLogDao_0", (String)"bos-ext-tmc", (Object[])new Object[0]);
        DynamicObjectCollection isExistProcessingData = ScheduleSchemaExecLogDao.getBussinessObj("fcs_schedule_log", "id,entryentity.executestatus,entryentity.endtime,entryentity.executedetails", new QFilter[]{execstatusFilter, schemaIdFilter, sumLogIdFilter});
        if (isExistProcessingData != null) {
            for (DynamicObject singleDb : isExistProcessingData) {
                ScheduleSchemaExecLogDao.updateExecLogResult(singleDb.getLong("id"), "failure");
                ScheduleSchemaExecLogDao.updateExecSumLog(singleDb.getLong("id"), ScheduleExecuteStatus.FAIL.getStatus(), nowDate, errMsg);
            }
        }
    }

    public static void update2OperSumLog(long id, String execstatus, Date execEnddate, String errorMsg, int qty, int successBillQty, int failBillQty) {
        ArrayList<Object> paramsList = new ArrayList<Object>(3);
        paramsList.add(execEnddate);
        paramsList.add(execstatus);
        paramsList.add(errorMsg);
        paramsList.add(successBillQty);
        paramsList.add(failBillQty);
        paramsList.add(qty);
        paramsList.add(id);
        String update2OperSumLogExecResultSql = "update t_fcs_scheduleopersum_log set fexecenddate = ?,fexecstatus = ? ,fexecdetail = ?, fsuccessbillqty = fsuccessbillqty + ?, ffailbillqty = ffailbillqty + ?, fbillqty = ? where fid = ?;";
        DB.execute((DBRoute)DBRoute.of((String)"tmc"), (String)update2OperSumLogExecResultSql, (Object[])paramsList.toArray());
    }

    public static void batchInsertExceLog(ScheduleExceOperInfo exceOperInfo, Date execstartdate, Object[] sucessList, String status, String msg, String traceId) {
        if (sucessList == null || sucessList.length == 0) {
            logger.info("\u4efb\u52a1\u8c03\u5ea6\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)exceOperInfo.getBussiness());
        String numberProp = null;
        int numberType = 0;
        if (ScheduleSchemaExecLogDao.containsProperty(type, "billno") && !type.getName().equalsIgnoreCase("ai_buildreport")) {
            numberProp = "billno";
            numberType = 1;
        } else if (ScheduleSchemaExecLogDao.containsProperty(type, "number")) {
            numberProp = "number";
            numberType = 2;
        }
        StringBuilder sel = new StringBuilder("id");
        if (Objects.nonNull(type.getMainOrg())) {
            sel.append(",").append(type.getMainOrg());
        }
        if (Objects.nonNull(numberProp)) {
            sel.append(",").append(numberProp);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObjectCollection coll = ScheduleSchemaExecLogDao.getBussinessObj(exceOperInfo.getBussiness(), sel.toString(), new QFilter("id", "in", (Object)sucessList).toArray());
                DynamicObject[] exeLogArray = new DynamicObject[sucessList.length];
                for (int i = 0; i < sucessList.length; ++i) {
                    DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"fcs_scheduledetail_log");
                    ScheduleSchemaExecLogDao.createExeLog(exceOperInfo, execstartdate, logObj, null == coll ? null : (DynamicObject)coll.get(i), status, numberType, msg, traceId);
                    exeLogArray[i] = logObj;
                }
                SaveServiceHelper.save((DynamicObject[])exeLogArray);
            }
            catch (Throwable e) {
                h.markRollback();
                logger.error("\u4efb\u52a1\u8c03\u5ea6\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u6267\u884c\u6210\u529f\u7684\u5355\u636e\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u53d1\u751f\u62a5\u9519:" + e);
                throw e;
            }
        }
    }

    public static void batchInsertExceLog(ScheduleExceOperInfo exceOperInfo, Date execstartdate, List<Object> allObjs, List<Object> failbillObjs, Map<Object, String> pkErrorMap, String traceId) {
        if (allObjs == null || allObjs.size() <= 0) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)exceOperInfo.getBussiness());
        String numberProp = null;
        int numberType = 0;
        if (ScheduleSchemaExecLogDao.containsProperty(type, "billno")) {
            numberProp = "billno";
            numberType = 1;
        } else if (ScheduleSchemaExecLogDao.containsProperty(type, "number")) {
            numberProp = "number";
            numberType = 2;
        }
        String sel = "id," + type.getMainOrg() + (numberProp == null ? "" : "," + numberProp);
        DynamicObjectCollection coll = ScheduleSchemaExecLogDao.getBussinessObj(exceOperInfo.getBussiness(), sel, new QFilter("id", "in", allObjs).toArray());
        try (TXHandle h = TX.requiresNew();){
            try {
                ArrayList<DynamicObject> exeLogList = new ArrayList<DynamicObject>(allObjs.size());
                for (int i = 0; i < Objects.requireNonNull(coll).size(); ++i) {
                    Object objId = ((DynamicObject)coll.get(i)).get("id");
                    String status = ScheduleExecuteStatus.SUCCESS.getStatus();
                    String msg = "";
                    if (failbillObjs.contains(objId)) {
                        status = ScheduleExecuteStatus.FAIL.getStatus();
                        msg = pkErrorMap.get(objId);
                    }
                    DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"fcs_scheduledetail_log");
                    ScheduleSchemaExecLogDao.createExeLog(exceOperInfo, execstartdate, logObj, (DynamicObject)coll.get(i), status, numberType, msg, traceId);
                    exeLogList.add(logObj);
                }
                if (exeLogList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])exeLogList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u4efb\u52a1\u8c03\u5ea6\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u6267\u884c\u5931\u8d25\u7684\u5355\u636e\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u53d1\u751f\u62a5\u9519:" + e);
                throw e;
            }
        }
    }

    private static DynamicObjectCollection getBussinessObj(String exceOperInfo, String sel, QFilter[] in) {
        try {
            return QueryServiceHelper.query((String)exceOperInfo, (String)sel, (QFilter[])in);
        }
        catch (Exception e) {
            logger.error("\u4efb\u52a1\u8c03\u5ea6\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u6570\u636e\u9519\u8bef\uff0c", (Throwable)e);
            return null;
        }
    }

    public static void update2SchemaSumLog(long sumLogId, long taskId, int quantity, String execStatus, Date date, int failSumPkIdSize, int successBillSumQty, int failBillSumQty, ScheduleExecuteType execType, String execDetails) {
        String executeDetails = execStatus.equals(ScheduleExecuteStatus.STOP.getStatus()) ? (execType == ScheduleExecuteType.AUTO ? String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5230\u8fbe\u8bbe\u7f6e\u7684\u4e2d\u6b62\u6267\u884c\u65f6\u95f4\uff0c\u5df2\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6%1$s\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u9519\u8bef%3$s\u6761\u3002", (String)"ScheduleSchemaExecLogDao_1", (String)"bos-ext-tmc", (Object[])new Object[0]), quantity, successBillSumQty, failBillSumQty) : String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u624b\u52a8\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6%1$s\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u9519\u8bef%3$s\u6761\u3002", (String)"ScheduleSchemaExecLogDao_2", (String)"bos-ext-tmc", (Object[])new Object[0]), quantity, successBillSumQty, failBillSumQty)) : String.format(ResManager.loadKDString((String)"\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6%1$s\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u9519\u8bef%3$s\u6761\u3002", (String)"ScheduleSchemaExecLogDao_3", (String)"bos-ext-tmc", (Object[])new Object[0]), quantity, successBillSumQty, failBillSumQty);
        ScheduleSchemaExecLogDao.update2ExecuteSumLog(sumLogId, taskId, quantity, execStatus, date, failSumPkIdSize, executeDetails);
    }

    public static void stopExecuteSchema(ScheduleProposalExecInfo schemeExecInfo) {
        String sumStatus = ScheduleExecuteStatus.STOP.getStatus();
        int successBillSumQty = schemeExecInfo.getRecordTSC();
        int failBillSumQty = schemeExecInfo.getRecordTFC();
        int billSumQty = schemeExecInfo.getRecordTC();
        String executeDetails = null;
        ScheduleExceOperInfo exceOperInfo = schemeExecInfo.getExceOperInfo();
        if (ScheduleExecuteType.AUTO == exceOperInfo.getExecuteType()) {
            executeDetails = String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5230\u8fbe\u8bbe\u7f6e\u7684\u4e2d\u6b62\u6267\u884c\u65f6\u95f4\uff0c\u5df2\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6%1$s\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u9519\u8bef%3$s\u6761\u3002", (String)"ScheduleSchemaExecLogDao_1", (String)"bos-ext-tmc", (Object[])new Object[0]), billSumQty, successBillSumQty, failBillSumQty);
        }
        if (ScheduleExecuteType.MANUAL == exceOperInfo.getExecuteType()) {
            executeDetails = String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u624b\u52a8\u4e2d\u6b62\u6267\u884c\u3002\u672c\u6b21\u65b9\u6848\u6267\u884c\u5171\u83b7\u53d6%1$s\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u9519\u8bef%3$s\u6761\u3002", (String)"ScheduleSchemaExecLogDao_2", (String)"bos-ext-tmc", (Object[])new Object[0]), billSumQty, successBillSumQty, failBillSumQty);
        }
        ScheduleSchemaExecLogDao.update2ExecuteSumLog(exceOperInfo.getSumLogId(), exceOperInfo.getTaskId(), billSumQty, sumStatus, new Date(), billSumQty, executeDetails);
    }

    public static void createExeLog(ScheduleExceOperInfo exceOperInfo, Date execstartdate, DynamicObject logObj, DynamicObject srcbillObj, String status, int numberType, String msg, String traceId) {
        logObj.set("schedule_id", (Object)exceOperInfo.getSchemaId());
        logObj.set("bizapp_id", (Object)exceOperInfo.getAppId());
        logObj.set("bussiness", (Object)exceOperInfo.getBussiness());
        logObj.set("taskname", (Object)exceOperInfo.getOperName());
        logObj.set("oper", (Object)exceOperInfo.getOper());
        logObj.set("opersumlogid", (Object)exceOperInfo.getOperLogId());
        logObj.set("creator_id", (Object)exceOperInfo.getCreatorId());
        logObj.set("taskid", (Object)exceOperInfo.getTaskId());
        logObj.set("result", (Object)status);
        logObj.set("execnumber", (Object)0);
        if (null != msg && msg.length() > 1500) {
            msg = String.format("TraceId:%s  %s...", traceId, msg.substring(0, 1500));
        }
        logObj.set("exception", (Object)msg);
        if (srcbillObj != null) {
            if (numberType == 1) {
                logObj.set("srcbillnumber", srcbillObj.get("billno"));
            } else if (numberType == 2) {
                logObj.set("srcbillnumber", srcbillObj.get("number"));
            }
            logObj.set("srcbillid", (Object)srcbillObj.getLong("id"));
        }
        if (execstartdate == null) {
            execstartdate = new Date();
        }
        logObj.set("createtime", (Object)execstartdate);
        logObj.set("lastexectime", (Object)execstartdate);
    }

    public static void update2ExecuteSumLog(long id, long taskId, Integer quantity, String execstatus, Date execEnddate, Integer failSumPkIdSize, String executeDetails) {
        ArrayList<Object> paramsList = new ArrayList<Object>(6);
        paramsList.add(execEnddate);
        paramsList.add(quantity);
        paramsList.add(failSumPkIdSize);
        paramsList.add(executeDetails);
        paramsList.add(execstatus);
        paramsList.add(id);
        paramsList.add(String.valueOf(taskId));
        paramsList.add(ScheduleExecuteStatus.PROCESSING.getStatus());
        String update2SumLogSql = "update t_fcs_schedule_log_entry set fendtime = ?, fquantity = ?, ffailsumquantity = ?, fexecutedetails = ?, fexecutestatus = ? where fid = ? and ftaskid = ? and fexecutestatus=?;";
        DB.execute((DBRoute)DBRoute.of((String)"tmc"), (String)update2SumLogSql, (Object[])paramsList.toArray());
    }

    public static void updateOperSumLog(long id, String execstatus, Date execEnddate, String errorMsg) {
        ArrayList<Object> paramsLst = new ArrayList<Object>(3);
        paramsLst.add(execEnddate);
        paramsLst.add(execstatus);
        paramsLst.add(errorMsg);
        paramsLst.add(id);
        String updateOperSumLogExecResultSql = "update t_fcs_scheduleopersum_log set fexecenddate = ?,fexecstatus = ?,fexecdetail = ? where fid = ?;";
        DB.execute((DBRoute)DBRoute.of((String)"tmc"), (String)updateOperSumLogExecResultSql, (Object[])paramsLst.toArray());
    }

    public static void updateExecSumLog(long id, String status, Date nowDate, String errMsg) {
        ArrayList<Object> paramsLst = new ArrayList<Object>(4);
        paramsLst.add(nowDate);
        paramsLst.add(status);
        paramsLst.add(errMsg);
        paramsLst.add(id);
        paramsLst.add(ScheduleExecuteStatus.PROCESSING.getStatus());
        String updateSumLogSql = "update t_fcs_schedule_log_entry set fendtime = ? ,fexecutestatus = ?, fexecutedetails = ? where fid = ? and fexecutestatus=?;";
        DB.execute((DBRoute)DBRoute.of((String)"tmc"), (String)updateSumLogSql, (Object[])paramsLst.toArray());
    }

    public static boolean containsProperty(MainEntityType type, String key) {
        return type.getAllFields().containsKey(key);
    }

    public static void updateExecLogResult(long id, String result) {
        ArrayList<Object> paramsLst = new ArrayList<Object>(4);
        paramsLst.add(result);
        paramsLst.add(id);
        String updateSql = "update t_fcs_schedule_log set fresult = ? where fid = ?;";
        DB.execute((DBRoute)DBRoute.of((String)"tmc"), (String)updateSql, (Object[])paramsLst.toArray());
    }
}

