/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgs;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgsClosedCallBack;

public class DisclaimerWorkFlowShowFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(DisclaimerWorkFlowShowFormPlugin.class);
    private final String PAGECACHEKEY_CALLBACK = "DisclaimerWorkFlowShowFormPlugin_PageKey";
    public static final String DISCLAIMER = "disclaimer";
    public static final String HEAD_ID = "id";
    public static final String TYPE = "type";
    public static final String FCS_DISCLAIMER_RECORD = "fcs_disclaimer_record";
    public static final String OPKEY = "opkey";
    public static final String BILLID = "billid";
    public static final String DISCLAIMER_CONFIRM_BACK = "DISCLAIMER_CONFIRM_BACK";
    public static final String BILLENTITY = "billentity";
    public static final String SIGNTIME = "signtime";
    public static final String CREATER = "creater";
    public static final String CREATETIME = "createtime";

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e instanceof BeforeSubmitCustomEventArgs) {
            String result = this.getPageCache().get("DisclaimerWorkFlowShowFormPlugin_PageKey");
            if (Boolean.parseBoolean(result)) {
                return;
            }
            BeforeSubmitCustomEventArgs be = (BeforeSubmitCustomEventArgs)e;
            String bizIdentifyKey = this.getPageCache().get("bizIdentifyKey");
            logger.info("\u4e1a\u52a1\u6807\u8bc6-bizIdentifyKey:" + bizIdentifyKey);
            if ("NEED_DISCLAIMER_CONFIRM_FORM".equals(bizIdentifyKey)) {
                String pageId = this.getPageCache().get("billPageId");
                IFormView billPageView = this.getView().getViewNoPlugin(pageId);
                IDataModel billPageModel = billPageView.getModel();
                Long pkValue = (Long)billPageModel.getDataEntity().getPkValue();
                DynamicObject disclaimer = billPageModel.getDataEntity().getDynamicObject(DISCLAIMER);
                QFilter recordFilter = new QFilter(DISCLAIMER, "=", (Object)disclaimer.getLong(HEAD_ID));
                recordFilter.and(TYPE, "=", (Object)"know");
                recordFilter.and(CREATER, "=", (Object)RequestContext.get().getCurrUserId());
                boolean exists = QueryServiceHelper.exists((String)FCS_DISCLAIMER_RECORD, (QFilter[])recordFilter.toArray());
                if (!exists) {
                    String name = billPageModel.getDataEntity().getDynamicObjectType().getName();
                    be.setCancel(true);
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId(this.getShowFormId(name));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setCustomParam(OPKEY, (Object)"audit");
                    showParameter.setCustomParam(BILLID, (Object)String.valueOf(pkValue));
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DISCLAIMER_CONFIRM_BACK));
                    this.getView().showForm(showParameter);
                }
            }
        }
    }

    private String getShowFormId(String name) {
        String formId = "";
        switch (name) {
            case "fcs_sensitiveparam_change": {
                formId = "fcs_param_disclaimer";
                break;
            }
            case "bei_paybillupdatestatus": {
                formId = "bei_updatestat_disclaimer";
                break;
            }
            case "fcs_suspectconfrmbill": {
                formId = "fcs_susconfrim_disclaimer";
                break;
            }
            case "fcs_suspectset_chgbill": {
                formId = "fcs_suspectchg_disclaimer";
            }
        }
        return formId;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        if (null == e) {
            return;
        }
        String callBackId = e.getActionId();
        if (DISCLAIMER_CONFIRM_BACK.equals(callBackId) && null != (returnData = e.getReturnData())) {
            this.creatDisclaimerRecord(returnData);
            BeforeSubmitCustomEventArgsClosedCallBack args = new BeforeSubmitCustomEventArgsClosedCallBack((Object)this.getView(), null, null, null);
            args.setDoSubmitTask(true);
            this.getPageCache().put("DisclaimerWorkFlowShowFormPlugin_PageKey", "true");
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent((CustomEventArgs)args);
        }
    }

    private void creatDisclaimerRecord(Object returnData) {
        Map returnMap = (Map)returnData;
        String disclaimerId = (String)returnMap.get(DISCLAIMER);
        DynamicObject disclaimerRecord = BusinessDataServiceHelper.newDynamicObject((String)FCS_DISCLAIMER_RECORD);
        String pageId = this.getPageCache().get("billPageId");
        IFormView billPageView = this.getView().getViewNoPlugin(pageId);
        IDataModel billPageModel = billPageView.getModel();
        Long pkValue = (Long)billPageModel.getDataEntity().getPkValue();
        String name = billPageModel.getDataEntity().getDynamicObjectType().getName();
        disclaimerRecord.set(DISCLAIMER, (Object)Long.parseLong(disclaimerId));
        disclaimerRecord.set(BILLID, (Object)pkValue);
        disclaimerRecord.set(BILLENTITY, (Object)name);
        disclaimerRecord.set(TYPE, (Object)"know");
        disclaimerRecord.set(SIGNTIME, (Object)new Date());
        disclaimerRecord.set(CREATER, (Object)RequestContext.get().getCurrUserId());
        disclaimerRecord.set(CREATETIME, (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{disclaimerRecord});
    }
}

