/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.RiskTradeWarnHelper;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class RiskTradeWarnPlugin
extends AbstractFormPlugin {
    private static final List<String> OP_TYPE_LIST = Arrays.asList("submit", "audit", "donothing", "committobe");

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!(e.getSource() instanceof BillList) && !(e.getSource() instanceof ListView)) {
            String entityName = this.getView().getModel().getDataEntityType().getName();
            DynamicObject warningData = RiskTradeWarnHelper.getRiskTradeWarnByEntityName(entityName);
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (EmptyUtil.isNoEmpty(warningData) && !"A".equals(billStatus)) {
                Long pkId = (Long)this.getModel().getValue("id");
                DynamicObject errorBill = RiskTradeWarnHelper.getErrorBill(pkId);
                if (EmptyUtil.isNoEmpty(errorBill)) {
                    this.showRiskFloatForm(entityName, errorBill.getLong("id"));
                } else {
                    this.showRiskFloatForm(entityName, null);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate) {
            AbstractOperate op = (AbstractOperate)source;
            boolean isListPage = false;
            if (OP_TYPE_LIST.contains(op.getType())) {
                String entityName;
                IFormView view = this.getView();
                ArrayList<Long> selId = new ArrayList<Long>(16);
                if (view instanceof BillView) {
                    entityName = view.getModel().getDataEntityType().getName();
                    selId.add(this.getModel().getDataEntity().getLong("id"));
                } else {
                    isListPage = true;
                    BillList billList = (BillList)view.getControl("billlistap");
                    entityName = billList.getEntityId();
                    ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                    if (selectedRows.size() > 0) {
                        List collect = selectedRows.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList());
                        selId.addAll(collect);
                    }
                }
                DynamicObject warningData = RiskTradeWarnHelper.getRiskTradeWarnByEntityName(entityName);
                String operateKey = op.getOperateKey();
                if (EmptyUtil.isNoEmpty(warningData) && EmptyUtil.isNoEmpty(warningData.getString("warnop")) && warningData.getString("warnop").equals(operateKey)) {
                    DynamicObject riskScreening = warningData.getDynamicObject("riskscreening");
                    if (EmptyUtil.isNoEmpty(riskScreening)) {
                        riskScreening = BusinessDataServiceHelper.loadSingle((Object)riskScreening.getLong("id"), (String)"fcs_riskscreening");
                        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"riskService", (String)"getRiskResult", (Object[])new Object[]{new ArrayList<Long>(selId), riskScreening});
                        if (!isListPage && resultMap != null && !resultMap.isEmpty()) {
                            DynamicObject errorData = (DynamicObject)resultMap.get(selId.get(0));
                            this.showRiskFloatForm(entityName, errorData.getLong("id"));
                        }
                    }
                    this.showWarnIngMessage(selId);
                }
            }
        }
    }

    private void showRiskFloatForm(String entityNumber, Long errorDataId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fcs_float_layer");
        parameter.getOpenStyle().setPlaceholder(true);
        parameter.getOpenStyle().setShowType(ShowType.PageDrawer);
        parameter.getOpenStyle().setFloatingDirection(FloatingDirection.RightCenter);
        parameter.getCustomParams().put("entityNumber", entityNumber);
        parameter.getCustomParams().put("bizDataId", String.valueOf(this.getModel().getValue("id")));
        if (EmptyUtil.isNoEmpty(errorDataId)) {
            parameter.getCustomParams().put("errorDataId", errorDataId);
        }
        this.getView().showForm(parameter);
    }

    private void showWarnIngMessage(List<Long> selId) {
        String warning = RiskTradeWarnHelper.getWarnMessageInfo(new HashSet<Long>(selId));
        if (warning != null) {
            this.getView().showTipNotification(warning);
        }
    }
}

