/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.tmc.bizrule.entity.OpBizRuleExecStatus;
import kd.bos.ext.tmc.utils.commitToBe.enums.TmcAppEnum;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.commitToBe.helper.ParameterHelper;
import kd.bos.ext.tmc.utils.helper.SuspectRepeatHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SuspectRepeatCtrlPlugin
extends AbstractFormPlugin {
    private static final List<String> opTypeList = Arrays.asList("submit", "audit", "donothing", "committobe", "push", "pushandsave");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate) {
            AbstractOperate op = (AbstractOperate)source;
            OperateOption option = op.getOption();
            if (opTypeList.contains(op.getType())) {
                String entityName;
                OpBizRuleExecStatus ruleExecStatus;
                String opStatus = option.getVariableValue("opBizRuleExecStatus", null);
                OpBizRuleExecStatus opBizRuleExecStatus = ruleExecStatus = EmptyUtil.isNoEmpty(opStatus) ? (OpBizRuleExecStatus)SerializationUtils.fromJsonString((String)opStatus, OpBizRuleExecStatus.class) : new OpBizRuleExecStatus();
                if (!ruleExecStatus.needCheckSuspectRepeat()) {
                    return;
                }
                IFormView view = this.getView();
                ArrayList<Long> selId = new ArrayList<Long>(16);
                if (view instanceof BillView) {
                    entityName = view.getModel().getDataEntityType().getName();
                    selId.add(this.getModel().getDataEntity().getLong("id"));
                } else {
                    BillList billList = (BillList)view.getControl("billlistap");
                    entityName = billList.getEntityId();
                    ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                    if (selectedRows.size() > 0) {
                        List collect = selectedRows.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList());
                        selId.addAll(collect);
                    }
                }
                Map<String, Set<String>> map = this.getSuspectSetByEntityName(entityName);
                if (!map.isEmpty()) {
                    Set<String> landingOp;
                    String operateKey = op.getOperateKey();
                    Set<String> warningOp = map.get("warning");
                    if (EmptyUtil.isNoEmpty(warningOp) && warningOp.contains(operateKey)) {
                        this.showWarnIngMessage(selId);
                    }
                    if (EmptyUtil.isNoEmpty(landingOp = map.get("landing")) && landingOp.contains(operateKey)) {
                        String isCheck = (String)op.getOption().getVariables().get("isCheck");
                        String isPandaCheck = (String)op.getOption().getVariables().get("isPandaCheck");
                        if (!(EmptyUtil.isNoEmpty(isPandaCheck) && "false".equals(isPandaCheck) || "true".equals(isCheck))) {
                            Map variables = op.getOption().getVariables();
                            this.getView().getPageCache().put("opvariables", SerializationUtils.toJsonString((Object)variables));
                            this.showConfirmForm(operateKey, args, selId);
                            ruleExecStatus.setSuspectRepeatCheck(args.isCancel() ? -1 : 1);
                            this.getView().getPageCache().put("opBizRuleExecStatus", SerializationUtils.toJsonString((Object)ruleExecStatus));
                        }
                    }
                } else {
                    ruleExecStatus.setSuspectRepeatCheck(1);
                }
                option.setVariableValue("opBizRuleExecStatus", SerializationUtils.toJsonString((Object)ruleExecStatus));
            }
        }
    }

    private Map<String, Set<String>> getSuspectSetByEntityName(String entityName) {
        HashMap<String, Set<String>> returnOp = new HashMap<String, Set<String>>(16);
        QFilter qFilter = new QFilter("ctrltype", "in", Arrays.asList("landing", "warning"));
        qFilter.and("destentity.number", "=", (Object)entityName);
        qFilter.and("enable", "=", (Object)"1");
        Map setBills = BusinessDataServiceHelper.loadFromCache((String)"fcs_suspectset", (String)"checkop,landingop,ctrltype,openmq", (QFilter[])qFilter.toArray());
        if (!setBills.isEmpty()) {
            HashSet landingSet = new HashSet(16);
            HashSet warningSet = new HashSet(16);
            for (DynamicObject setBill : setBills.values()) {
                if ("landing".equals(setBill.getString("ctrltype"))) {
                    landingSet.addAll(Arrays.stream(setBill.getString("landingop").replaceFirst(",", "").split(",")).collect(Collectors.toList()));
                    continue;
                }
                warningSet.addAll(Arrays.stream(setBill.getString("checkop").replaceFirst(",", "").split(",")).collect(Collectors.toList()));
            }
            returnOp.put("landing", landingSet);
            returnOp.put("warning", warningSet);
        }
        return returnOp;
    }

    private void showConfirmForm(String operateKey, BeforeDoOperationEventArgs args, List<Long> selId) {
        QFilter qFilter = new QFilter("billid", "in", selId);
        qFilter.and("confirm", "=", (Object)false);
        qFilter.and("ctrltype", "=", (Object)"landing");
        HashSet<Long> dealId = new HashSet<Long>(16);
        Object[] bills = BusinessDataServiceHelper.load((String)"fcs_suspectbill", (String)"id,suspectset.landingop,billid,billentity,suspectentry.suspectbillid,suspectentry.suspectbillentity", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty(bills)) {
            bills = SuspectRepeatHelper.deleteInValidSuspectbill(qFilter, (DynamicObject[])bills);
        }
        for (Object bill : bills) {
            List collect = Arrays.stream(bill.getString("suspectset.landingop").replaceFirst(",", "").split(",")).collect(Collectors.toList());
            if (!collect.contains(operateKey)) continue;
            dealId.add(bill.getLong("billid"));
        }
        if (dealId.size() > 0) {
            String entityId;
            if (SuspectRepeatHelper.suspectPayParamterISTure()) {
                BillList billList;
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                listSelectedData.removeIf(s -> dealId.contains(s.getPrimaryKeyValue()));
                if (listSelectedData.size() == 0) {
                    args.setCancel(true);
                }
                if ((billList = (BillList)this.getControl("billlistap")) != null) {
                    billList.refresh();
                }
            } else {
                args.setCancel(true);
            }
            FormOperate source = (FormOperate)args.getSource();
            IFormView view = source.getView();
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            if (parentView != null && "botp_convertresult".equals(entityId = parentView.getEntityId())) {
                args.setCancelMessage(ResManager.loadKDString((String)"\u5b58\u5728\u7591\u4f3c\u91cd\u590d\u8bb0\u5f55\u8bf7\u5148\u786e\u8ba4\u3002", (String)"SuspectRepeatCtrlPlugin_0", (String)"bos-ext-tmc", (Object[])new Object[0]));
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getCustomParams().put("billid", dealId);
            parameter.getCustomParams().put("executeOperate", operateKey);
            parameter.getCustomParams().put("billentity", bills[0].getString("billentity"));
            parameter.setStatus(OperationStatus.VIEW);
            String style = ParameterHelper.getAppStringParameter(TmcAppEnum.FCS.getId(), RequestContext.get().getOrgId(), "suspectconfirmstyle");
            parameter.setFormId("fcs_suspectconfirm_f7");
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            if ("detail".equals(style)) {
                parameter.setFormId("fcs_suspectconfirm");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showConfirmFormCallBack"));
            this.getView().showForm(parameter);
        }
    }

    private void showWarnIngMessage(List<Long> selId) {
        String warning = SuspectRepeatHelper.getMessageInfo(new HashSet<Long>(selId), Collections.singletonList("warning"));
        if (warning != null) {
            this.getView().showTipNotification(warning);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnDataObject;
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)"showConfirmFormCallBack", (CharSequence)evt.getActionId()) && (returnDataObject = evt.getReturnData()) != null) {
            Map returnData = (Map)SerializationUtils.fromJsonString((String)returnDataObject.toString(), Map.class);
            if (!returnData.containsKey("executeOperate") || "close".equals(returnData.get("operate"))) {
                return;
            }
            OperateOption option = OperateOption.create();
            String opStatus = this.getView().getPageCache().get("opBizRuleExecStatus");
            OpBizRuleExecStatus ruleExecStatus = EmptyUtil.isNoEmpty(opStatus) ? (OpBizRuleExecStatus)SerializationUtils.fromJsonString((String)opStatus, OpBizRuleExecStatus.class) : new OpBizRuleExecStatus();
            ruleExecStatus.setSuspectRepeatCheck(1);
            option.setVariableValue("isCheck", "true");
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", "true");
            Map variables = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("opvariables"), Map.class);
            for (Map.Entry var : variables.entrySet()) {
                option.setVariableValue((String)var.getKey(), (String)var.getValue());
            }
            String executeOperate = (String)returnData.get("executeOperate");
            List notConfirmBilllIds = (List)returnData.get("notConfirmBilllIds");
            IFormView view = this.getView();
            option.setVariableValue("opBizRuleExecStatus", SerializationUtils.toJsonString((Object)ruleExecStatus));
            if (SuspectRepeatHelper.suspectPayParamterISTure()) {
                List allSuspectBilllIds = (List)returnData.get("allSuspectBilllIds");
                ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
                if (!(view instanceof BillView)) {
                    BillList billList = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                    for (Long SuspectBilllId : allSuspectBilllIds) {
                        ListSelectedRow row = new ListSelectedRow();
                        row.setPrimaryKeyValue((Object)SuspectBilllId);
                        listSelectedRows.add((Object)row);
                    }
                    selectedRows.clear();
                    selectedRows.addAll((Collection)listSelectedRows);
                }
                if (allSuspectBilllIds.size() == notConfirmBilllIds.size()) {
                    return;
                }
                option.setVariableValue("notConfirmBilllIds", SerializationUtils.toJsonString((Object)notConfirmBilllIds));
                this.getView().invokeOperation(executeOperate, option);
            } else {
                if (EmptyUtil.isNoEmpty(notConfirmBilllIds)) {
                    HashSet<Long> allBillIds = new HashSet<Long>(16);
                    if (view instanceof BillView) {
                        allBillIds.add(this.getModel().getDataEntity().getLong("id"));
                    } else {
                        BillList billList = (BillList)this.getControl("billlistap");
                        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                        if (selectedRows.size() > 0) {
                            Set collect = selectedRows.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toSet());
                            allBillIds.addAll(collect);
                        }
                    }
                    if (allBillIds.size() == notConfirmBilllIds.size()) {
                        return;
                    }
                    option.setVariableValue("notConfirmBilllIds", SerializationUtils.toJsonString((Object)notConfirmBilllIds));
                }
                this.getView().invokeOperation(executeOperate, option);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            if (billList != null) {
                billList.refresh();
            }
        }
    }
}

