/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.tmc.dao.FormDesignDao;
import kd.bos.ext.tmc.dao.ScheduleSchemaExecLogDao;
import kd.bos.ext.tmc.enums.ScheduleExecuteStatus;
import kd.bos.ext.tmc.model.ScheduleExceOperInfo;
import kd.bos.ext.tmc.model.ScheduleProposalExecInfo;
import kd.bos.ext.tmc.task.IScheduleExceutor;
import kd.bos.ext.tmc.task.IScheduleExecuteLog;
import kd.bos.ext.tmc.task.ScheduleExecuteContext;
import kd.bos.ext.tmc.utils.ScheduleExecuteUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public abstract class AbstractScheduleExecute
implements IScheduleExceutor,
IScheduleExecuteLog {
    protected static final Log logger = LogFactory.getLog((String)AbstractScheduleExecute.class.getName());
    protected ScheduleExecuteContext ctx;
    protected String traceId;

    public AbstractScheduleExecute(ScheduleExecuteContext ctx) {
        this.ctx = ctx;
        this.traceId = ctx.getTraceId();
    }

    @Override
    public void execute() {
        this.execOperStarLog();
        this.doExecute();
        this.execOperEndLog();
    }

    protected abstract void doExecute();

    @Override
    public void execOperStarLog() {
        ScheduleProposalExecInfo schemeExecInfo = this.ctx.getSchemeExecInfo();
        schemeExecInfo.setProgress(true);
        ScheduleExceOperInfo exceOperInfo = schemeExecInfo.getExceOperInfo();
        String operName = FormDesignDao.getOperationName(exceOperInfo.getBussiness(), exceOperInfo.getOper());
        exceOperInfo.setOperName(operName);
        long operSumLogId = ScheduleSchemaExecLogDao.insertOperSumLog(exceOperInfo.getSchemaId(), this.ctx.getSumLogId(), this.ctx.getExecstartdate(), exceOperInfo, 0, "");
        exceOperInfo.setOperLogId(operSumLogId);
        ScheduleProposalExecInfo.execInfoWriteCache(schemeExecInfo);
    }

    @Override
    public void execOperEndLog() {
        ScheduleExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
        ScheduleProposalExecInfo schemeExecInfo = this.ctx.getSchemeExecInfo();
        schemeExecInfo.setOperTCC();
        ScheduleProposalExecInfo.execInfoWriteCache(schemeExecInfo);
        ScheduleSchemaExecLogDao.update2OperSumLog(exceOperInfo.getOperLogId(), exceOperInfo.getExecuteStatus().getStatus(), new Date(), exceOperInfo.getExecDetails(), exceOperInfo.getOperRTC(), exceOperInfo.getOperRTSC(), exceOperInfo.getOperRTFC());
        if (exceOperInfo.getOperRTC() == 0) {
            try (TXHandle handle = TX.requiresNew();){
                try {
                    DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"fcs_scheduledetail_log");
                    ScheduleSchemaExecLogDao.createExeLog(schemeExecInfo.getExceOperInfo(), new Date(), logObj, null, ScheduleExecuteStatus.FAIL.getStatus(), 0, exceOperInfo.getExecDetails(), this.ctx.getTraceId());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
                }
                catch (Exception e) {
                    handle.markRollback();
                    logger.error("\u4efb\u52a1\u8c03\u5ea6\u540e\u53f0\u4e8b\u52a1\u65e5\u5fd7\uff0c\u6267\u884c\u6210\u529f\u7684\u5355\u636e\uff0c\u63d2\u5165\u65e5\u5fd7\u6570\u636e\u53d1\u751f\u62a5\u9519:" + e);
                }
            }
        }
    }

    protected List<QFilter> getExceDataCollectionFilter() {
        String mainOrgField;
        ScheduleExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)exceOperInfo.getBussiness());
        ArrayList<QFilter> dataFilter = new ArrayList<QFilter>(16);
        QFilter datafilter = exceOperInfo.getDatafilter();
        if (datafilter != null) {
            QFilter[] filters = AbstractScheduleExecute.filterTransformation(datafilter, type);
            dataFilter.addAll(Arrays.asList(filters));
        }
        if (StringUtils.isNotEmpty((String)(mainOrgField = type.getMainOrg())) && !this.ctx.getTargetInfoList().isEmpty()) {
            dataFilter.add(new QFilter(mainOrgField, "in", this.ctx.getTargetInfoList()));
        }
        return dataFilter;
    }

    public ScheduleExecuteStatus startExecOperation(long scheduleSchemaId, int count, Date execstartdate, StringBuffer errorMessage, List<Long> processObj, boolean isVoucher) {
        try {
            return this.exceOperAndExceLog(scheduleSchemaId, execstartdate, count, processObj.toArray(), isVoucher);
        }
        catch (Exception e) {
            errorMessage.append(e).append(';');
            logger.error("scheduleSchemaId:" + scheduleSchemaId + "\u6267\u884c\u5355\u636e\u64cd\u4f5c\u53d1\u751f\u9519\u8bef:", (Throwable)e);
            return ScheduleExecuteStatus.FAIL;
        }
    }

    private ScheduleExecuteStatus exceOperAndExceLog(Long scheduleSchemaId, Date execstartdate, int count, Object[] objs, boolean isVoucher) {
        OperationResult rtn;
        ScheduleExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
        if (ScheduleExecuteUtil.isStopExcute(this.ctx.getSchemeExecInfo())) {
            return ScheduleExecuteStatus.STOP;
        }
        try {
            OperateOption option = OperateOption.create();
            JSONObject params = exceOperInfo.getParams();
            if (params != null) {
                Iterator iterator = params.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    Object value = params.get((Object)(key = (String)iterator.next()));
                    option.setVariableValue(key, value == null ? "" : value.toString());
                }
            }
            logger.info(String.format("\u8fdb\u884c\u5355\u636e\u64cd\u4f5c\u8c03\u7528\uff0cscheduleSchemaId\uff1a%d bill:%s  oper:%s curbatch:%s", scheduleSchemaId, exceOperInfo.getBussiness(), exceOperInfo.getOper(), objs.length));
            long startTime = System.currentTimeMillis();
            rtn = this.invokeOperation(objs, option);
            long endTime = System.currentTimeMillis();
            Long seconds = endTime - startTime;
            logger.info(String.format("\u5355\u636e\u64cd\u4f5c\u8c03\u7528\u8017\u65f6\uff1a%dms\uff0cscheduleSchemaId\uff1a%d", seconds, scheduleSchemaId));
            logger.info("\u5355\u636e\u64cd\u4f5c\u8c03\u7528\u7ed3\u679c\uff1ascheduleSchemaId\uff1a{}\uff0crtn\uff1a{}", (Object)scheduleSchemaId, (Object)rtn.toString());
        }
        catch (Exception e) {
            logger.error("\u4efb\u52a1\u8c03\u5ea6\u5355\u636e\u64cd\u4f5c\u8c03\u7528\u62a5\u9519\uff1a" + e);
            exceOperInfo.setExecDetails(e.getMessage());
            ScheduleSchemaExecLogDao.batchInsertExceLog(exceOperInfo, count == 0 ? execstartdate : null, objs, ScheduleExecuteStatus.FAIL.getStatus(), e.getMessage(), this.traceId);
            this.batchUpdateCache(0, objs.length);
            throw e;
        }
        HashMap<Object, String> errorMap = new HashMap<Object, String>();
        this.billPKErrorMapping(errorMap, rtn.getAllErrorOrValidateInfo());
        if (!errorMap.isEmpty()) {
            logger.info("\u4efb\u52a1\u8c03\u5ea6\u65b9\u6848\u8c03\u7528\u660e\u7ec6\u8bb0\u5f55\u65e5\u5fd7\u5904\u7406: scheduleSchemaId\uff1a{}\uff0cerrorMap\uff1a{}", (Object)scheduleSchemaId, errorMap);
        }
        List successPkIds = rtn.getSuccessPkIds();
        ArrayList<Object> errorObjs = new ArrayList(errorMap.keySet());
        Set<String> successPkIdStr = successPkIds.stream().map(String::valueOf).collect(Collectors.toSet());
        logger.info("\u5355\u636e\u64cd\u4f5c\u8c03\u7528\u7ed3\u679c\uff1ascheduleSchemaId\uff1a{}\uff0csuccessPkIdStr\uff1a{}\uff0c errorMap\uff1a{}\uff0cobjs\uff1a{}", new Object[]{scheduleSchemaId, successPkIdStr, errorMap, JSON.toJSONString((Object)objs)});
        Set errorObjsStr = errorObjs.stream().map(String::valueOf).collect(Collectors.toSet());
        if (isVoucher && errorMap.get("0") != null) {
            successPkIds.clear();
            successPkIdStr.clear();
            errorObjs = new ArrayList(objs.length);
            for (Object objId : objs) {
                errorObjs.add(objId);
                String errorMsg = (String)errorMap.get("0");
                errorMap.put(Long.valueOf(objId.toString()), errorMsg);
            }
        } else {
            for (Object objId : objs) {
                if (!Objects.nonNull(objId)) continue;
                String objIdStr = String.valueOf(objId);
                String errorId = (String)errorMap.get(objId);
                if (!StringUtils.isNull((String)errorId)) {
                    successPkIds.remove(objId);
                    successPkIdStr.remove(objIdStr);
                }
                AtomicBoolean isSuccess = new AtomicBoolean(false);
                successPkIdStr.forEach(o -> {
                    if (o.contains(objIdStr)) {
                        isSuccess.set(true);
                    }
                });
                if (successPkIdStr.contains(objIdStr) || errorObjsStr.contains(objIdStr) || isSuccess.get() || !successPkIdStr.isEmpty() && errorMap.isEmpty()) continue;
                errorObjs.add(objId);
                if (!StringUtils.isNull((String)errorId)) continue;
                errorMap.put(Long.valueOf(objId.toString()), rtn.getMessage());
            }
        }
        int successPkIdSize = successPkIdStr.size();
        int failPkIdSize = errorObjs.size();
        logger.info("\u5355\u636e\u64cd\u4f5c\u8c03\u7528\u7ed3\u679c\uff1ascheduleSchemaId\uff1a{}\uff0csuccessPkIdSize\uff1a{}\uff0cfailPkIdSize\uff1a{}", new Object[]{scheduleSchemaId, successPkIdSize, failPkIdSize});
        this.batchUpdateCache(successPkIdSize, failPkIdSize);
        ScheduleSchemaExecLogDao.batchInsertExceLog(exceOperInfo, count == 0 ? execstartdate : null, Arrays.asList(objs), errorObjs, errorMap, this.traceId);
        return errorObjs.isEmpty() ? ScheduleExecuteStatus.SUCCESS : ScheduleExecuteStatus.FAIL;
    }

    private void batchUpdateCache(int successPkIdSize, int failPkIdSize) {
        ScheduleProposalExecInfo execInfo = this.ctx.getSchemeExecInfo();
        execInfo.appendExecRecord(successPkIdSize, failPkIdSize);
        this.batchUpdateCache();
    }

    @Override
    public void batchUpdateCache() {
        ScheduleProposalExecInfo.execInfoWriteCache(this.ctx.getSchemeExecInfo());
    }

    private void billPKErrorMapping(Map<Object, String> pkErrorMap, List<IOperateInfo> errorInfoList) {
        for (IOperateInfo ori : errorInfoList) {
            Object pk = Optional.ofNullable(ori.getPkValue()).orElse("0");
            String error = ori.getMessage();
            String value = pkErrorMap.get(pk);
            if (value != null) {
                String newError = value + ";" + error;
                pkErrorMap.put(pk, newError);
                continue;
            }
            pkErrorMap.put(pk, error);
        }
    }

    protected abstract OperationResult invokeOperation(Object[] var1, OperateOption var2);

    private static QFilter[] filterTransformation(QFilter filter, MainEntityType vmeta) {
        QFilter[] newFilter = filter.recombine();
        HashMap<Integer, QFilter> replaceFilter = new HashMap<Integer, QFilter>(2);
        for (int i = 0; i < newFilter.length; ++i) {
            String[] ps;
            DynamicProperty dp;
            String p;
            QFilter m = newFilter[i];
            List nests = m.getNests(false);
            if (nests.size() != 0 || (p = m.getProperty()).indexOf(46) == -1 || !((dp = vmeta.getProperty((ps = p.split("\\."))[0])) instanceof BasedataProp)) continue;
            BasedataProp bp = (BasedataProp)dp;
            QFilter baseQ = m.copy();
            baseQ.__setProperty(p.substring(p.indexOf(46) + 1));
            List baseIds = QueryServiceHelper.queryPrimaryKeys((String)bp.getBaseEntityId(), (QFilter[])baseQ.toArray(), null, (int)-1);
            if (baseIds.size() >= 100000) continue;
            QFilter newQ = new QFilter(ps[0], "in", (Object)baseIds);
            replaceFilter.put(i, newQ);
        }
        for (Map.Entry me : replaceFilter.entrySet()) {
            newFilter[((Integer)me.getKey()).intValue()] = (QFilter)me.getValue();
        }
        return newFilter;
    }
}

