/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;

public class TaskProgressClick
extends AbstractTaskClick {
    private static final String CACHEKEY_TASKID = "taskflow_taskid";
    private static final String TASKFLOW = "taskflow";

    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo == null) {
            return;
        }
        this.showExecuteProgress(taskInfo);
        IFormView view = this.getParentView();
        if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
            this.getMainView().sendFormAction(view);
        }
    }

    private void showExecuteProgress(TaskInfo taskInfo) {
        String taskInfoData;
        IFormView view = this.getParentView();
        if (view == null) {
            view = this.getMainView();
        }
        if ((taskInfoData = taskInfo.getData()) != null) {
            Map resultData = (Map)SerializationUtils.fromJsonString((String)taskInfoData, Map.class);
            FormShowParameter sp = new FormShowParameter();
            sp.setFormId("fcs_taskexecute_progress");
            sp.getOpenStyle().setShowType(ShowType.RobotAutoFloat);
            sp.setHasRight(true);
            sp.getCustomParams().put(TASKFLOW, resultData.get(TASKFLOW));
            sp.getCustomParams().put(CACHEKEY_TASKID, taskInfo.getId());
            view.showForm(sp);
        }
    }
}

