/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.tmc.enums.ScheduleExecuteStatus;
import kd.bos.ext.tmc.task.MessageService;
import kd.bos.ext.tmc.utils.ScheduleExecuteUtil;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ScheduleTaskExecutor {
    private static final Log logger = LogFactory.getLog(ScheduleTaskExecutor.class);
    private String mainTaskId;
    private DynamicObject sch;
    private DynamicObject schLog;
    private static final int WAIT_STEP_SECOND = 5;
    private static final int WAIT_RETRY_TIMES = 3;

    public ScheduleTaskExecutor(String mainTaskId, DynamicObject sch, DynamicObject schLog) {
        this.mainTaskId = mainTaskId;
        this.sch = sch;
        schLog.getDynamicObjectCollection("entryentity").clear();
        this.schLog = schLog;
    }

    public void execute() {
        logger.info("mainTask {} start main task {}", (Object)this.mainTaskId, this.sch.getPkValue());
        DynamicObjectCollection taskEntity = this.sch.getDynamicObjectCollection("taskentry");
        for (DynamicObject task : taskEntity) {
            boolean res = this.executeTask(task);
            if (res) continue;
            DynamicObject scheJob = task.getDynamicObject("schejob");
            logger.error("mainTask {} fail by task {}", (Object)this.mainTaskId, (Object)scheJob.getString("classname"));
            return;
        }
        logger.info("mainTask {} end main task {}", (Object)this.mainTaskId, this.sch.getPkValue());
    }

    private boolean executeTask(DynamicObject task) {
        try {
            JobInfo runtimeJob = this.createRuntimeJob(task);
            boolean localJob = this.isLocalJob(runtimeJob);
            String taskId = this.dispatch(task, localJob, runtimeJob);
            return this.waitTaskWithTimes(localJob, taskId);
        }
        catch (Exception e) {
            logger.error("task unexpected fail", (Throwable)e);
            return false;
        }
    }

    private boolean waitTaskWithTimes(boolean isLocalJob, String taskId) throws InterruptedException {
        for (int tryTime = 0; tryTime < 3; ++tryTime) {
            try {
                return this.waitForTaskFinish(isLocalJob, taskId);
            }
            catch (Exception e) {
                logger.error("waitTaskFinish error", (Throwable)e);
                if (tryTime == 2) {
                    this.schLog = BusinessDataServiceHelper.loadSingle((Object)this.schLog.getPkValue(), (String)"fcs_schedule_log");
                    DynamicObjectCollection logEntry = this.schLog.getDynamicObjectCollection("entryentity");
                    if (null != logEntry && logEntry.size() > 0) {
                        TaskInfo taskInfo = new TaskInfo();
                        taskInfo.setStatus("FAILED");
                        String failureReason = ExceptionUtils.getStackTrace((Throwable)e);
                        failureReason = failureReason.length() > 2000 ? failureReason.substring(0, 1996) + "..." : failureReason;
                        taskInfo.setFailureReason(failureReason);
                        DynamicObject taskLog = (DynamicObject)logEntry.get(logEntry.size() - 1);
                        this.saveTaskResultLog(taskLog, taskInfo);
                    }
                    return false;
                }
                TimeUnit.SECONDS.sleep(5L);
                continue;
            }
        }
        return false;
    }

    private boolean waitForTaskFinish(boolean isLocalJob, String taskId) throws InterruptedException {
        TaskInfo taskInfo;
        while (true) {
            boolean isManualStop;
            if (isManualStop = "stop".equals(ScheduleExecuteUtil.getSchemaFlag(this.sch.getLong("id")))) {
                this.stopTask(isLocalJob, taskId);
                logger.info("schedule proposal is stop by manual");
                taskInfo = new TaskInfo();
                taskInfo.setStatus("ABORTED");
                taskInfo.setFailureReason(ResManager.loadKDString((String)"\u4e2d\u6b62\u6267\u884c", (String)"ScheduleTaskExecutor_0", (String)"bos-ext-tmc", (Object[])new Object[0]));
            } else {
                TimeUnit.SECONDS.sleep(5L);
                taskInfo = this.queryTask(isLocalJob, taskId);
                if (taskInfo == null) continue;
                String data = taskInfo.getData();
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    logger.info("taskId {} return data {}", (Object)taskId, (Object)data);
                }
            }
            if (taskInfo.isTaskEnd()) break;
        }
        logger.info("taskId {} end by status {}, failReason {}", new Object[]{taskId, taskInfo.getStatus(), taskInfo.getFailureReason()});
        this.schLog = BusinessDataServiceHelper.loadSingle((Object)this.schLog.getPkValue(), (String)"fcs_schedule_log");
        List taskList = this.schLog.getDynamicObjectCollection("entryentity").stream().filter(t -> taskId.equals(t.getString("taskid"))).collect(Collectors.toList());
        if (!taskList.isEmpty()) {
            if (taskList.size() > 1) {
                logger.warn("find two same task {}", (Object)taskInfo);
            }
            DynamicObject taskObj = (DynamicObject)taskList.get(taskList.size() - 1);
            this.saveTaskResultLog(taskObj, taskInfo);
        }
        return StringUtils.equalsIgnoreCase((CharSequence)taskInfo.getStatus(), (CharSequence)"COMPLETED");
    }

    private void saveTaskResultLog(DynamicObject log, TaskInfo taskInfo) {
        String execStatus;
        switch (taskInfo.getStatus()) {
            case "COMPLETED": {
                execStatus = ScheduleExecuteStatus.SUCCESS.getStatus();
                break;
            }
            case "ABORTED": {
                execStatus = ScheduleExecuteStatus.STOP.getStatus();
                break;
            }
            default: {
                execStatus = ScheduleExecuteStatus.FAIL.getStatus();
            }
        }
        log.set("executestatus", (Object)execStatus);
        log.set("endtime", (Object)new Date());
        String failureReason = taskInfo.getFailureReason();
        if (StringUtils.isNotBlank((CharSequence)failureReason)) {
            failureReason = failureReason.length() > 2000 ? failureReason.substring(0, 1996) + "..." : failureReason;
            log.set("executedetails", (Object)failureReason);
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"fcs_schedule_log", (DynamicObject[])new DynamicObject[]{this.schLog}, (OperateOption)OperateOption.create());
        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"fcs_scheduledetail_log");
        detail.set("schedule", (Object)this.sch);
        detail.set("creator", this.schLog.get("creator"));
        detail.set("result", (Object)(execStatus.equals(ScheduleExecuteStatus.SUCCESS.getStatus()) ? ScheduleExecuteStatus.SUCCESS.getStatus() : ScheduleExecuteStatus.FAIL.getStatus()));
        detail.set("taskname", log.get("taskname"));
        detail.set("exception", log.get("executedetails"));
        detail.set("executetime", (Object)new Date());
        detail.set("lastexectime", (Object)new Date());
        detail.set("taskid", log.get("taskid"));
        detail.set("opersumlogid", this.schLog.getPkValue());
        OperationServiceHelper.executeOperate((String)"save", (String)"fcs_scheduledetail_log", (DynamicObject[])new DynamicObject[]{detail}, (OperateOption)OperateOption.create());
        if (execStatus.equals(ScheduleExecuteStatus.FAIL.getStatus())) {
            MessageService.sendScheduleTaskErrorMessage(this.sch, log);
        }
    }

    private JobInfo createRuntimeJob(DynamicObject task) {
        DynamicObject scheJob = task.getDynamicObject("schejob");
        String className = scheJob.getString("classname");
        String paramStr = task.getString("paramcontent_tag");
        if (EmptyUtil.isEmpty(paramStr)) {
            paramStr = task.getString("paramcontent");
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(scheJob.getString("appid"));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(this.sch.getLong("executor.id"));
        jobInfo.setName(task.getString("taskname"));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(className);
        jobInfo.setCanStop(Boolean.TRUE);
        if (StringUtils.isNotBlank((CharSequence)paramStr)) {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            HashMap checkMap = new HashMap(paramMap.size() * 2);
            String preKey = "---";
            for (Map.Entry entry : paramMap.entrySet()) {
                String realKey = ((String)entry.getKey()).startsWith(preKey) ? ((String)entry.getKey()).substring(preKey.length()) : (String)entry.getKey();
                checkMap.put(realKey, entry.getValue());
            }
            jobInfo.setParams(checkMap);
        }
        logger.info("create execute job {} class {} param {}", new Object[]{jobInfo.getId(), className, paramStr});
        return jobInfo;
    }

    private boolean isLocalJob(JobInfo jobInfo) {
        try {
            Class taskClass = TypesContainer.getOrRegister((String)jobInfo.getTaskClassname().trim());
            return null != taskClass;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String dispatch(DynamicObject task, boolean isLocalJob, JobInfo jobInfo) {
        String taskId = isLocalJob ? JobClient.dispatch((JobInfo)jobInfo) : ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        DynamicObjectCollection logEntry = this.schLog.getDynamicObjectCollection("entryentity");
        DynamicObject taskLog = logEntry.addNew();
        taskLog.set("seq", task.get("seq"));
        taskLog.set("taskid", (Object)taskId);
        taskLog.set("schejobid", (Object)task.getString("schejob.id"));
        taskLog.set("taskname", (Object)jobInfo.getName());
        taskLog.set("executestatus", (Object)ScheduleExecuteStatus.PROCESSING.getStatus());
        taskLog.set("starttime", (Object)new Date());
        OperationServiceHelper.executeOperate((String)"save", (String)"fcs_schedule_log", (DynamicObject[])new DynamicObject[]{this.schLog}, (OperateOption)OperateOption.create());
        return taskId;
    }

    private TaskInfo queryTask(boolean isLocalJob, String taskId) {
        if (isLocalJob) {
            return JobClient.queryTask((String)taskId);
        }
        return ScheduleServiceHelper.queryTask((String)taskId);
    }

    private void stopTask(boolean isLocalJob, String taskId) {
        if (isLocalJob) {
            JobClient.stopTask((String)taskId);
        } else {
            ScheduleServiceHelper.stopTask((String)taskId);
        }
    }
}

