/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.tmc.dao.ScheduleSchemaExecLogDao;
import kd.bos.ext.tmc.enums.ScheduleExecuteStatus;
import kd.bos.ext.tmc.model.ScheduleExceOperInfo;
import kd.bos.ext.tmc.model.ScheduleProposalExecInfo;

public class ScheduleExecuteUtil {
    private static final String APP_ID = "fcs";

    public static void removeStopFlag(long schemaId) {
        IAppCache cache = AppCache.get((String)APP_ID);
        cache.remove(ScheduleExecuteUtil.getCacheKey(schemaId));
    }

    public static boolean isStopExcute(ScheduleProposalExecInfo schemeExecInfo) {
        ScheduleExceOperInfo exceOperInfo = schemeExecInfo.getExceOperInfo();
        if (exceOperInfo.isStopRuning()) {
            return true;
        }
        boolean isManualStop = "stop".equals(ScheduleExecuteUtil.getSchemaFlag(exceOperInfo.getSchemaId()));
        exceOperInfo.setStopRuning(isManualStop);
        if (exceOperInfo.isStopRuning()) {
            ScheduleSchemaExecLogDao.stopExecuteSchema(schemeExecInfo);
            schemeExecInfo.setExecuteStatus(ScheduleExecuteStatus.STOP);
        }
        return exceOperInfo.isStopRuning();
    }

    public static Integer getSecondByTime() {
        Date d = new Date();
        SimpleDateFormat sbf = new SimpleDateFormat("HH:mm:ss");
        String format = sbf.format(d);
        String[] split = format.split(":");
        return Integer.parseInt(split[0]) * 3600 + Integer.parseInt(split[1]) * 60 + Integer.parseInt(split[2]);
    }

    public static String getSchemaFlag(long schemaId) {
        IAppCache cache = AppCache.get((String)APP_ID);
        return (String)cache.get(ScheduleExecuteUtil.getCacheKey(schemaId), String.class);
    }

    public static String getCacheKey(long schemaId) {
        return "fcs-scheduleproposal-" + schemaId + "stop-flag";
    }
}

