/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.tmc.operate.CommitToBe;
import kd.bos.ext.tmc.plugin.BankInputPasswordPlugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class BankPasswordHelper {
    public static void checkBankPwd(AbstractOperate operate, IFormPlugin iFormPlugin, IFormView view, String operateKey, OperateOption option) {
        String className = operate != null ? CommitToBe.class.getName() : BankInputPasswordPlugin.class.getName();
        Long userPK = RequestContext.get().getCurrUserId();
        QFilter[] qFilters = new QFilter[]{new QFilter("user", "=", (Object)userPK)};
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cas_banketppwd");
        boolean containDate = type.getProperties().containsKey((Object)"psweffectivedate");
        String selectField = containDate ? "id,user,password,psweffectivedate" : "id,user,password";
        DynamicObjectCollection bankPassword = QueryServiceHelper.query((String)"cas_banketppwd", (String)selectField, (QFilter[])qFilters);
        if (bankPassword != null && !bankPassword.isEmpty()) {
            boolean checkPass = true;
            String appId = AppMetadataCache.getAppInfo((String)"bei").getId();
            Map params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam(appId, "08", Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L)));
            boolean bei017 = params.getOrDefault("bei017", false);
            if (containDate && bei017) {
                int bei023 = params.getOrDefault("bei023", 90);
                Date pswEffectiveDate = ((DynamicObject)bankPassword.get(0)).getDate("psweffectivedate");
                if (bei023 > 0 && pswEffectiveDate != null) {
                    long days = (new Date().getTime() - pswEffectiveDate.getTime()) / 86400000L;
                    if (days >= (long)bei023) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\uff0c\u5bc6\u7801\u63a7\u5236\u7b56\u7565\u53c2\u6570\u4f4d\u4e8e\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011-\u3010\u516c\u5171\u8bbe\u7f6e\u3011-\u3010\u94f6\u4f01\u4e92\u8054\u3011-\u201c\u542f\u7528\u94f6\u4f01\u5bc6\u7801\u63a7\u5236\u7b56\u7565\u201d\u3002", (String)"CommitToBe_2", (String)"bos-ext-tmc", (Object[])new Object[0]));
                        view.getPageCache().put("realopkey", operateKey);
                        view.getPageCache().put("oldoption", SerializationUtils.serializeToBase64((Object)option));
                        BankPasswordHelper.showPwdForm(className, "cas_bankupdatepwd", view);
                        checkPass = false;
                    } else {
                        int bei024 = params.getOrDefault("bei024", 7);
                        if (bei024 > 0) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(pswEffectiveDate);
                            calendar.add(5, bei023);
                            Date expireDate = calendar.getTime();
                            days = (expireDate.getTime() - new Date().getTime()) / 86400000L + 1L;
                            if ((long)bei024 >= days) {
                                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(6);
                                btnNameMaps.put(6, ResManager.loadKDString((String)"\u4fee\u6539\u5bc6\u7801", (String)"CommitToBe_4", (String)"bos-ext-tmc", (Object[])new Object[0]));
                                btnNameMaps.put(7, ResManager.loadKDString((String)"\u7ee7\u7eed\u63d0\u4ea4", (String)"CommitToBe_5", (String)"bos-ext-tmc", (Object[])new Object[0]));
                                ConfirmCallBackListener updatePwdListener = operate == null ? new ConfirmCallBackListener("updatePwd", iFormPlugin) : new ConfirmCallBackListener("updatePwd", operate);
                                view.showConfirm(ResManager.loadKDString((String)"\u5bc6\u7801\u5373\u5c06\u4e8e%s\u5929\u540e\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u4fee\u6539\u5bc6\u7801\u3002", (String)"CommitToBe_3", (String)"bos-ext-tmc", (Object[])new Object[]{days}), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, updatePwdListener, btnNameMaps);
                                view.getPageCache().put("realopkey", operateKey);
                                view.getPageCache().put("oldoption", SerializationUtils.serializeToBase64((Object)option));
                                checkPass = false;
                            }
                        }
                    }
                }
            }
            if (checkPass) {
                view.getPageCache().put("realopkey", operateKey);
                view.getPageCache().put("oldoption", SerializationUtils.serializeToBase64((Object)option));
                BankPasswordHelper.showPwdForm(className, "cas_bankinputpwd", view);
            }
        } else {
            BankPasswordHelper.showPwdForm(className, "cas_bankpwdsetting", view);
        }
    }

    public static void showPwdForm(String className, String formId, IFormView view) {
        String callbackId = "";
        long currentTimeMillis = System.currentTimeMillis();
        switch (formId) {
            case "cas_bankinputpwd": {
                callbackId = "KEY_PWD_CALLBACK";
                view.getPageCache().put("randomIdx", String.valueOf(currentTimeMillis));
                break;
            }
            case "cas_bankpwdsetting": {
                callbackId = "KEY_NEWPWD_CALLBACK";
                break;
            }
            case "cas_bankresetpwd": {
                callbackId = "KEY_RESETPWD_CALLBACK";
                break;
            }
            case "cas_bankupdatepwd": {
                callbackId = "KEY_UPDATEPWD_CALLBACK";
            }
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.setCustomParam("randomIdx", (Object)String.valueOf(currentTimeMillis));
        parameter.setCloseCallBack(new CloseCallBack(className, callbackId));
        view.showForm(parameter);
    }
}

