/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper;

import java.util.ArrayList;
import java.util.List;

public class DivideGroupHelper<T> {
    private List<T> allBizDataSet;
    private int threadCount;

    public DivideGroupHelper(List<T> allBizDataSet, int minDealSize, int maxThreadSize) {
        this.threadCount = maxThreadSize;
        if (allBizDataSet.size() < maxThreadSize * minDealSize) {
            this.threadCount = allBizDataSet.size() / minDealSize + 1;
        }
        this.allBizDataSet = allBizDataSet;
    }

    public List<List<T>> getResult() {
        ArrayList<List<T>> groups = new ArrayList<List<T>>(this.threadCount);
        int quantity = this.getGroupSize();
        for (int i = 0; i < this.threadCount; ++i) {
            int from = i * quantity;
            int to = Math.min((i + 1) * quantity, this.allBizDataSet.size());
            groups.add(this.allBizDataSet.subList(from, to));
        }
        return groups;
    }

    private int getGroupSize() {
        if (this.allBizDataSet.size() % this.threadCount == 0) {
            return this.allBizDataSet.size() / this.threadCount;
        }
        return this.allBizDataSet.size() / this.threadCount + 1;
    }
}

