/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.tmc.utils.commitToBe.enums.TmcAppEnum;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.commitToBe.helper.ParameterHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SuspectRepeatHelper {
    private static final String SUSPECT_PAY = "suspect_pay";

    public static String getMessageInfo(Set<Long> billid, List<String> ctrltypeList) {
        DynamicObjectCollection bills = SuspectRepeatHelper.getSuspectBill(billid, ctrltypeList, true);
        if (EmptyUtil.isNoEmpty(bills)) {
            StringBuilder sb = new StringBuilder();
            Map group = bills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.toList()));
            for (Map.Entry bill : group.entrySet()) {
                SuspectRepeatHelper.dealStringBuilderInfo(sb, bill.getValue());
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    public static Map<Object, Object> getControlMessageInfo(Set<Long> idSet) {
        HashMap<Object, Object> returnMap = new HashMap<Object, Object>(16);
        DynamicObjectCollection suspectBills = SuspectRepeatHelper.getSuspectBill(idSet, Collections.singletonList("control"), false);
        Map group = suspectBills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.toList()));
        if (EmptyUtil.isNoEmpty(suspectBills)) {
            for (Map.Entry suspectBill : group.entrySet()) {
                StringBuilder sb = new StringBuilder();
                SuspectRepeatHelper.dealStringBuilderInfo(sb, suspectBill.getValue());
                sb.append("\n");
                returnMap.put(suspectBill.getKey(), sb.toString());
                List collect = Arrays.stream(((DynamicObject)suspectBill.getValue().get(0)).getString("suspectset.landingop").replaceFirst(",", "").split(",")).collect(Collectors.toList());
                returnMap.put("operateKey", collect);
            }
        }
        return returnMap;
    }

    public static Map<Object, Object> getLandingMessageInfo(Set<Long> idSet) {
        HashMap<Object, Object> returnMap = new HashMap<Object, Object>();
        DynamicObjectCollection suspectBills = SuspectRepeatHelper.getSuspectBill(idSet, Collections.singletonList("landing"), true);
        Map group = suspectBills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.toList()));
        if (EmptyUtil.isNoEmpty(suspectBills)) {
            for (Map.Entry suspectBill : group.entrySet()) {
                String sb = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u786e\u8ba4\u7684\u7591\u4f3c\u91cd\u590d\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ed1\u5b9a\u8868\u5355\u63d2\u4ef6\uff0c\u6216\u4eba\u5de5\u5230\u3010\u7591\u4f3c\u91cd\u590d\u5355\u636e\u3011\u5217\u8868\u8fdb\u884c\u786e\u8ba4\u3002\u7591\u4f3c\u91cd\u590d\u5355\u636e\u53f7\uff1a\u201c%1$s\u201d\u3002", (String)"FCS-E-004342", (String)"bos-ext-tmc", (Object[])new Object[]{SuspectRepeatHelper.dealSuspectBillnoInfo(suspectBill.getValue())});
                returnMap.put(suspectBill.getKey(), sb);
                List collect = Arrays.stream(((DynamicObject)suspectBill.getValue().get(0)).getString("suspectset.landingop").replaceFirst(",", "").split(",")).collect(Collectors.toList());
                returnMap.put("operateKey", collect);
            }
        }
        return returnMap;
    }

    private static DynamicObjectCollection getSuspectBill(Set<Long> billid, List<String> ctrltypeList, Boolean addConfirm) {
        QFilter qFilter = new QFilter("billid", "in", billid);
        if (addConfirm.booleanValue()) {
            qFilter.and("confirm", "=", (Object)false);
        }
        qFilter.and("ctrltype", "in", ctrltypeList);
        return QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id,billid,billno,suspectentry,suspectentry.suspectbillentity.name,suspectentry.suspectbillno,suspectset,suspectset.landingop", (QFilter[])qFilter.toArray());
    }

    private static void dealStringBuilderInfo(StringBuilder sb, List<DynamicObject> bill) {
        String billno = bill.get(0).getString("billno");
        sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u7591\u4f3c\u91cd\u590d\uff1a\u3010%1$s\u3011\u4e0e%2$s\u3002", (String)"SuspectRepeatHelper_3", (String)"bos-ext-tmc", (Object[])new Object[]{billno, SuspectRepeatHelper.dealSuspectBillnoInfo(bill)}));
    }

    private static String dealSuspectBillnoInfo(List<DynamicObject> bill) {
        StringBuilder sb = new StringBuilder();
        Map<String, List<DynamicObject>> suspectentrys = bill.stream().collect(Collectors.groupingBy(b -> b.getString("suspectentry.suspectbillentity.name")));
        int size = suspectentrys.size();
        for (Map.Entry<String, List<DynamicObject>> entry : suspectentrys.entrySet()) {
            String suspectBillEntityName = entry.getKey();
            sb.append(suspectBillEntityName);
            sb.append("\uff08");
            List suspectBillnos = entry.getValue().stream().map(s -> s.getString("suspectentry.suspectbillno")).distinct().collect(Collectors.toList());
            for (int i = 0; i < suspectBillnos.size(); ++i) {
                sb.append((String)suspectBillnos.get(i));
                if (i == suspectBillnos.size() - 1) continue;
                sb.append(",");
            }
            sb.append("\uff09");
            if (size <= 1) continue;
            sb.append("\uff0c");
            sb.append(ResManager.loadKDString((String)"\u4e0e", (String)"SuspectRepeatHelper_2", (String)"bos-ext-tmc", (Object[])new Object[0]));
            --size;
        }
        return sb.toString();
    }

    public static boolean suspectPayParamterISTure() {
        String tmcFcsSuspectPay = ParameterHelper.getAppCustomPatameterFromCache(TmcAppEnum.FCS.getId(), SUSPECT_PAY);
        return EmptyUtil.isNoEmpty(tmcFcsSuspectPay) && "true".equals(tmcFcsSuspectPay);
    }

    public static DynamicObject[] deleteInValidSuspectbill(QFilter qFilter, DynamicObject[] bills) {
        HashMap billentityMap = new HashMap(16);
        HashSet<Long> fbillids = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            Map<String, List<DynamicObject>> suspectentry = bill.getDynamicObjectCollection("suspectentry").stream().collect(Collectors.groupingBy(s -> s.getDynamicObject("suspectbillentity").getString("number")));
            for (Map.Entry<String, List<DynamicObject>> suspect : suspectentry.entrySet()) {
                String entryNumber = suspect.getKey();
                if (!billentityMap.containsKey(entryNumber)) {
                    billentityMap.put(entryNumber, new HashSet(16));
                }
                for (DynamicObject suspectEntry : suspect.getValue()) {
                    ((Set)billentityMap.get(entryNumber)).add(suspectEntry.getLong("suspectbillid"));
                }
            }
        }
        Set billentities = billentityMap.keySet();
        if (!billentities.isEmpty()) {
            for (Map.Entry billEntityEntry : billentityMap.entrySet()) {
                String billentity = (String)billEntityEntry.getKey();
                Set suspectBillIds = (Set)billEntityEntry.getValue();
                QFilter qFilterBill = new QFilter("id", "in", (Object)suspectBillIds);
                DynamicObjectCollection allSuspectBills = QueryServiceHelper.query((String)billentity, (String)"id", (QFilter[])new QFilter[]{qFilterBill});
                Set billids = allSuspectBills.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
                HashSet<Long> toDeletebillids = new HashSet<Long>(16);
                for (Long confirmBilllId : suspectBillIds) {
                    if (billids.contains(confirmBilllId)) continue;
                    toDeletebillids.add(confirmBilllId);
                }
                for (DynamicObject bill : bills) {
                    DynamicObjectCollection suspectentry = bill.getDynamicObjectCollection("suspectentry");
                    long fid = bill.getLong("id");
                    Iterator iterator = suspectentry.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        Long suspectbillid = next.getLong("suspectbillid");
                        if (!toDeletebillids.contains(suspectbillid)) continue;
                        iterator.remove();
                        if (suspectentry.size() != 0) continue;
                        fbillids.add(fid);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        DeleteServiceHelper.delete((String)"fcs_suspectbill", (QFilter[])new QFilter[]{new QFilter("id", "in", fbillids)});
        DynamicObjectCollection fcsSuspectBill = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id,suspectset.landingop,billid,billentity", (QFilter[])qFilter.toArray());
        return (DynamicObject[])fcsSuspectBill.toArray((Object[])new DynamicObject[0]);
    }
}

