/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.calendar;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Html;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.DispatchServiceHelper;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.ext.hr.calendar.WorkingCalendar")
public class WorkingCalendar
extends Html {
    private static final Log LOGGER = LogFactory.getLog(WorkingCalendar.class);
    private String newPage;
    private static final String COLON = ":";

    @KSMethod
    @SimplePropertyAttribute(name="NewPage")
    public String getNewPage() {
        return this.newPage;
    }

    public void setNewPage(String newPage) {
        this.newPage = newPage;
    }

    public void bindData(BindingContext object) {
        super.bindData(object);
        Long wpId = (Long)this.getView().getFormShowParameter().getCustomParam("wpId");
        String app = (String)this.getView().getFormShowParameter().getCustomParam("app");
        Map customParamMap = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        this.clientViewProxy.setEntryProperty(this.getKey(), "data", this.getDataByMonth(new Date(), wpId, app, customParamMap));
    }

    public void getDataByMonth(Map<String, String> argMap) {
        Date date;
        String dateStr = argMap.get("date");
        try {
            date = WorkingCalendar.parseDate(dateStr, "yyyy-MM");
        }
        catch (ParseException ex) {
            LOGGER.error(ex.getMessage());
            return;
        }
        Long wpId = Long.valueOf(argMap.get("wpId"));
        String app = argMap.get("app");
        String customParam = argMap.get("params");
        Map customParamMap = null;
        if (!StringUtils.isEmpty((CharSequence)customParam)) {
            customParamMap = (Map)SerializationUtils.fromJsonString((String)customParam, Map.class);
        }
        this.clientViewProxy.setEntryProperty(this.getKey(), "data", this.getDataByMonth(date, wpId, app, customParamMap));
    }

    private Map<String, Object> getDataByMonth(Date month, Long wpId, String app, Map<String, Object> customParamMap) {
        Map<String, String> calendarDataMap = Maps.newHashMapWithExpectedSize((int)16);
        if (wpId != null && wpId > 0L) {
            Map<String, Date> rangeMap = this.getRangeMap(month);
            Date rangeStart = rangeMap.get("rangeStart");
            Date rangeEnd = rangeMap.get("rangeEnd");
            calendarDataMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSCalendarService", (String)"getCalendarData", (Object[])new Object[]{wpId, rangeStart, rangeEnd});
            DynamicObject[] services = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSCalendarService", (String)"getService", (Object[])new Object[0]);
            HashMap toDoMap = Maps.newHashMapWithExpectedSize((int)31);
            for (DynamicObject service : services) {
                Map toDoMapByService;
                if (!StringUtils.isEmpty((CharSequence)app) && !Objects.equals(app, service.getString("app"))) continue;
                try {
                    toDoMapByService = (Map)DispatchServiceHelper.invokeBizService((String)service.getString("cloud"), (String)service.getString("app"), (String)service.getString("service"), (String)service.getString("method"), (Object[])new Object[]{rangeStart, rangeEnd, customParamMap});
                }
                catch (RuntimeException ex) {
                    LOGGER.error("service--error:{}", (Object)ex.getMessage());
                    continue;
                }
                toDoMapByService.forEach((key, value) -> {
                    List toDOList = (List)toDoMap.get(key);
                    if (toDOList != null) {
                        toDOList.addAll(value);
                    } else {
                        toDoMap.put(key, value);
                    }
                });
            }
            this.sortedToDoData(toDoMap);
            this.handleToDoData(toDoMap);
            calendarDataMap.put("toDoData", (String)((Object)toDoMap));
            calendarDataMap.put("wpId", wpId.toString());
            calendarDataMap.put("app", app);
            calendarDataMap.put("params", customParamMap == null ? "" : SerializationUtils.toJsonString(customParamMap));
        }
        InteServiceImpl intService = new InteServiceImpl();
        long currUserId = RequestContext.get().getCurrUserId();
        Map userFormat = intService.getUserFormat(Long.valueOf(currUserId));
        calendarDataMap.put("calendarFormat", (String)userFormat.get("calendarFormat"));
        DynamicObject userTimezone = intService.getUserTimezone(Long.valueOf(currUserId));
        calendarDataMap.put("userTimezone", (String)userTimezone.get("number"));
        calendarDataMap.put("dateFormat", intService.getDateFormat(Long.valueOf(currUserId)));
        return calendarDataMap;
    }

    public void openNewPage(Map<String, String> argMap) {
        String id = argMap.get("id");
        if (!StringUtils.isEmpty((CharSequence)this.newPage)) {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(this.newPage);
            if (!StringUtils.isEmpty((CharSequence)id)) {
                parameter.setPkId((Object)Long.valueOf(id));
            }
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void sortedToDoData(Map<String, List<Map<String, String>>> toDoMap) {
        toDoMap.forEach((key, value) -> value.sort((x1, x2) -> {
            boolean isAll2;
            int startTime = Integer.parseInt((String)x1.get("startTime"));
            int endTime = Integer.parseInt((String)x1.get("endTime"));
            int startTime2 = Integer.parseInt((String)x2.get("startTime"));
            int endTime2 = Integer.parseInt((String)x2.get("endTime"));
            boolean isAll1 = startTime == 0 && endTime == 86399;
            boolean bl = isAll2 = startTime2 == 0 && endTime2 == 86399;
            if (isAll1) {
                return -1;
            }
            if (!isAll2) {
                if (startTime < startTime2) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }));
    }

    private void handleToDoData(Map<String, List<Map<String, String>>> toDoMap) {
        toDoMap.forEach((key, value) -> value.forEach(toDo -> {
            int startTime = Integer.parseInt((String)toDo.get("startTime"));
            int endTime = Integer.parseInt((String)toDo.get("endTime"));
            String timeRange = "";
            timeRange = startTime == 0 && endTime == 86399 ? "all" : this.getTimeRange(startTime) + "-" + this.getTimeRange(endTime);
            toDo.put("timeRange", timeRange);
        }));
    }

    private String getTimeRange(int time) {
        if (time == -1) {
            return "";
        }
        int hour = time / 3600;
        int min = (time - hour * 3600) / 60;
        String minStr = String.valueOf(min);
        if (minStr.length() == 1) {
            minStr = StringUtils.leftPad((String)minStr, (int)2, (char)'0');
        }
        return hour + COLON + minStr;
    }

    private Map<String, Date> getRangeMap(Date month) {
        HashMap rangeMap = Maps.newHashMapWithExpectedSize((int)8);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(month);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        int weekDay = calendar.get(7) - 1;
        if (weekDay == 0) {
            weekDay = 7;
        }
        int lastMonthDay = weekDay - 1;
        calendar.add(5, -lastMonthDay);
        Date rangeStart = calendar.getTime();
        calendar.setTime(month);
        int nextMonthDay = 42 - calendar.getActualMaximum(5) - lastMonthDay;
        calendar.set(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5));
        calendar.add(5, nextMonthDay);
        Date rangeEnd = calendar.getTime();
        rangeMap.put("rangeStart", rangeStart);
        rangeMap.put("rangeEnd", rangeEnd);
        return rangeMap;
    }

    private static Date parseDate(String str, String fmt) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        TimeZone timezone = TimeZone.getDefault();
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(str);
    }
}

