/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.me.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.ext.hr.es.me.dao.dto.EncryptDataFieldAndSqlDto;
import kd.bos.ext.hr.es.me.utils.DbServiceHelper;
import kd.bos.orm.util.CollectionUtils;

public class HrBusinessEncryptDataDao {
    private static final String colon_split = ":";

    public static Map<String, Map<String, String>> getEncryptData(DynamicObjectType dt, Object[] pkArray) {
        List<EncryptDataFieldAndSqlDto> listEncryptDataFieldAndSqlDto = HrBusinessEncryptDataDao.buildEncryptSql(dt, pkArray);
        if (CollectionUtils.isEmpty(listEncryptDataFieldAndSqlDto)) {
            return null;
        }
        String RoutKey = dt.getDBRouteKey();
        HashMap<String, Map<String, String>> mapResult = new HashMap<String, Map<String, String>>(16);
        for (EncryptDataFieldAndSqlDto encryptDataFieldAndSqlDto : listEncryptDataFieldAndSqlDto) {
            Map<String, Map<String, String>> list = HrBusinessEncryptDataDao.queryEncryptData(encryptDataFieldAndSqlDto, RoutKey);
            HrBusinessEncryptDataDao.getNestResult(list, encryptDataFieldAndSqlDto, mapResult);
        }
        return mapResult;
    }

    private static void getNestResult(Map<String, Map<String, String>> mapData, EncryptDataFieldAndSqlDto encryptDataFieldAndSqlDto, Map<String, Map<String, String>> mapResult) {
        for (Map.Entry<String, Map<String, String>> entry : mapData.entrySet()) {
            String keyValue = entry.getKey();
            Map<String, String> map = entry.getValue();
            List<String> fieldList = encryptDataFieldAndSqlDto.getFieldsList();
            Map<String, String> mapNest = mapResult.get(keyValue);
            if (mapNest == null) {
                mapNest = new HashMap<String, String>(16);
            }
            for (String fieldName : fieldList) {
                String[] fieldArray = fieldName.split(colon_split);
                String databaseField = null;
                String key = null;
                if (fieldArray.length != 2) continue;
                databaseField = fieldArray[1];
                key = fieldArray[0];
                if (databaseField.equals(encryptDataFieldAndSqlDto.getKeyAlias())) continue;
                mapNest.put(key, map.get(databaseField));
            }
            mapResult.put(keyValue, mapNest);
        }
    }

    private static List<EncryptDataFieldAndSqlDto> buildEncryptSql(DynamicObjectType dt, Object[] pkArray) {
        if (pkArray == null || dt == null) {
            return null;
        }
        String tableName = dt.getAlias();
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return null;
        }
        HashMap mapTableFields = new HashMap(16);
        boolean hasEncryptField = false;
        for (IDataEntityProperty property : dt.getProperties()) {
            ArrayList<String> fieldsList;
            DynamicSimpleProperty dynamicSimpleProperty;
            boolean isEncrypt;
            if (!(property instanceof DynamicSimpleProperty) || !(isEncrypt = (dynamicSimpleProperty = (DynamicSimpleProperty)property).isEncrypt())) continue;
            String fieldAlias = property.getAlias();
            String filedName = property.getName();
            if (StringUtils.isEmpty((CharSequence)fieldAlias)) continue;
            String tableGroup = property.getTableGroup();
            if (StringUtils.isNotEmpty((CharSequence)tableGroup)) {
                tableName = tableName + "_" + tableGroup;
            }
            if (mapTableFields.containsKey(tableName)) {
                fieldsList = (ArrayList<String>)mapTableFields.get(tableName);
                fieldsList.add(filedName + colon_split + fieldAlias);
            } else {
                fieldsList = new ArrayList<String>(10);
                fieldsList.add(filedName + colon_split + fieldAlias);
                mapTableFields.put(tableName, fieldsList);
            }
            hasEncryptField = true;
        }
        if (!hasEncryptField) {
            return null;
        }
        ISimpleProperty key = dt.getPrimaryKey();
        String keyAlias = key.getAlias();
        String keyFieldName = key.getName();
        if (StringUtils.isEmpty((CharSequence)keyAlias) || StringUtils.isEmpty((CharSequence)keyFieldName)) {
            return null;
        }
        ArrayList<EncryptDataFieldAndSqlDto> listEncryptDataFieldAndSqlDto = new ArrayList<EncryptDataFieldAndSqlDto>(10);
        for (Map.Entry entry : mapTableFields.entrySet()) {
            String newTableName;
            EncryptDataFieldAndSqlDto encryptDataFieldAndSqlDto = new EncryptDataFieldAndSqlDto();
            List list = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)list) || StringUtils.isEmpty((CharSequence)(newTableName = (String)entry.getKey()))) continue;
            encryptDataFieldAndSqlDto.setFieldsList(list);
            ArrayList<String> selectFieldList = new ArrayList<String>(10);
            selectFieldList.add(keyAlias);
            encryptDataFieldAndSqlDto.setKeyAlias(keyAlias);
            for (String field : list) {
                String[] fieldArray = field.split(colon_split);
                String databaseField = null;
                if (fieldArray.length == 2) {
                    databaseField = fieldArray[1];
                } else {
                    if (fieldArray.length != 1) continue;
                    databaseField = fieldArray[0];
                }
                selectFieldList.add(databaseField + "_enp");
            }
            list.add(keyFieldName + colon_split + keyAlias);
            StringBuffer sbSql = new StringBuffer("select ");
            sbSql.append(StringUtils.join((Object[])selectFieldList.toArray(), (String)","));
            sbSql.append(" from ");
            sbSql.append(newTableName);
            sbSql.append(" where ");
            sbSql.append(keyAlias);
            sbSql.append(" in (");
            sbSql.append(StringUtils.join((Object[])pkArray, (String)","));
            sbSql.append(")");
            encryptDataFieldAndSqlDto.setSql(sbSql.toString());
            listEncryptDataFieldAndSqlDto.add(encryptDataFieldAndSqlDto);
        }
        return listEncryptDataFieldAndSqlDto;
    }

    private static Map<String, Map<String, String>> queryEncryptData(final EncryptDataFieldAndSqlDto encryptDataFieldAndSqlDto, String dBRouteKey) {
        final HashMap<String, Map<String, String>> mapData = new HashMap<String, Map<String, String>>(16);
        DbServiceHelper.query(new DBRoute(dBRouteKey), encryptDataFieldAndSqlDto.getSql(), null, new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    List<String> filedList = encryptDataFieldAndSqlDto.getFieldsList();
                    HashMap<String, String> tempMap = new HashMap<String, String>(16);
                    String keyValue = null;
                    for (String fieldName : filedList) {
                        String[] fieldArray = fieldName.split(HrBusinessEncryptDataDao.colon_split);
                        String dbFieldName = null;
                        if (fieldArray.length == 2) {
                            dbFieldName = fieldArray[1];
                        } else {
                            if (fieldArray.length != 1) continue;
                            dbFieldName = fieldArray[0];
                        }
                        if (dbFieldName.equals(encryptDataFieldAndSqlDto.getKeyAlias())) {
                            keyValue = rs.getString(dbFieldName);
                            continue;
                        }
                        tempMap.put(dbFieldName, rs.getString(dbFieldName + "_enp"));
                    }
                    mapData.put(keyValue, tempMap);
                }
                return null;
            }
        });
        return mapData;
    }
}

