/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.me.utils;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DBRoute;
import kd.bos.db.temptable.pk.PKTempTable;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.hr.es.me.utils.DbServiceHelper;
import kd.bos.ext.hr.es.me.vo.NestedBasicDataPropertyVO;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.hugein.HugeInConfig;

public class QFilterUtilHR {
    private static final Set<Class<?>> numberClsSet = new HashSet(16);

    private static boolean isNumber(Class<?> cls) {
        return numberClsSet.contains(cls);
    }

    private static String toSqlValueString(Object value) {
        String v = String.valueOf(value);
        return v.replaceAll("'", "''");
    }

    public static String parametertoString(Object value) {
        QParameter p = QFilterUtilHR.getInQParameter(value);
        if (p == null) {
            return "";
        }
        Object[] params = p.getParameters();
        StringBuilder s = new StringBuilder(params.length * 10);
        for (Object param : params) {
            if (s.length() > 0) {
                s.append(',');
            }
            if (param == null) {
                s.append("''");
                continue;
            }
            Class<?> cls = param.getClass();
            if (QFilterUtilHR.isNumber(cls) || cls == Boolean.class) {
                s.append(param);
                continue;
            }
            if (Date.class.isAssignableFrom(cls)) {
                Date date = (Date)param;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dateString = format.format(date);
                s.append("{ts").append('\'').append(dateString).append('\'').append("}");
                continue;
            }
            if (cls.isArray()) {
                int n = Array.getLength(param);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(QFilterUtilHR.parametertoString(Array.get(param, i)));
                }
                continue;
            }
            s.append('\'').append(QFilterUtilHR.toSqlValueString(param)).append('\'');
        }
        return s.toString();
    }

    static QParameter getInQParameter(Object value) {
        if (value == null) {
            return null;
        }
        Object[] params = QFilterUtilHR.getWithoutDuplicateInValues(value);
        int c = params.length;
        if (c > 0) {
            String sql = QFilterUtilHR.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    static String multiParamsSQL(int c) {
        StringBuilder s = new StringBuilder(c * 2);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append('?');
        }
        return s.toString();
    }

    public static Object[] getWithoutDuplicateInValues(Object values) {
        if (values == null) {
            return null;
        }
        Object[] params = null;
        if (values.getClass().isArray()) {
            int c = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(c);
            for (int i = 0; i < c; ++i) {
                set.add(Array.get(values, i));
            }
            c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Set) {
            params = ((Set)values).toArray(new Object[((Set)values).size()]);
        } else if (values instanceof Collection) {
            HashSet set = new HashSet((Collection)values);
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Iterable) {
            HashSet set = new HashSet(16);
            for (Object item : (Iterable)values) {
                set.add(item);
            }
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else {
            params = new Object[]{values};
        }
        return params;
    }

    public static int getCharacterPosition(String string, int times) {
        Matcher slashMatcher = Pattern.compile(" ").matcher(string);
        int mIdx = 0;
        while (slashMatcher.find() && ++mIdx != times) {
        }
        return slashMatcher.start();
    }

    public static String createTmpTableAndSQL(DBRoute dbRoute, Object[] params, Map<String, PKTempTable> tmpTableMap) {
        PKTempTable tempTable;
        if (params[0] instanceof String) {
            tempTable = PKTempTable.createPKBigString((DBRoute)dbRoute);
            tempTable.insert(Arrays.asList(params));
        } else {
            tempTable = PKTempTable.createPKLong((DBRoute)dbRoute);
            tempTable.insert(Arrays.asList(params));
        }
        String inSQL = " (SELECT FID FROM " + tempTable.getTable() + ") ";
        tmpTableMap.put(tempTable.getTable(), tempTable);
        return inSQL;
    }

    public static QFilter changeBasicDataToSubEntityFilterEx(QFilter qFilter, QueryEntityType queryEntity) {
        String fullPropertyName = qFilter.getProperty();
        String subEntityName = QFilterUtilHR.getSubEntityNameByBasicData(fullPropertyName, queryEntity);
        if (subEntityName != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (QFilterUtilHR.isMainEntityPropery(fullPropertyName, queryEntity).booleanValue()) {
                if (nameKeys.length == 2) {
                    String basicDataName = nameKeys[0];
                    String newPropertyName = fullPropertyName.replace(basicDataName, subEntityName);
                    qFilter.__setProperty(newPropertyName);
                }
            } else if (nameKeys.length == 3) {
                String attributeString = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
                StringBuilder newPropertyNameBuilder = new StringBuilder();
                newPropertyNameBuilder.append(subEntityName).append('.').append(attributeString);
                String newPropertyName = newPropertyNameBuilder.toString();
                qFilter.__setProperty(newPropertyName);
            }
        }
        return qFilter;
    }

    public static String getSubEntityNameBySameBasicData(String entityName, String basicDataName, QueryEntityType queryEntity) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(basicDataName);
        if (dynamicProperty instanceof DynamicComplexProperty) {
            DynamicComplexProperty dynamicComplexProperty = (DynamicComplexProperty)dynamicProperty;
            BasedataProp firstdataProp1 = (BasedataProp)dynamicComplexProperty;
            String basicDataEntityName = firstdataProp1.getBaseEntityId();
            for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
                if (!basicDataEntityName.equalsIgnoreCase(joinEntity.getEntityName())) continue;
                return basicDataEntityName;
            }
        }
        return null;
    }

    public static String getSubEntityNameByBasicData(String fullPropertyName, QueryEntityType queryEntity) {
        if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length != 3) {
                return null;
            }
            return QFilterUtilHR.getSubEntityNameBySameBasicData(nameKeys[0], nameKeys[1], queryEntity);
        }
        String[] nameKeys = fullPropertyName.split("\\.");
        if (nameKeys.length != 2) {
            return null;
        }
        return QFilterUtilHR.getSubEntityNameBySameBasicData(queryEntity.getEntityName(), nameKeys[0], queryEntity);
    }

    public static String getSubEntityName(String fullPropertyName, QueryEntity queryEntity) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String subEntityName = fullPropertyName;
        if (nameKeys.length > 0) {
            subEntityName = nameKeys[0];
        }
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            if (!subEntityName.equalsIgnoreCase(joinEntity.getEntityName())) continue;
            return subEntityName;
        }
        return null;
    }

    public static String getSubEntityName(String fullPropertyName, QueryEntityType queryEntity) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String subEntityName = fullPropertyName;
        if (nameKeys.length > 0) {
            subEntityName = nameKeys[0];
        }
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            if (!subEntityName.equalsIgnoreCase(joinEntity.getEntityName())) continue;
            return subEntityName;
        }
        return null;
    }

    public static Boolean isMainEntityPropery(String fullPropertyName, QueryEntityType queryEntity) {
        String subEntityName = QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity);
        if (subEntityName != null) {
            return false;
        }
        return true;
    }

    public static NestedBasicDataPropertyVO changeSecondLvBDToFirstLvBDByFilterEx(String fullPropertyName, QFilter filter, QueryEntityType queryEntity) {
        if (QFilterUtilHR.isNestedBasicData(fullPropertyName, queryEntity).booleanValue()) {
            if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
                String[] nameKeys = fullPropertyName.split("\\.");
                return QFilterUtilHR.changeFirstLvBDFromSecondLvBDEx(nameKeys[1], nameKeys[2], nameKeys[0], filter, queryEntity);
            }
            String[] nameKeys = fullPropertyName.split("\\.");
            return QFilterUtilHR.changeFirstLvBDFromSecondLvBDEx(nameKeys[0], nameKeys[1], queryEntity.getEntityName(), filter, queryEntity);
        }
        if (QFilterUtilHR.isNormaldBasicData(fullPropertyName, queryEntity).booleanValue()) {
            if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
                String[] nameKeys = fullPropertyName.split("\\.");
                return QFilterUtilHR.changeNoramlBDEx(nameKeys[1], nameKeys[0], filter, queryEntity);
            }
            String[] nameKeys = fullPropertyName.split("\\.");
            return QFilterUtilHR.changeNoramlBDEx(nameKeys[0], queryEntity.getEntityName(), filter, queryEntity);
        }
        return null;
    }

    public static Boolean isNormaldBasicData(String fullPropertyName, QueryEntityType queryEntity) {
        if (QFilterUtilHR.isMainEntityPropery(fullPropertyName, queryEntity).booleanValue()) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length == 2) {
                return true;
            }
            return false;
        }
        if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length == 3) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Boolean isNestedBasicData(String fullPropertyName, QueryEntityType queryEntity) {
        if (QFilterUtilHR.isMainEntityPropery(fullPropertyName, queryEntity).booleanValue()) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length == 3) {
                return true;
            }
            return false;
        }
        if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length == 4) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static NestedBasicDataPropertyVO changeFirstLvBDFromSecondLvBDEx(String firstBDName, String secondBDName, String entityName, QFilter filter, QueryEntityType queryEntity) {
        QFilter filterNew;
        String fullPropertyName = filter.getProperty();
        NestedBasicDataPropertyVO netstedBDVo = QFilterUtilHR.convertNestedBasicDataName(firstBDName, secondBDName, entityName);
        String attributeName = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
        DbServiceHelper serviceHelper = new DbServiceHelper(netstedBDVo.secondBDEntityName);
        QFilter qFilter = new QFilter(attributeName, filter.getCP(), filter.getValue());
        HashSet<Long> secondIDSets = new HashSet<Long>(16);
        DynamicObject[] baseDataList = serviceHelper.query(new QFilter[]{qFilter});
        for (int i = 0; i < baseDataList.length; ++i) {
            DynamicObject object = baseDataList[i];
            Long id = object.getLong("id");
            secondIDSets.add(id);
        }
        netstedBDVo.filter = filterNew = QFilterUtilHR.changeFirstLvBDFromSecondLvBDSub(firstBDName, secondBDName, entityName, secondIDSets, netstedBDVo.firstBDEntityName, netstedBDVo.secondBDEntityName, queryEntity);
        if (filterNew != null) {
            MainEntityType dataEntityType;
            netstedBDVo.mainEntityType = dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicProperty dynamicProperty = dataEntityType.getProperty(firstBDName);
            netstedBDVo.dataEntityProperty = dynamicProperty;
        }
        return netstedBDVo;
    }

    public static NestedBasicDataPropertyVO convertNestedBasicDataName(String firstBDName, String secondBDName, String entityName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(firstBDName);
        NestedBasicDataPropertyVO vo = new NestedBasicDataPropertyVO();
        if (dynamicProperty instanceof DynamicComplexProperty) {
            String firstBDEntityName;
            DynamicComplexProperty dynamicComplexProperty = (DynamicComplexProperty)dynamicProperty;
            MainEntityType subEntityType = (MainEntityType)((DynamicComplexProperty)dynamicProperty).getComplexType();
            BasedataProp firstdataProp1 = (BasedataProp)dynamicComplexProperty;
            vo.firstBDEntityName = firstBDEntityName = firstdataProp1.getBaseEntityId();
            DynamicProperty dynamicProperty2 = subEntityType.getProperty(secondBDName);
            if (dynamicProperty2 instanceof DynamicComplexProperty) {
                String secondBDEntityName;
                DynamicComplexProperty dynamicComplexProperty2 = (DynamicComplexProperty)dynamicProperty2;
                BasedataProp basedataProp2 = (BasedataProp)dynamicComplexProperty2;
                vo.secondBDEntityName = secondBDEntityName = basedataProp2.getBaseEntityId();
            }
        }
        vo.entityName = entityName;
        vo.firstBDName = firstBDName;
        vo.secondBDName = secondBDName;
        return vo;
    }

    public static QFilter changeFirstLvBDFromSecondLvBDSub(String firstBDName, String secondBDName, String entityName, Set<Long> secondIDSets, String firstBDEntityName, String secondBDEntityName, QueryEntityType queryEntity) {
        DbServiceHelper serviceHelper = new DbServiceHelper(firstBDEntityName);
        QFilter qFilter = new QFilter(secondBDName, "in", secondIDSets);
        HashSet<Long> firstIDSets = new HashSet<Long>(16);
        DynamicObject[] baseDataList = serviceHelper.query(new QFilter[]{qFilter});
        for (int i = 0; i < baseDataList.length; ++i) {
            DynamicObject object = baseDataList[i];
            Long id = object.getLong("id");
            firstIDSets.add(id);
        }
        StringBuilder fullFilterName = new StringBuilder();
        if (QFilterUtilHR.getSubEntityName(entityName, queryEntity) != null) {
            fullFilterName.append(entityName).append(".");
        }
        fullFilterName.append(firstBDName).append(".id");
        QFilter firstBDFilter = null;
        firstBDFilter = firstIDSets.size() > 0 ? new QFilter(fullFilterName.toString(), "in", firstIDSets) : new QFilter(fullFilterName.toString(), "=", (Object)0);
        return firstBDFilter;
    }

    public static NestedBasicDataPropertyVO changeNoramlBDEx(String BasicDataName, String entityName, QFilter filter, QueryEntityType queryEntity) {
        String fullPropertyName = filter.getProperty();
        NestedBasicDataPropertyVO vo = null;
        String attributeName = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(BasicDataName);
        if (dynamicProperty instanceof DynamicComplexProperty) {
            vo = new NestedBasicDataPropertyVO();
            if (attributeName.equalsIgnoreCase("id")) {
                vo.filter = filter;
                vo.mainEntityType = dataEntityType;
                vo.dataEntityProperty = dynamicProperty;
                return vo;
            }
            BasedataProp firstdataProp = (BasedataProp)dynamicProperty;
            String BasicDataEntityName = firstdataProp.getBaseEntityId();
            QFilter qFilter = new QFilter(attributeName, filter.getCP(), filter.getValue());
            HashSet<Long> basicDataIDSets = new HashSet<Long>(16);
            DbServiceHelper serviceHelper = new DbServiceHelper(BasicDataEntityName);
            DynamicObject[] baseDataList = serviceHelper.query(new QFilter[]{qFilter});
            for (int i = 0; i < baseDataList.length; ++i) {
                DynamicObject object = baseDataList[i];
                Long id = object.getLong("id");
                basicDataIDSets.add(id);
            }
            StringBuilder fullFilterName = new StringBuilder();
            if (QFilterUtilHR.getSubEntityName(entityName, queryEntity) != null) {
                fullFilterName.append(entityName).append(".");
            }
            fullFilterName.append(BasicDataName).append(".id");
            QFilter firstBDFilter = null;
            firstBDFilter = basicDataIDSets.size() > 0 ? new QFilter(fullFilterName.toString(), "in", basicDataIDSets) : new QFilter(fullFilterName.toString(), "=", (Object)0);
            vo.filter = firstBDFilter;
            vo.mainEntityType = dataEntityType;
            vo.dataEntityProperty = dynamicProperty;
        }
        return vo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QFilter convertPermQFilterEx(QFilter filter, QueryEntityType queryEntity) {
        Boolean bSubEntity = true;
        String entityName = QFilterUtilHR.getSubEntityName(filter.getProperty(), queryEntity);
        if (entityName == null) {
            entityName = queryEntity.getEntityName();
            bSubEntity = false;
        }
        String propertyName = filter.getProperty();
        String[] nameKeys = propertyName.split("\\.");
        String attributeName = null;
        if (bSubEntity.booleanValue()) {
            if (nameKeys.length != 2) return filter;
            attributeName = nameKeys[1];
        } else {
            if (nameKeys.length != 1) return filter;
            attributeName = nameKeys[0];
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(attributeName);
        if (!(dynamicProperty instanceof DynamicComplexProperty)) return filter;
        StringBuilder builder = new StringBuilder();
        builder.append(propertyName).append(".id");
        filter.__setProperty(builder.toString());
        return filter;
    }

    public static QFilter[] rebuidFlikeQFilterEx(Map<Integer, List<QFilter>> unionFiltersMap, QFilter[] qFilters, Boolean isFullUnion, QueryEntityType queryEntity) {
        unionFiltersMap.clear();
        ArrayList<QFilter> flikeFilters = new ArrayList<QFilter>();
        for (int i = 0; i < qFilters.length; ++i) {
            QFilter filter = qFilters[i];
            if (filter == null || !"ftlike".equals(filter.getCP())) continue;
            String[] tempArr = String.valueOf(filter.getValue()).split("#");
            String[] propertys = tempArr[0].split(",");
            String[] values = tempArr[1].split("\b");
            QFilter parentFilter = null;
            for (String property : propertys) {
                QFilter subFilter = null;
                for (String value : values) {
                    QFilter qf = new QFilter(property, "like", (Object)("%" + value + "%"));
                    subFilter = subFilter == null ? qf.copy() : subFilter.or(qf);
                    List<QFilter> filterList = unionFiltersMap.get(i);
                    if (filterList == null) {
                        filterList = new ArrayList<QFilter>();
                        unionFiltersMap.put(i, filterList);
                    }
                    Boolean bMerge = false;
                    bMerge = isFullUnion != false ? Boolean.valueOf(false) : QFilterUtilHR.mergeQFilter(filterList, qf, queryEntity);
                    if (bMerge.booleanValue()) continue;
                    filterList.add(qf);
                }
                if (subFilter == null) continue;
                parentFilter = parentFilter == null ? subFilter.copy() : parentFilter.or(subFilter);
            }
            flikeFilters.add(parentFilter);
            qFilters[i] = null;
        }
        return flikeFilters.toArray(new QFilter[flikeFilters.size()]);
    }

    public static Boolean mergeQFilter(List<QFilter> filterList, QFilter qf, QueryEntityType queryEntity) {
        Boolean bMerge = false;
        for (QFilter unionFilter : filterList) {
            String[] nameKeys2;
            if (QFilterUtilHR.isMainEntityPropery(unionFilter.getProperty(), queryEntity).booleanValue() && QFilterUtilHR.isMainEntityPropery(qf.getProperty(), queryEntity).booleanValue()) {
                unionFilter.or(qf);
                bMerge = true;
                break;
            }
            String[] nameKeys1 = unionFilter.getProperty().split("\\.");
            if (!nameKeys1[0].equalsIgnoreCase((nameKeys2 = qf.getProperty().split("\\."))[0])) continue;
            unionFilter.or(qf);
            bMerge = true;
            break;
        }
        return bMerge;
    }

    static {
        numberClsSet.add(Integer.TYPE);
        numberClsSet.add(Long.TYPE);
        numberClsSet.add(Short.TYPE);
        numberClsSet.add(Float.TYPE);
        numberClsSet.add(Double.TYPE);
        numberClsSet.add(Integer.class);
        numberClsSet.add(Long.class);
        numberClsSet.add(Short.class);
        numberClsSet.add(Float.class);
        numberClsSet.add(Double.class);
        numberClsSet.add(BigDecimal.class);
    }
}

