/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.metadata.edit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.metadata.prop.QueryProp;
import kd.bos.ext.hr.service.query.QueryEntityHelper;
import kd.bos.ext.hr.util.FLikeTransUtil;
import kd.bos.ext.hr.util.FastQueryUtil;
import kd.bos.filter.ICustomController;
import kd.bos.form.BindingContext;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;

@DataEntityTypeAttribute(name="kd.bos.ext.hr.metadata.edit.QueryEdit")
public class QueryEdit
extends BasedataEdit
implements ICloseCallBack {
    private static final Log LOGGER = LogFactory.getLog(QueryEdit.class);
    private static final String BOS_EXT_HR = "bos-ext-hr";
    private List<Consumer<BeforeF7ViewDetailEvent>> beforeF7ViewDetailListeners = new ArrayList<Consumer<BeforeF7ViewDetailEvent>>();
    private String listModel = "list";
    private boolean preciseSearch;
    private String treeFormId;
    private String billFormId;
    private String viewDetailList;
    private QFilter matchSearchFilter = null;
    private List<Plugin> basedataControllers = new ArrayList<Plugin>();

    @SimplePropertyAttribute(name="listModel")
    public String getListModel() {
        return this.listModel;
    }

    public void setListModel(String listModel) {
        this.listModel = listModel;
    }

    @SimplePropertyAttribute(name="preciseSearch")
    public boolean isPreciseSearch() {
        return this.preciseSearch;
    }

    public void setPreciseSearch(boolean preciseSearch) {
        this.preciseSearch = preciseSearch;
    }

    @SimplePropertyAttribute(name="treeFormId")
    public String getTreeFormId() {
        return this.treeFormId;
    }

    public void setTreeFormId(String treeFormId) {
        this.treeFormId = treeFormId;
    }

    @SimplePropertyAttribute(name="billFormId")
    public String getBillFormId() {
        return this.billFormId;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
    }

    @SimplePropertyAttribute(name="viewDetailList")
    public String getViewDetailList() {
        return this.viewDetailList;
    }

    public void setViewDetailList(String viewDetailList) {
        this.viewDetailList = viewDetailList;
    }

    @CollectionPropertyAttribute(name="BasedataControllers", collectionItemPropertyType=Plugin.class)
    public List<Plugin> getBasedataControllers() {
        return this.basedataControllers;
    }

    public void setBasedataControllers(List<Plugin> basedataControllers) {
        this.basedataControllers = basedataControllers;
    }

    public List<kd.bos.entity.plugin.Plugin> getBasedataControllersProp() {
        ArrayList plugins = Lists.newArrayListWithExpectedSize((int)this.basedataControllers.size());
        for (Plugin plugin : this.basedataControllers) {
            if (!plugin.isEnabled()) continue;
            kd.bos.entity.plugin.Plugin pl = new kd.bos.entity.plugin.Plugin();
            pl.setClassName(plugin.getClassName());
            pl.setType(plugin.getType());
            pl.setScriptNumber(plugin.getScriptNumber());
            pl.setRowKey(plugin.getRowKey());
            plugins.add(pl);
        }
        Collections.sort(plugins, (o1, o2) -> {
            Integer rowKey1 = o1.getRowKey();
            Integer rowKey2 = o2.getRowKey();
            return rowKey1.compareTo(rowKey2);
        });
        return plugins;
    }

    protected ListShowParameter createAndSetListShowParameter(String sourceMethod) {
        ListShowParameter para;
        if (!this.isF7Click()) {
            BasedataEntityType dt = this.getMainEntityType();
            dt.setBasedataControllersProp(this.getBasedataControllersProp());
        }
        if ((para = super.createAndSetListShowParameter(sourceMethod)) == null) {
            return null;
        }
        if (this.preciseSearch) {
            para.setCustomParam("listmodel", (Object)"search");
            para.setFormId("hrcs_precisequerylistf7");
            if ("hrpi_depempf7querylist".equals(this.billFormId)) {
                para.setFormId("hrpi_personpreciselistf7");
            }
        } else {
            para.setCustomParam("listmodel", (Object)this.listModel);
            para.setFormId("hrcs_querylistf7");
            if ("hrpi_depempf7querylist".equals(this.billFormId)) {
                para.setFormId("hrpi_personquerylistf7");
            }
            if ("soebs_cadrefilef7list".equals(this.billFormId)) {
                para.setFormId("soebs_mngorgtreelistf7");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.billFormId)) {
            para.setBillFormId(this.billFormId);
        }
        if ("tree".equals(this.listModel)) {
            if (StringUtils.isNotEmpty((CharSequence)this.treeFormId)) {
                para.setFormId(this.treeFormId);
            }
            para.setCustomParam("treeType", (Object)"cloudApp");
        }
        para.setCustomParam("nameKey", (Object)this.getNameKey());
        para.setCustomParam("numberKey", (Object)this.getNumberKey());
        if ("getLookUpList".equals(sourceMethod)) {
            para.getListFilterParameter().getOrderBy();
            String orderBy = para.getListFilterParameter().getOrderBy();
            if (StringUtils.isEmpty((CharSequence)orderBy)) {
                QueryProp queryProp = (QueryProp)this.getProperty();
                String numberKey = queryProp.getNumberKey(this.displayProp);
                if (StringUtils.isNotEmpty((CharSequence)orderBy) && StringUtils.isNotEmpty((CharSequence)numberKey)) {
                    orderBy = orderBy + "," + String.format(Locale.ROOT, "%s", numberKey);
                } else if (StringUtils.isNotEmpty((CharSequence)numberKey)) {
                    orderBy = String.format(Locale.ROOT, "%s", numberKey);
                }
            }
            para.getListFilterParameter().setOrderBy(orderBy);
            this.reSetMatchSearchParam(para, sourceMethod);
        }
        return para;
    }

    public void reSetMatchSearchParam(ListShowParameter para, String sourceMethod) {
        if ("getLookUpList".equals(sourceMethod) && this.preciseSearch) {
            List filters = para.getListFilterParameter().getQFilters();
            FLikeTransUtil.ftlikeTransEq(filters);
            this.setMatchSearchFilter(filters);
        }
    }

    public void setMatchSearchFilter(List<QFilter> filters) {
        for (QFilter qFilter : filters) {
            if (this.matchSearchFilter == null) {
                this.matchSearchFilter = qFilter;
                continue;
            }
            this.matchSearchFilter.and(qFilter);
        }
    }

    public QFilter getSearchFilter() {
        if (this.matchSearchFilter != null) {
            return this.matchSearchFilter;
        }
        return super.getSearchFilter();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.getProperty().getParent().getName());
        if (entryGrid == null) {
            super.closedCallBack(event);
            return;
        }
        entryGrid.setStopUpdateCell(true);
        super.closedCallBack(event);
        entryGrid.setStopUpdateCell(false);
        entryGrid.bindData(new BindingContext((Object)this.getModel().getDataEntity()));
    }

    public void viewDetail(Map<String, Object> param) {
        int rowKey = (Integer)param.get("rowKey");
        Object pkObject = this.getPkId(rowKey);
        if (pkObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u57fa\u7840\u8d44\u6599\u3002", (String)"QueryEdit_2", (String)BOS_EXT_HR, (Object[])new Object[0]));
            return;
        }
        BeforeF7ViewDetailEvent beforeF7ViewDetailEvent = new BeforeF7ViewDetailEvent((Object)this, rowKey, pkObject);
        for (Consumer<BeforeF7ViewDetailEvent> consumer : this.beforeF7ViewDetailListeners) {
            consumer.accept(beforeF7ViewDetailEvent);
        }
        if (beforeF7ViewDetailEvent.isCancel()) {
            return;
        }
        String baseEntityId = this.getBaseEntityId();
        Object source = beforeF7ViewDetailEvent.getSource();
        if (source instanceof ItemClassEdit && rowKey != -1) {
            LOGGER.error("((ItemClassEdit) source).getBaseEntityId(rowKey)\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u9700\u8981\u6846\u67b6\u4fee\u6539\u4fee\u9970\u7b26\u6743\u9650\uff01\uff01\uff01");
        }
        String objId = String.valueOf(pkObject);
        String pageId = this.getView().getPageId();
        IFormView view = this.getView().getView(pageId + objId);
        if (Objects.nonNull(view)) {
            IFormView viewNoPlugin;
            Tab tab;
            String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
            if (StringUtils.isBlank((CharSequence)mainPageId)) {
                mainPageId = this.getView().getFormShowParameter().getParentPageId();
            }
            if ((tab = (Tab)(viewNoPlugin = this.getView().getViewNoPlugin(mainPageId)).getControl("_submaintab_")) != null) {
                tab.activeTab(pageId + objId);
                this.getView().sendFormAction(viewNoPlugin);
            }
        } else {
            BillShowParameter parameter;
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)baseEntityId);
            LocaleString caption = formConfig.getCaption();
            IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
            QueryProp property = (QueryProp)this.getProperty();
            DynamicObject baseObject = (DynamicObject)model.getValue(property.getName(), rowKey);
            if (StringUtils.isNotBlank((CharSequence)this.viewDetailList) && "form".equals(FormMetadataCache.getFormConfig((String)this.viewDetailList).getModelType())) {
                parameter = new FormShowParameter();
            } else {
                parameter = new BillShowParameter();
                parameter.setPkId((Object)objId);
                parameter.setBillStatus(BillOperationStatus.VIEW);
            }
            parameter.setFormId(StringUtils.isNotBlank((CharSequence)this.viewDetailList) ? this.viewDetailList : ((QueryEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId)).getEntityName());
            parameter.setCustomParam("id", (Object)objId);
            parameter.setParentFormId(this.view.getFormShowParameter().getParentFormId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(formConfig.getViewShowType());
            if (formConfig.getViewShowType() != ShowType.Modal) {
                parameter.getOpenStyle().setTargetKey("tabap");
            }
            parameter.setPageId(pageId + objId);
            parameter.setCaption(caption.toString() + "-" + baseObject.get(property.getNameKey(this.displayProp)));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private boolean hasLayout() {
        return StringUtils.isNotEmpty((CharSequence)this.getLayoutId());
    }

    protected FuzzySearch buildDefLookUpSetting(BasedataEntityType refBDType) {
        FuzzySearch setting = new FuzzySearch();
        String nameKey = this.getNameKey();
        String numberKey = this.getNumberKey();
        if (StringUtils.isNotBlank((CharSequence)numberKey)) {
            ParameterHelper.addItem((FuzzySearch)setting, (String)numberKey, (String)this.getDisplayName(refBDType, numberKey), (float)156.0f, (boolean)true);
        }
        if (StringUtils.isNotBlank((CharSequence)nameKey) && !nameKey.equals(numberKey)) {
            ParameterHelper.addItem((FuzzySearch)setting, (String)nameKey, (String)this.getDisplayName(refBDType, nameKey), (float)156.0f, (boolean)true);
        }
        return setting;
    }

    protected FuzzySearch loadLookUpSetting(BasedataEntityType refBDType) {
        FuzzySearch setting;
        String cachedKey;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String search = pageCache.get(cachedKey = "searchSetting" + refBDType.getName());
        if (search == null) {
            BillParam billParam = ParameterHelper.getBillParam((String)refBDType.getName());
            setting = billParam.getFuzzySearch() != null ? billParam.getFuzzySearch() : this.buildDefLookUpSetting(refBDType);
            ParameterHelper.addItem((FuzzySearch)setting, (String)refBDType.getPrimaryKey().getName(), (String)"ID", (float)0.0f, (int)-1, (int)0, (boolean)false);
            pageCache.put(cachedKey, SerializationUtils.toJsonString((Object)setting));
        } else {
            setting = (FuzzySearch)SerializationUtils.fromJsonString((String)search, FuzzySearch.class);
        }
        this.setComboFieldCaption(refBDType, setting);
        setting.setDefaultSort(false);
        return setting;
    }

    protected String getNameKey() {
        return ((QueryProp)this.getProperty()).getNameKey(this.displayProp);
    }

    protected String getNumberKey() {
        return ((QueryProp)this.getProperty()).getNumberKey(this.displayProp);
    }

    private String getDisplayName(BasedataEntityType refBDType, String key) {
        String displayName;
        if (key.contains(".")) {
            String[] numbers = key.split("\\.");
            displayName = ((BasedataProp)refBDType.findProperty(numbers[0])).getDynamicComplexPropertyType().getProperty(numbers[1]).getDisplayName().toString();
        } else {
            displayName = refBDType.findProperty(key).getDisplayName().toString();
        }
        return displayName;
    }

    public void getLookUpList(List<Object> list) {
        this.checkNullException();
        if (list != null) {
            BasedataEntityType dt = this.getMainEntityType();
            if (dt == null) {
                this.lookUpListInvoke1(Maps.newHashMapWithExpectedSize((int)4));
                return;
            }
            try {
                this.lookUpListInvoke1(this.getLookUpData(list, dt));
            }
            catch (UnsupportedEncodingException e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private Map<String, Object> getLookUpData(List<Object> list, BasedataEntityType entityType) throws UnsupportedEncodingException {
        String searchKey = (String)list.get(1);
        FuzzySearch setting = this.loadLookUpSetting(entityType);
        int topNumber = this.getDisplayStyle() == 0 ? setting.getPageSize() : 50;
        List<String> showFields = setting.getComboListFields().stream().map(ShowColumn::getId).collect(Collectors.toList());
        List<Object> allData = this.queryLookUpdata(entityType, setting.getSearchFields(), showFields, searchKey.trim(), 0, topNumber, false);
        List queryData = Lists.newArrayListWithExpectedSize((int)16);
        boolean hasNext = false;
        if (!allData.isEmpty()) {
            if (allData.size() < topNumber) {
                topNumber = allData.size();
            } else {
                topNumber = allData.size() - 1;
                hasNext = true;
            }
            for (int i = 0; i < topNumber; ++i) {
                queryData.add(allData.get(i));
            }
        }
        if (this.fuzzySearchListeners != null) {
            BasedataFuzzySearchEvent evt = new BasedataFuzzySearchEvent((Object)this, queryData);
            for (BasedataFuzzySearchListener bl : this.fuzzySearchListeners) {
                bl.handleData(evt);
            }
            queryData = evt.getQueryData();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        map.put("columns", setting.getComboListFields());
        map.put("data", queryData);
        map.put("next", hasNext);
        map.put("k", this.key);
        map.put("size", setting.getPageSize());
        map.put("args", list);
        return map;
    }

    private void lookUpListInvoke1(Map<String, Object> objectMap) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndexByThis();
            objectMap.put("r", rowIndex);
            this.clientViewProxy.invokeControlMethod(this.getEntryKey(), "setLookUpListValue", new Object[]{objectMap});
        } else {
            objectMap.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, "setLookUpListValue", new Object[]{objectMap});
        }
    }

    private int getCurrentRowIndexByThis() {
        int index = -1;
        if (this.isEntryProperty(this.getProperty())) {
            index = this.getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        }
        return index;
    }

    private void checkNullException() {
        if (StringUtils.isBlank((CharSequence)this.getBaseEntityId())) {
            String name = ((Object)((Object)this)).getClass().getName();
            throw new KDBizException(name);
        }
        if (FormMetadataCache.getListFormConfig((String)this.getBaseEntityId()) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u672a\u8bbe\u8ba1F7\u5217\u8868\u3002", (String)"ExactMatchBasedataEdit_1", (String)BOS_EXT_HR, (Object[])new Object[0]));
        }
    }

    private QFilter getSearchFilter(String searchKey, List<String> searchFields, String entityName) {
        QFilter searchQFilter = null;
        if (StringUtils.isNotBlank((CharSequence)searchKey) && !searchFields.isEmpty()) {
            Map pubSysParam = ParameterReader.loadBillParameterObjectFromCache((String)entityName);
            String searchtype = "1";
            if (pubSysParam != null) {
                searchtype = (String)pubSysParam.get("searchtype");
            }
            String finalSearchKey = searchKey;
            if ("2".equals(searchtype)) {
                finalSearchKey = searchKey + "%";
            }
            searchFields = new ArrayList<String>(searchFields);
            List<String> encryptFields = this.splitEncryptProp(searchFields);
            searchQFilter = QFilter.ftlike((String)finalSearchKey, (String[])searchFields.toArray(new String[0]));
            for (String encryptField : encryptFields) {
                searchQFilter.or(new QFilter(encryptField, "=", (Object)searchKey));
            }
        }
        return searchQFilter;
    }

    private List<String> splitEncryptProp(List<String> searchFields) {
        QueryEntityType queryEntityType = (QueryEntityType)this.getMainEntityType();
        ArrayList<String> encryptFields = new ArrayList<String>(6);
        Iterator<String> iterator = searchFields.iterator();
        while (iterator.hasNext()) {
            boolean isEncrypt;
            String searchField = iterator.next();
            IDataEntityProperty prop = queryEntityType.findProperty(searchField);
            if (prop == null && (prop = this.getAssEntityProp(queryEntityType, searchField)) == null) {
                String newField = searchField;
                String[] field = searchField.split("\\.");
                if (searchField.contains(".")) {
                    for (JoinEntity joinEntity : queryEntityType.getJoinEntitys()) {
                        if (!"id".equals(joinEntity.getProperty()) || !field[0].equals(joinEntity.getFKProperty())) continue;
                        newField = joinEntity.getEntityName() + "." + field[1];
                        break;
                    }
                }
                prop = this.getAssEntityProp(queryEntityType, newField);
            }
            if (!(isEncrypt = PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)prop))) continue;
            iterator.remove();
            encryptFields.add(searchField);
        }
        return encryptFields;
    }

    public void showMore(String searchValue) {
        BasedataEntityType dt = this.getMainEntityType();
        if (dt != null) {
            FuzzySearch setting = this.loadLookUpSetting(dt);
            setting.setSearchFields(new ArrayList());
            HashMap searchValueMap = Maps.newHashMapWithExpectedSize((int)4);
            ArrayList valueList = Lists.newArrayListWithExpectedSize((int)4);
            if (!StringUtils.isBlank((CharSequence)searchValue)) {
                valueList.add(searchValue);
                searchValueMap.put("quanbu_id_6ab82085_7ef3_4a6d_9ad9_b02e54bfb06f", valueList);
            }
            this.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("searchValueMap", (Object)searchValueMap);
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("searchFields", (Object)setting.getSearchFields());
            });
            this.click();
        }
    }

    private IDataEntityProperty getAssEntityProp(QueryEntityType queryEntityType, String field) {
        MainEntityType subEntityType;
        String subEntityName = this.getSubEntityName(field, queryEntityType);
        if (org.apache.commons.lang.StringUtils.isEmpty((String)subEntityName) || (subEntityType = EntityMetadataCache.getDataEntityType((String)subEntityName)) == null) {
            return null;
        }
        String[] nameKeys = field.split("\\.");
        String prex = nameKeys[0] + ".";
        if (!field.contains(prex)) {
            return null;
        }
        String newPropertyName = field.replace(prex, "");
        return subEntityType.findProperty(newPropertyName);
    }

    private String getSubEntityName(String fullPropertyName, QueryEntityType queryEntity) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String subEntityName = fullPropertyName;
        if (nameKeys.length > 0) {
            subEntityName = nameKeys[0];
        }
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            if (!subEntityName.equalsIgnoreCase(joinEntity.getEntityName())) continue;
            return subEntityName;
        }
        return null;
    }

    private List<Object> queryLookUpdata(BasedataEntityType basedataEntityType, List<String> searchFields, List<String> showFields, String fullSearchKey, int start, int limit, boolean defaultSort) throws UnsupportedEncodingException {
        ArrayList data = Lists.newArrayListWithExpectedSize((int)16);
        String entityName = basedataEntityType.getName();
        this.setMatchSearchFilter(Collections.singletonList(this.getSearchFilter(fullSearchKey, searchFields, entityName)));
        ListShowParameter listShowParameter = this.createAndSetListShowParameter("getLookUpList");
        if (listShowParameter == null) {
            return data;
        }
        String customControllerProperty = basedataEntityType.getCustomControllerProperty();
        if (customControllerProperty != null) {
            try {
                Class<?> clz = Class.forName(customControllerProperty);
                Object cl = clz.newInstance();
                if (cl instanceof ICustomController) {
                    ICustomController controller = (ICustomController)cl;
                    controller.setCustomQFilters(listShowParameter);
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25\u3002", (String)"ExactMatchBasedataEdit_2", (String)BOS_EXT_HR, (Object[])new Object[0]));
            }
        }
        this.queryLookUpdataSub(searchFields, showFields, fullSearchKey, start, limit, defaultSort, data, entityName, listShowParameter);
        return data;
    }

    private void queryLookUpdataSub(List<String> searchFields, List<String> showFields, String fullSearchKey, int start, int limit, boolean defaultSort, List<Object> data, String entityName, ListShowParameter listShowParameter) throws UnsupportedEncodingException {
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        if (!searchFields.isEmpty()) {
            QueryEntityType queryEntityType = (QueryEntityType)this.getMainEntityType();
            HashMap fieldIndexMap = Maps.newHashMapWithExpectedSize((int)3);
            ArrayList newFields = Lists.newArrayListWithExpectedSize((int)showFields.size());
            int keyFieldsCount = 3;
            Iterator<String> iterator = showFields.iterator();
            while (iterator.hasNext()) {
                String sField;
                String newField = sField = iterator.next();
                String[] field = sField.split("\\.");
                if (sField.contains(".")) {
                    for (JoinEntity joinEntity : queryEntityType.getJoinEntitys()) {
                        if (!"id".equals(joinEntity.getProperty()) || !field[0].equals(joinEntity.getFKProperty())) continue;
                        newField = joinEntity.getEntityName() + "." + field[1];
                    }
                }
                if (sField.equals(queryEntityType.getPrimaryKey().getName())) {
                    fieldIndexMap.put(newField, 0);
                    newFields.add(newField);
                    continue;
                }
                if (sField.endsWith(queryEntityType.getNumberProperty())) {
                    fieldIndexMap.put(newField, 1);
                    newFields.add(newField);
                    continue;
                }
                if (sField.endsWith(queryEntityType.getNameProperty())) {
                    fieldIndexMap.put(newField, 2);
                    newFields.add(newField);
                    continue;
                }
                ++keyFieldsCount;
            }
            String orderBy = listShowParameter.getListFilterParameter().getOrderBy();
            if (defaultSort) {
                if (StringUtils.isNotEmpty((CharSequence)orderBy) && StringUtils.isNotEmpty((CharSequence)queryEntityType.getNumberProperty())) {
                    orderBy = orderBy + "," + String.format(Locale.ROOT, "%s", queryEntityType.getNumberProperty());
                } else if (StringUtils.isEmpty((CharSequence)orderBy) && StringUtils.isNotEmpty((CharSequence)queryEntityType.getNumberProperty())) {
                    orderBy = String.format(Locale.ROOT, "%s", queryEntityType.getNumberProperty());
                }
            }
            DynamicObjectCollection queryCollection = QueryEntityHelper.getInstance().getQueryDyoColl(queryEntityType, String.join((CharSequence)",", newFields), filters.toArray(new QFilter[0]), orderBy, start, limit);
            FastQueryUtil.assembleData(newFields, start, limit, data, fieldIndexMap, queryCollection, keyFieldsCount);
        }
    }
}

