/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.metadata.form.control;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Html;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.ext.hr.metadata.form.control.Hint")
public class Hint
extends Html {
    private static final Log LOGGER = LogFactory.getLog(Hint.class);
    private String hintContent;
    private boolean hintScrollAp;
    private boolean hintExpandAp;
    private static final String CONTENT_KEY = "content";
    private static final String NUMBER_KEY = "no";
    private static final String POP_WIN = "pop";
    private static final String VAR_REGEX = "\u2460#\\{([\\s\\S]*?)}#";
    private static final String DIY_VAR_REGEX = "\u2461#\\{([\\s\\S]*?)}#";
    private static final String TIP_REGEX = "\u2462#\\{([\\s\\S]*?)}#";
    private static final String DIY_WIN_REGEX = "\u2463#\\{([\\s\\S]*?)}#";

    @KSMethod
    @SimplePropertyAttribute(name="HtmlContent")
    public String getHintContent() {
        return this.hintContent;
    }

    public void setHintContent(String hintContent) {
        this.hintContent = hintContent;
    }

    @KSMethod
    @SimplePropertyAttribute(name="HintScroll")
    public boolean isHintScrollAp() {
        return this.hintScrollAp;
    }

    public void setHintScrollAp(boolean hintScrollAp) {
        this.hintScrollAp = hintScrollAp;
    }

    @KSMethod
    @SimplePropertyAttribute(name="HintExpand")
    public boolean isHintExpandAp() {
        return this.hintExpandAp;
    }

    public void setHintExpandAp(boolean hintExpandAp) {
        this.hintExpandAp = hintExpandAp;
    }

    public void setContent(Long id, String content) {
        DynamicObject[] prompts = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"getPrompts", (Object[])new Object[]{Collections.singletonList(id)});
        if (prompts.length > 0) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put(NUMBER_KEY, prompts[0].getString("number"));
            map.put(CONTENT_KEY, content);
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", (Object)map);
        }
    }

    public void bindData(BindingContext ctx) {
        super.bindData(ctx);
        String formId = this.view.getFormShowParameter().getFormConfig().getEntityTypeId();
        Map<String, String> data = this.getData(formId);
        if (CollectionUtils.isEmpty(data)) {
            this.clientViewProxy.setEntryProperty(this.getKey(), "data", (Object)this.hintContent);
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setEntryProperty(this.getKey(), "data", data);
        String content = new ArrayList<String>(data.values()).get(0);
        this.setHintContent(content);
    }

    public void getHintScroll() {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "getHintScroll", new Object[]{this.hintScrollAp});
    }

    public void getIsExpand() {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "expand", new Object[]{this.hintExpandAp});
    }

    public void clickContent(Map<String, String> argMap) {
        String entityId = this.view.getEntityId();
        String type = argMap.get("type");
        String number = argMap.get(NUMBER_KEY);
        if ("tips".equals(type)) {
            DynamicObject prompt = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"getPrompt", (Object[])new Object[]{number});
            if (Objects.equals(POP_WIN, entityId) || prompt == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("entityId:{} ,number:{}", (Object)entityId, (Object)number);
                }
                return;
            }
            this.view.getFormShowParameter().setCustomParam("id", (Object)prompt.getLong("id"));
            this.view.getFormShowParameter().setCustomParam("number", (Object)prompt.getString("number"));
            this.view.getFormShowParameter().setCustomParam("selectcontent", (Object)prompt.getString("selectcontent"));
            Map<String, String> data = this.getData(POP_WIN);
            if (CollectionUtils.isEmpty(data) && !StringUtils.isEmpty((Object)this.hintContent)) {
                data.put("number", prompt.getString("number"));
                data.put(CONTENT_KEY, this.hintContent);
            }
            data.put("name", argMap.get("name"));
            this.clientViewProxy.invokeControlMethod(this.getKey(), "clickContent", new Object[]{data});
        } else if ("diywindow".equals(type)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCaption(argMap.get("name"));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(number);
            this.getView().showForm(parameter);
        }
    }

    private Map<String, String> getData(String formId) {
        String content;
        HashMap<String, String> data = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(TIP_REGEX);
        Pattern winPattern = Pattern.compile(DIY_WIN_REGEX);
        if (Objects.equals(POP_WIN, formId)) {
            String result = (String)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"getContent", (Object[])new Object[]{this.view.getFormShowParameter().getCustomParam("id")});
            if (StringUtils.isEmpty((Object)result)) {
                return data;
            }
            content = result;
            content = this.replaceByPattern(pattern, content);
            content = this.replaceByPattern(Pattern.compile(VAR_REGEX), content);
            content = this.replaceByPattern(winPattern, content);
            content = this.replaceByPattern(Pattern.compile(DIY_VAR_REGEX), content);
            data.put(NUMBER_KEY, (String)this.view.getFormShowParameter().getCustomParam("number"));
        } else {
            DynamicObject toObj = BusinessDataServiceHelper.newDynamicObject((String)formId);
            DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
            for (IDataEntityProperty toPro : toPros) {
                IDataEntityProperty property = this.getModel().getProperty(toPro.getName());
                IDataEntityType pet = property.getParent();
                if (pet instanceof EntryType || toPro instanceof EntryProp) continue;
                Object value = this.getModel().getValue(toPro.getName());
                toObj.set(toPro.getName(), value);
            }
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"queryPromptIdAndContent", (Object[])new Object[]{formId, this.key, toObj});
            if (CollectionUtils.isEmpty((Map)result)) {
                return data;
            }
            Map.Entry firstResult = result.entrySet().iterator().next();
            DynamicObject[] prompts = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"getPrompts", (Object[])new Object[]{Collections.singletonList(firstResult.getKey())});
            content = (String)firstResult.getValue();
            content = this.replaceNotExist(content);
            data.put(NUMBER_KEY, prompts[0].getString("number"));
        }
        data.put(CONTENT_KEY, content);
        return data;
    }

    private String replaceByPattern(Pattern pattern, String content) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String group = matcher.group(0);
            content = content.replace(group, "");
        }
        return content;
    }

    private String replaceNotExist(String content) {
        content = this.handleEmpty(Pattern.compile(TIP_REGEX), content, TIP_REGEX);
        content = this.handleEmpty(Pattern.compile(DIY_WIN_REGEX), content, DIY_WIN_REGEX);
        return content;
    }

    private String handleEmpty(Pattern pattern, String content, String type) {
        if (StringUtils.isEmpty((Object)content)) {
            return "";
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            Map map;
            String group = matcher.group(0);
            try {
                String newGroup = group.substring(2, group.length() - 1);
                map = (Map)SerializationUtils.fromJsonString((String)newGroup, Map.class);
            }
            catch (Exception ex) {
                LOGGER.error((Throwable)ex);
                content = content.replace(group, "");
                continue;
            }
            String number = (String)map.get(NUMBER_KEY);
            String name = (String)map.get("name");
            switch (type) {
                case "\u2462#\\{([\\s\\S]*?)}#": {
                    DynamicObject prompt = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"getPrompt", (Object[])new Object[]{number});
                    if (prompt == null) {
                        content = content.replace(group, "");
                        break;
                    }
                    if (!StringUtils.isEmpty((Object)name)) break;
                    map.put("name", prompt.getString("name"));
                    content = content.replace(group, SerializationUtils.toJsonString((Object)map));
                    break;
                }
                case "\u2463#\\{([\\s\\S]*?)}#": {
                    if (!MetadataDao.checkNumber((String)number)) {
                        content = content.replace(group, "");
                        break;
                    }
                    if (!StringUtils.isEmpty((Object)name)) break;
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)name);
                    map.put("name", dataEntityType.getName());
                    content = content.replace(group, SerializationUtils.toJsonString((Object)map));
                    break;
                }
            }
        }
        return content;
    }
}

