/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.controls;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.controls.ICondition;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;

public abstract class ConditionControl
extends RuleControl
implements ICondition {
    public void openExpressView() {
        this.openExpressView(null);
    }

    public void openExpressView(LinkedHashMap<String, Object> argsJson) {
        FormShowParameter bill = new FormShowParameter();
        bill.setStatus(OperationStatus.VIEW);
        bill.setFormId("brm_express_view");
        bill.getOpenStyle().setShowType(ShowType.Modal);
        bill.setHasRight(true);
        bill.setCustomParam("conditions", (Object)this.getValue());
        if (null != argsJson) {
            bill.setCustomParam("comparisonOpt", (Object)SerializationUtils.toJsonString((Object)argsJson.get("comparisonOpt")));
        }
        bill.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        this.getView().showForm(bill);
    }

    public List<Map<String, String>> getInputParam(Long sceneId) {
        return this.getContainTarget() != false ? this.getInputParamContainTarget(sceneId, this.getShowMoreSceneParams()) : this.getInputParamNoContainTarget(sceneId, this.getShowMoreSceneParams());
    }

    public Map<String, String> getConditionExpress() {
        HashMap conditionExpress = Maps.newHashMapWithExpectedSize((int)2);
        if (StringUtils.isNotEmpty((CharSequence)this.getValue())) {
            RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)this.getValue(), RuleConditionInfo.class);
            conditionExpress.put("value", ruleConditionInfo.getConditionExpressStr());
        } else {
            conditionExpress.put("value", "");
        }
        return conditionExpress;
    }

    @Override
    public void setScene(String scene) {
        super.setScene(scene);
        if (StringUtils.isNotEmpty((CharSequence)scene)) {
            HashMap data = Maps.newHashMapWithExpectedSize((int)2);
            data.put("param", this.getInputParam(Long.parseLong(scene)));
            data.put("valueParam", this.getInputValueParam(Long.parseLong(scene)));
            this.updateControlData(data);
        }
    }

    @Override
    public RuleValidateInfo validate() {
        return RuleValidateUtil.validCondition(this.getValue());
    }
}

