/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.controls;

import com.google.common.collect.Maps;
import java.util.HashMap;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.controls.IResult;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.form.BindingContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;

public abstract class ResultControl
extends RuleControl
implements IResult {
    private static Log LOGGER = LogFactory.getLog(ResultControl.class);
    protected String policy;
    private Boolean paramChange = Boolean.TRUE;

    private HashMap<String, Object> initBindDataMap() {
        return Maps.newHashMapWithExpectedSize((int)16);
    }

    @Override
    public void bindData(BindingContext object) {
        HashMap<String, Object> data = this.initBindDataMap();
        data.put("initing", "true");
        data.put("value", this.getValue(true));
        data.put("comparisonOpt", this.getComparisonOperators());
        data.put("hideButton", this.getHideButton());
        data.put("defaultRows", this.getDefaultRows());
        data.put("showDeleteOnlyOneRow", this.getShowDeleteOnlyOneRow());
        data.put("paramChange", this.getParamChange());
        String pageStatus = this.getView().getPageCache().get("pageStatus");
        if ("view".equals(pageStatus)) {
            data.put("pageState", "VIEW");
        } else {
            String pageState = this.getView().getFormShowParameter().getStatus().name();
            String string = pageState = pageState.equals("ADDNEW") ? "NEW" : pageState;
            if (this.getLock() != null && this.getLock().contains(pageState.toLowerCase())) {
                data.put("pageState", "VIEW");
            }
        }
        if (IDStringUtils.idNotEmpty(this.getScene())) {
            Long sceneId = Long.parseLong(this.getScene());
            data.put("param", this.getOutputParamData(sceneId));
            data.put("valueParam", this.getInputValueParam(sceneId));
        }
        this.updateControlDataOnInit(data);
        this.setInited(Boolean.TRUE);
    }

    public void setPolicy(String policy) {
        this.policy = policy;
        this.set(policy);
    }

    @KSMethod
    @SimplePropertyAttribute(name="policy")
    public String getPolicy() {
        return this.get(this.policy);
    }

    @KSMethod
    @SimplePropertyAttribute(name="paramChange")
    public Boolean getParamChange() {
        return Boolean.parseBoolean(this.get(this.paramChange.toString()));
    }

    public void setParamChange(Boolean paramChange) {
        this.paramChange = paramChange;
        this.set(paramChange.toString());
    }

    @Override
    public void setScene(String scene) {
        super.setScene(scene);
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("param", this.getOutputParamData(Long.parseLong(scene)));
        data.put("valueParam", this.getInputValueParam(Long.parseLong(scene)));
        this.updateControlData(data);
    }

    public String getValue(boolean updateDisplayName) {
        String value = super.getValue();
        if (StringUtils.isEmpty((CharSequence)value) || !updateDisplayName) {
            return value;
        }
        return RuleUtil.getNewestResultValue(value);
    }
}

