/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.controls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.hr.ruleengine.controls.ICondition;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.ext.hr.ruleengine.helper.RuleEngineHelper;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.FormatUtil;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.ext.hr.ruleengine.controls.RosterCondition")
public class RosterCondition
extends RuleControl
implements ICondition {
    private static Log LOGGER = LogFactory.getLog(RosterCondition.class);
    private String policy;

    @Override
    public void bindData(BindingContext object) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("initing", "true");
        data.put("comparisonOpt", this.getComparisonOperators());
        data.put("value", this.getValue(true));
        data.put("hideButton", this.getHideButton());
        data.put("defaultRows", this.getDefaultRows());
        data.put("showDeleteOnlyOneRow", this.getShowDeleteOnlyOneRow());
        String pageState = this.getView().getFormShowParameter().getStatus().name();
        String string = pageState = pageState.equals("ADDNEW") ? "NEW" : pageState;
        if (this.getLock() != null && this.getLock().contains(pageState.toLowerCase())) {
            data.put("pageState", "VIEW");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getScene())) {
            data.put("param", this.getInputParamNoContainTarget(Long.parseLong(this.getScene())));
        }
        this.updateControlDataOnInit(data);
        this.setInited(Boolean.TRUE);
    }

    @Override
    public RuleValidateInfo validate() {
        return RuleValidateUtil.validRosterCondition(this.getValue());
    }

    public void openRosterF7(LinkedHashMap<String, Object> argsJson) {
        String index = argsJson.get("index").toString();
        String rosterCategory = argsJson.get("rosterCategory").toString();
        if (StringUtils.isEmpty((CharSequence)rosterCategory)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7c7b\u578b\u7684\u540d\u5355", (String)"RosterCondition_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            return;
        }
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"brm_special_list", (boolean)false, (int)0, (boolean)true);
        QFilter categoryFilter = ParamTypeEnum.STRING.getValue().equals(rosterCategory) ? new QFilter("listtype", "=", (Object)"string") : new QFilter("listcategory", "=", (Object)rosterCategory);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{categoryFilter, enableFilter, statusFilter});
        fsp.setListFilterParameter(new ListFilterParameter((List)qFilters, null));
        fsp.setCloseCallBack(new CloseCallBack(this.getClass().getName(), FormatUtil.getActionId(this.getKey(), "openRosterF7CallBack", index)));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setMultiSelect(false);
        fsp.setShowTitle(false);
        fsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)fsp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String[] params = closedCallBackEvent.getActionId().split("\\.");
        if (params[1].equals("openRosterF7CallBack")) {
            this.updateParamValue(params[0], this.getF7CallBack(params[2], closedCallBackEvent), closedCallBackEvent);
        }
    }

    public Map getF7CallBack(String index, ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCol = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == selectedCol) {
            return null;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)32);
        ListSelectedRow select = selectedCol.get(0);
        resultMap.put("idList", select.getPrimaryKeyValue().toString());
        resultMap.put("nameList", select.getName());
        resultMap.put("index", index);
        return resultMap;
    }

    private List<Map<String, String>> getComparisonOperators() {
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>();
        paramList.add(RuleOperatorEnum.IN.getOperatorMap());
        return paramList;
    }

    @KSMethod
    @SimplePropertyAttribute(name="policy")
    public String getPolicy() {
        return this.get(this.policy);
    }

    public void setPolicy(String policy) {
        this.policy = policy;
        this.set(policy);
        DynamicObject policyDy = RuleEngineHelper.queryPolicy(Long.parseLong(policy));
        if (IDStringUtils.idEmpty(this.getScene())) {
            this.setScene(policyDy.getString("scene.id"));
        }
        this.setValueAndUpdateControl(policyDy.getString("rostercondition"));
    }

    @Override
    public void setScene(String scene) {
        this.scene = scene;
        this.set(scene);
        this.updateControlData("param", this.getInputParamNoContainTarget(Long.parseLong(scene)));
    }

    public String getValue(boolean updateDisplayName) {
        String value = super.getValue();
        if (StringUtils.isEmpty((CharSequence)value) || !updateDisplayName) {
            return value;
        }
        return RuleUtil.getNewestRosterConditionValue(value);
    }
}

