/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.controls;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.controls.ConditionControl;
import kd.bos.ext.hr.ruleengine.helper.RuleEngineHelper;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.ext.hr.ruleengine.utils.TypeOperatorsUtil;
import kd.bos.form.BindingContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.ext.hr.ruleengine.controls.RuleCondition")
public class RuleCondition
extends ConditionControl {
    private static Log LOGGER = LogFactory.getLog(RuleCondition.class);
    private static final String SCENE_ID = "scene.id";
    protected Boolean showValueType = Boolean.TRUE;
    protected String policy;
    protected String rule;
    protected Map<String, String> filterMap;

    @Override
    public void bindData(BindingContext object) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("initing", "true");
        data.put("value", this.getValue(true));
        data.put("comparisonOpt", TypeOperatorsUtil.getComparisonOperatorsMap());
        data.put("conditionExpress", this.getConditionExpress());
        data.put("containTarget", this.getContainTarget());
        data.put("hideButton", this.getHideButton());
        data.put("defaultRows", this.getDefaultRows());
        data.put("showDeleteOnlyOneRow", this.getShowDeleteOnlyOneRow());
        data.put("showValueType", this.getShowValueType());
        data.put("showMoreSceneParams", this.getShowMoreSceneParams());
        data.put("filterMap", this.getFilterMap());
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String pageStatus = this.getView().getPageCache().get("pageStatus");
        if ("view".equals(pageStatus)) {
            data.put("pageState", "VIEW");
        } else {
            String pageState;
            String string = pageState = operationStatus == OperationStatus.ADDNEW ? "NEW" : operationStatus.name();
            if (this.getLock() != null && this.getLock().contains(pageState.toLowerCase())) {
                data.put("pageState", "VIEW");
            }
        }
        String sceneId = this.getScene();
        if (StringUtils.isEmpty((CharSequence)sceneId) && StringUtils.isNotEmpty((CharSequence)this.policy)) {
            DynamicObject policyDy = RuleEngineHelper.queryPolicy(Long.parseLong(this.policy));
            sceneId = policyDy.getString(SCENE_ID);
        }
        if (StringUtils.isNotEmpty((CharSequence)sceneId)) {
            data.put("param", this.getInputParam(Long.parseLong(sceneId)));
            data.put("valueParam", this.getInputValueParam(Long.parseLong(sceneId)));
        }
        data.put("ruleEngine", Boolean.TRUE.toString());
        this.updateControlDataOnInit(data);
        this.setInited(Boolean.TRUE);
    }

    public String getRule() {
        return this.get(this.rule);
    }

    public void setRule(String rule) {
        this.rule = rule;
        this.set(rule);
        if (IDStringUtils.idEmpty(this.getScene())) {
            this.setScene(RuleEngineHelper.queryRule(Long.parseLong(rule)).getString(SCENE_ID));
        }
        this.setValueAndUpdateControl(RuleEngineHelper.queryRule(Long.parseLong(rule)).getString("conditions"));
    }

    @KSMethod
    @SimplePropertyAttribute(name="policy")
    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
        this.set(policy);
        if (IDStringUtils.idEmpty(this.getScene())) {
            this.setScene(RuleEngineHelper.queryPolicy(Long.parseLong(policy)).getString(SCENE_ID));
        }
    }

    public String getValue(boolean updateDisplayName) {
        String value = super.getValue();
        if (StringUtils.isEmpty((CharSequence)value) || !updateDisplayName) {
            return value;
        }
        return RuleUtil.getNewestConditionValue(value);
    }

    @KSMethod
    @SimplePropertyAttribute(name="showValueType")
    public Boolean getShowValueType() {
        return Boolean.parseBoolean(this.get(this.showValueType.toString()));
    }

    public void setShowValueType(Boolean showValueType) {
        this.showValueType = showValueType;
        this.set(showValueType.toString());
    }

    @Override
    public Map<String, String> getFilterMap() {
        String filterMapStr = this.get("");
        if (StringUtils.isNotEmpty((CharSequence)filterMapStr)) {
            return (Map)SerializationUtils.fromJsonString((String)filterMapStr, Map.class);
        }
        return this.filterMap;
    }

    public void setFilterMap(Map<String, String> filterMap) {
        this.filterMap = filterMap;
        this.set(SerializationUtils.toJsonString(filterMap));
    }
}

