/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.controls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.hr.customcontrol.IHRCustomControl;
import kd.bos.ext.hr.ruleengine.controls.IRule;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.FormatUtil;
import kd.bos.ext.hr.ruleengine.utils.ParamsUtil;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;

public abstract class RuleControl
extends Control
implements ICloseCallBack,
IRule,
IHRCustomControl {
    String bizApp;
    String scene;
    Boolean hideButton = Boolean.FALSE;
    Integer defaultRows = 1;
    Boolean showDeleteOnlyOneRow = Boolean.FALSE;
    Boolean showMoreSceneParams = Boolean.FALSE;

    public void setSceneNoParam(String scene) {
        this.scene = scene;
    }

    public abstract RuleValidateInfo validate();

    public abstract void bindData(BindingContext var1);

    public void openParamF7(LinkedHashMap<String, Object> argsJson) {
        this.openParamF7(this, argsJson, "openConditionParamF7CallBack");
    }

    public void openTargetF7(LinkedHashMap<String, Object> argsJson) {
        IFormView formView = this.getView();
        String index = argsJson.get("index").toString();
        if (null == argsJson.get("paramType")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53c2\u6570\u3002", (String)"RuleControl_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            return;
        }
        String paramType = argsJson.get("paramType").toString();
        String targetType = argsJson.get("targetType").toString();
        Long sceneId = Long.parseLong(this.getScene());
        String bizAppId = this.getBizApp();
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"brm_target", (boolean)false, (int)0, (boolean)true);
        fsp.setCloseCallBack(new CloseCallBack(this.getClass().getName(), FormatUtil.getActionId(this.getKey(), "openConditionTargetF7CallBack", index)));
        QFilter sceneFilter = new QFilter("scene", "=", (Object)sceneId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter returnTypeFilter = new QFilter("returntype", "=", (Object)paramType);
        ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{sceneFilter, enableFilter, statusFilter, returnTypeFilter});
        if (!"all".equals(targetType)) {
            QFilter targetTypeFilter = new QFilter("targettypegroup", "=", (Object)targetType);
            qFilters.add(targetTypeFilter);
        }
        fsp.setListFilterParameter(new ListFilterParameter((List)qFilters, null));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("scene", (Object)sceneId);
        fsp.setCustomParam("bizApp", (Object)bizAppId);
        fsp.setCustomParam("targettypegroup", (Object)targetType);
        fsp.setCustomParam("returntype", (Object)paramType);
        fsp.setShowTitle(false);
        fsp.setHasRight(true);
        formView.showForm((FormShowParameter)fsp);
    }

    public Map getTargetF7CallBack(String index, ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCol = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == selectedCol) {
            return null;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)32);
        ListSelectedRow select = selectedCol.get(0);
        String targetKey = FormatUtil.getTargetMapKey(select.getPrimaryKeyValue().toString());
        resultMap.put("idList", targetKey);
        resultMap.put("nameList", select.getName());
        resultMap.put("index", index);
        return resultMap;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String[] params = closedCallBackEvent.getActionId().split("\\.");
        if (params[1].equals("openConditionParamF7CallBack")) {
            this.updateParamValue(params[0], this.getF7CallBack(params[2], closedCallBackEvent), closedCallBackEvent);
        } else if (params[1].equals("openConditionTargetF7CallBack")) {
            this.updateParamValue(params[0], this.getTargetF7CallBack(params[2], closedCallBackEvent), closedCallBackEvent);
        }
    }

    public void getMoreData(LinkedHashMap<String, String> argsJson) {
        String dyParamNumber = argsJson.get("number");
        String dyParamName = argsJson.get("name");
        String lineNum = argsJson.get("lineNum");
        HashMap rootMap = Maps.newHashMapWithExpectedSize((int)2);
        if (StringUtils.isEmpty((CharSequence)dyParamNumber)) {
            return;
        }
        String[] numberSp = dyParamNumber.split("\\.");
        if (numberSp.length == 3 || numberSp.length == 4) {
            String entityNumber = numberSp[1];
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String fieldNumber = numberSp[2];
            IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldNumber);
            String baseEntityId = null;
            if (property instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)property).getBaseEntityId();
            } else if (property instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
            }
            if (!StringUtils.isEmpty((CharSequence)baseEntityId)) {
                MainEntityType subEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                List<Map<String, String>> maps = ParamsUtil.initParamAndType(subEntityType, dyParamName, numberSp[0] + "." + numberSp[1] + "." + numberSp[2], "", dataEntityType.getProperty(fieldNumber));
                rootMap.put("text", dyParamName);
                rootMap.put("children", SerializationUtils.toJsonString(maps));
            }
        } else if (numberSp.length == 2) {
            String paramNum = numberSp[0];
            String entityNumber = numberSp[1];
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List<Map<String, String>> maps = ParamsUtil.initParamAndType(dataEntityType, dyParamName, paramNum, "", null);
            rootMap.put("text", dyParamName);
            rootMap.put("children", SerializationUtils.toJsonString(maps));
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("getMoreData", rootMap);
        data.put("lineNum", lineNum);
        this.updateControlData(data);
    }

    protected void updateControlData(Map<String, Object> data) {
        this.updateControlData(this.getKey(), data);
    }

    protected void updateControlData(String key, Object value) {
        this.updateControlData(this.getKey(), key, value);
    }

    protected void updateControlData(String controlKey, String key, Object value) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put(key, value);
        this.updateControlData(controlKey, data);
    }

    protected void updateControlData(String controlKey, Map<String, Object> data) {
        if (this.getInited().booleanValue()) {
            this.clientViewProxy.invokeControlMethod(controlKey, "updateData", new Object[]{data});
        }
    }

    public void setData(Map<String, Object> data) {
        this.updateControlData(data);
    }

    protected void updateControlDataOnInit(Map<String, Object> data) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "updateData", new Object[]{data});
    }

    @KSMethod
    @SimplePropertyAttribute(name="bizApp")
    public String getBizApp() {
        return this.get(this.bizApp);
    }

    public void setBizApp(String bizApp) {
        this.bizApp = bizApp;
        this.set(bizApp);
    }

    @KSMethod
    @SimplePropertyAttribute(name="scene")
    public String getScene() {
        return this.get(this.scene);
    }

    public void setScene(String scene) {
        this.scene = scene;
        this.set(scene);
    }

    @KSMethod
    @SimplePropertyAttribute(name="hideButton")
    public Boolean getHideButton() {
        return Boolean.parseBoolean(this.get(this.hideButton.toString()));
    }

    public void setHideButton(Boolean hideButton) {
        this.hideButton = hideButton;
        this.set(hideButton.toString());
    }

    @KSMethod
    @SimplePropertyAttribute(name="hrDefaultRows")
    public Integer getDefaultRows() {
        return Integer.parseInt(this.get(this.defaultRows.toString()));
    }

    public void setDefaultRows(Integer defaultRows) {
        this.defaultRows = defaultRows;
        this.set(defaultRows.toString());
    }

    @KSMethod
    @SimplePropertyAttribute(name="showDeleteOnlyOneRow")
    public Boolean getShowDeleteOnlyOneRow() {
        return Boolean.parseBoolean(this.get(this.showDeleteOnlyOneRow.toString()));
    }

    @KSMethod
    @SimplePropertyAttribute(name="showMoreSceneParams")
    public Boolean getShowMoreSceneParams() {
        return Boolean.parseBoolean(this.get(this.showMoreSceneParams.toString()));
    }

    public void setShowMoreSceneParams(Boolean showMoreSceneParams) {
        this.showMoreSceneParams = showMoreSceneParams;
        this.set(showMoreSceneParams.toString());
    }

    public void setShowDeleteOnlyOneRow(Boolean showDeleteOnlyOneRow) {
        this.showDeleteOnlyOneRow = showDeleteOnlyOneRow;
        this.set(showDeleteOnlyOneRow.toString());
    }

    public Boolean getContainTarget() {
        return Boolean.parseBoolean(this.get("true"));
    }

    public void setContainTarget(Boolean containTarget) {
        this.set(containTarget.toString());
    }

    public String getValue() {
        return this.get(null);
    }

    public void setValue(String value) {
        this.set(value);
    }

    public void setValueAndUpdateControl(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.clear();
        } else {
            this.setValue(value);
            this.updateControlData("value", value);
        }
    }

    public void updateParamValue(String controlKey, Object paramValue, ClosedCallBackEvent closedCallBackEvent) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("paramValue", paramValue);
        IClientViewProxy clientViewProxy = (IClientViewProxy)closedCallBackEvent.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(controlKey, "updateData", new Object[]{data});
    }

    public void setPageState(String pageState) {
        this.updateControlData("pageState", pageState);
    }

    public void setDate(String date) {
        this.updateControlData("date", date);
    }

    public Boolean getInited() {
        return Boolean.parseBoolean(this.get("false"));
    }

    public void setInited(Boolean init) {
        this.set(init.toString());
    }

    public void set(String value) {
        if (this.getView() != null) {
            this.getView().getPageCache().put(this.getKey() + "_" + Thread.currentThread().getStackTrace()[2].getMethodName().substring(3), value);
        }
    }

    public String get(String value) {
        String valueCache;
        if (this.getView() != null && StringUtils.isNotEmpty((CharSequence)(valueCache = this.getView().getPageCache().get(this.getKey() + "_" + Thread.currentThread().getStackTrace()[2].getMethodName().substring(3))))) {
            return valueCache;
        }
        return value;
    }

    @Override
    public void clear() {
        this.setValue("");
        this.updateControlData("clear", Boolean.TRUE);
    }

    @Override
    public void clearAll() {
        this.setValue("");
        this.updateControlData("clearAll", Boolean.TRUE);
    }

    public void setDateFormat(LinkedHashMap<String, Object> argsJson) {
        String dateFormat = (String)argsJson.get("dateFormat");
        if (StringUtils.isEmpty((CharSequence)dateFormat)) {
            dateFormat = "yyyy-MM-dd";
        }
        this.getView().getPageCache().put("ruleDateFormat", dateFormat);
        this.updateRuleDateFormat(dateFormat);
        this.updateControlData("showDate", Boolean.TRUE);
    }

    protected void updateRuleDateFormat(String dateFormat) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)4);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)4);
        paramMap.put("mask", dateFormat);
        itemMap.put("item", paramMap);
        this.getView().updateControlMetadata("ruledate", (Map)itemMap);
    }

    @Override
    public void setFormStatus(int status) {
        if (this.isLock(status, this.getLock())) {
            this.setPageState("VIEW");
        } else {
            this.setPageState("EDIT");
        }
    }
}

