/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.utils;

import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;

public class FormatUtil {
    private static final Pattern PAT = Pattern.compile("^([0-9_])(.*)");

    public static String getActionId(String ... keys) {
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(key).append('.');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String getSimpleKey(String bizApp, String scene) {
        return String.format("%s_%s", bizApp, scene);
    }

    public static String getTargetMapKey(String targetId) {
        return String.format("%s_%s_%s", FormatUtil.formatTenantId(RequestContext.get().getTenantId()), RequestContext.get().getAccountId(), targetId);
    }

    private static String formatTenantId(String tenantId) {
        return StringUtils.isEmpty((CharSequence)(tenantId = tenantId.replaceAll("[^A-Za-z0-9_]", ""))) || PAT.matcher(tenantId).matches() ? "t" + tenantId : tenantId;
    }
}

