/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.ext.hr.ruleengine.utils.TypeOperatorsUtil;
import kd.bos.lang.Lang;

public class HRFilterOptUtil {
    private static Map<String, Map<String, List<Map<String, String>>>> optMap = Maps.newConcurrentMap();

    public static Map<String, List<Map<String, String>>> getComparisonOperatorsMapNoCache() {
        List<Map<String, String>> objectOptList = TypeOperatorsUtil.getObjectComparisonOperators();
        HashMap comparisonOperatorsMap = Maps.newHashMapWithExpectedSize((int)16);
        comparisonOperatorsMap.put(ParamTypeEnum.BOOLEAN.getValue(), TypeOperatorsUtil.getBooleanComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.DATE.getValue(), TypeOperatorsUtil.getDateComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.STRING.getValue(), TypeOperatorsUtil.getStringComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.NUMBER.getValue(), TypeOperatorsUtil.getNumberComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.DYNAMICOBJECT.getValue(), objectOptList);
        comparisonOperatorsMap.put(ParamTypeEnum.MUL_DYNAMICOBJECT.getValue(), HRFilterOptUtil.getMulObjectComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.BASEDATA.getValue(), objectOptList);
        comparisonOperatorsMap.put(ParamTypeEnum.ADMINORG.getValue(), HRFilterOptUtil.getAdminOrgComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.MUL_ADMINORG.getValue(), HRFilterOptUtil.getMulAdminOrgComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.ENUM.getValue(), TypeOperatorsUtil.getEnumComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.MUL_ENUM.getValue(), HRFilterOptUtil.getMulEnumComparisonOperators());
        return comparisonOperatorsMap;
    }

    public static Map<String, List<Map<String, String>>> getComparisonOperatorsMap() {
        Map<String, List<Map<String, String>>> comparisonOperatorsMap = optMap.get(Lang.get().getLangTag());
        if (null != comparisonOperatorsMap) {
            return comparisonOperatorsMap;
        }
        comparisonOperatorsMap = HRFilterOptUtil.getComparisonOperatorsMapNoCache();
        optMap.put(Lang.get().getLangTag(), comparisonOperatorsMap);
        return comparisonOperatorsMap;
    }

    public static List<Map<String, String>> getMulObjectComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getMulAdminOrgComparisonOperators() {
        List<Map<String, String>> paramList = HRFilterOptUtil.getMulObjectComparisonOperators();
        return paramList;
    }

    public static List<Map<String, String>> getMulEnumComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.CONTAINS.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getAdminOrgComparisonOperators() {
        List<Map<String, String>> paramList = TypeOperatorsUtil.getObjectComparisonOperators();
        return paramList;
    }

    static {
        optMap.put(Lang.get().getLangTag(), HRFilterOptUtil.getComparisonOperatorsMapNoCache());
    }
}

