/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.JoinQueryParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;

public class FastQueryUtil {
    private static final Log LOGGER = LogFactory.getLog(FastQueryUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection queryLookUpdataSub(QueryEntityType queryEntityType, String fields, QFilter[] filters, String orderBy, int start, int limit) {
        DynamicObjectCollection queryCollection = null;
        try (DataSet ds = null;){
            ORM orm = ORM.create();
            JoinQueryParameter qp = new JoinQueryParameter(queryEntityType.getEntityName());
            List joinEntities = queryEntityType.getJoinEntitys();
            List queryRelations = queryEntityType.getJoinRelations();
            for (int i = 0; i < joinEntities.size(); ++i) {
                JoinQueryParameter.JoinQuery joinQuery = new JoinQueryParameter.JoinQuery(((JoinEntity)joinEntities.get(i)).getEntityName());
                List qSConditionRows = ((QuerySourceJoinRelation)queryRelations.get(i)).getCondition();
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < qSConditionRows.size(); ++j) {
                    QSConditionRow qSConditionRow = (QSConditionRow)qSConditionRows.get(j);
                    if (j == 0) {
                        if ("LeftJoin".equals(((QuerySourceJoinRelation)queryRelations.get(i)).getJoinType())) {
                            joinQuery.joinHint(ORMHint.JoinHint.LEFT);
                        }
                        joinQuery.property(qSConditionRow.getLeftItem().toString()).joinProperty(qSConditionRow.getRightItem().toString());
                        sb = new StringBuilder();
                        continue;
                    }
                    sb.append(qSConditionRow.getLeftItem().toString()).append(qSConditionRow.getCompareOp()).append(qSConditionRow.getRightItem().toString()).append(" and ");
                }
                if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
                    joinQuery.andExp(sb.delete(sb.length() - 5, sb.length()).toString());
                }
                qp.addJoinQuery(joinQuery);
            }
            qp.select(fields).filter(filters).orderBy(orderBy).start(start).limit(limit);
            ds = orm.queryJoinDataSet("FastQueryUtil", qp);
            queryCollection = orm.toPlainDynamicObjectCollection(ds, start - 1, limit + 1);
        }
        return queryCollection;
    }

    public static void assembleData(List<String> showFields, int start, int limit, List<Object> data, Map<String, Integer> fieldsIndexMap, DynamicObjectCollection queryCollection, int keyFieldsCount) {
        for (int i = 0; i < queryCollection.size(); ++i) {
            if (i >= limit - start + 1) continue;
            DynamicObject dynamicObject = (DynamicObject)queryCollection.get(i);
            String[] arr = new String[keyFieldsCount];
            for (int j = 0; j < keyFieldsCount; ++j) {
                arr[j] = "";
            }
            int fieldIndex = 0;
            for (String showField : showFields) {
                String value;
                String string = value = dynamicObject.get(showField) == null ? "" : String.valueOf(dynamicObject.get(showField));
                if (fieldsIndexMap.get(showField) != null) {
                    arr[fieldsIndexMap.get((Object)showField).intValue()] = value;
                } else {
                    arr[fieldIndex] = value;
                }
                ++fieldIndex;
            }
            data.add(Arrays.asList(arr));
        }
    }
}

