/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class HRBDSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey)) {
            this.checkPageSave(dataEntities);
            this.checkExcelImport(dataEntities);
        }
    }

    private void checkExcelImport(ExtendedDataEntity[] dataEntities) {
        if (dataEntities.length > 1) {
            DynamicObject obj;
            List<ExtendedDataEntity> dataEntitieArrays = this.getExistDataByField(dataEntities, "number");
            if (dataEntitieArrays.size() > 0) {
                for (ExtendedDataEntity dataEntitieArray : dataEntitieArrays) {
                    obj = dataEntitieArray.getDataEntity();
                    this.addErrorMsg(obj, dataEntitieArray, "number");
                }
            }
            if ((dataEntitieArrays = this.getExistDataByField(dataEntities, "name")).size() > 0) {
                for (ExtendedDataEntity dataEntitieArray : dataEntitieArrays) {
                    obj = dataEntitieArray.getDataEntity();
                    this.addErrorMsg(obj, dataEntitieArray, "name");
                }
            }
        }
    }

    private void checkPageSave(ExtendedDataEntity[] dataEntities) {
        if (dataEntities.length == 1) {
            DynamicObjectCollection objColl = this.getExistedObjByField(dataEntities, "number");
            if (objColl.size() > 0) {
                this.addErrorMsg((DynamicObject)objColl.get(0), dataEntities[0], "number");
            }
            if ((objColl = this.getExistedObjByField(dataEntities, "name")).size() > 0) {
                this.addErrorMsg((DynamicObject)objColl.get(0), dataEntities[0], "name");
            }
        }
    }

    public DynamicObjectCollection getExistedObjByField(ExtendedDataEntity[] dataEntities, String fieldKey) {
        DynamicObject obj = dataEntities[0].getDataEntity();
        String fieldValue = obj.getString(fieldKey);
        QFilter fieldFilter = new QFilter(fieldKey, "=", (Object)fieldValue);
        long id = obj.getLong("id");
        if (id != 0L) {
            QFilter idFilter = new QFilter("id", "!=", (Object)id);
            fieldFilter.and(idFilter);
        }
        return QueryServiceHelper.query((String)this.entityKey, (String)("id,status," + fieldKey), (QFilter[])new QFilter[]{fieldFilter});
    }

    private List<ExtendedDataEntity> getExistDataByField(ExtendedDataEntity[] dataEntities, String fieldKey) {
        ArrayList<ExtendedDataEntity> resultEntities = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        HashMap<String, List> dataMutiMap = new HashMap<String, List>(16);
        for (ExtendedDataEntity entity2 : dataEntities) {
            entity2.getBillPkId();
            DynamicObject obj = entity2.getDataEntity();
            String keyValue = obj.getString(fieldKey);
            dataMutiMap.computeIfAbsent(keyValue, key -> new ArrayList(16)).add(entity2);
        }
        for (Map.Entry entry : dataMutiMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            resultEntities.addAll((Collection)entry.getValue());
        }
        HashSet<String> fieldValueSet = new HashSet<String>(dataEntities.length);
        HashSet<Long> hashSet = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataObj : dataEntities) {
            DynamicObject obj = dataObj.getDataEntity();
            String fieldValue = obj.getString(fieldKey);
            fieldValueSet.add(fieldValue);
            long id = obj.getLong("id");
            if (id == 0L) continue;
            hashSet.add(id);
        }
        QFilter fieldFilter = new QFilter(fieldKey, "in", fieldValueSet);
        QFilter idFilter = new QFilter("id", "not in", hashSet);
        fieldFilter.and(idFilter);
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)this.entityKey, (String)("id,status," + fieldKey), (QFilter[])new QFilter[]{fieldFilter});
        for (DynamicObject obj : objColl) {
            String keyValue = obj.getString(fieldKey);
            if (this.iscontains(keyValue, fieldKey, resultEntities)) continue;
            ExtendedDataEntity dataEntity = this.getExtendedDataEntityByField(keyValue, fieldKey, dataEntities);
            Optional.ofNullable(dataEntity).ifPresent(entity -> {
                entity.getDataEntity().set("status", (Object)obj.getString("status"));
                resultEntities.add((ExtendedDataEntity)entity);
            });
        }
        return resultEntities;
    }

    private boolean iscontains(String keyValue, String fieldKey, List<ExtendedDataEntity> resultEntities) {
        long count = resultEntities.stream().map(dy -> dy.getDataEntity().getString(fieldKey)).filter(dy -> dy.equals(keyValue)).count();
        return count > 0L;
    }

    private ExtendedDataEntity getExtendedDataEntityByField(String keyValue, String fieldKey, ExtendedDataEntity[] dataEntities) {
        ExtendedDataEntity dataEntity = null;
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject obj = entity.getDataEntity();
            if (!obj.getString(fieldKey).equalsIgnoreCase(keyValue)) continue;
            dataEntity = entity;
            break;
        }
        return dataEntity;
    }

    private void addErrorMsg(DynamicObject obj, ExtendedDataEntity dataEntitieArray, String fieldName) {
        if (Objects.equals(obj.getString("status"), "LD")) {
            if ("number".equals(fieldName)) {
                this.addErrorMessage(dataEntitieArray, ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u4e8e\u903b\u8f91\u5220\u9664\u6570\u636e\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRBDSaveValidator_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            } else {
                this.addErrorMessage(dataEntitieArray, ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\u4e8e\u903b\u8f91\u5220\u9664\u6570\u636e\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRBDSaveValidator_1", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
        } else if ("number".equals(fieldName)) {
            this.addErrorMessage(dataEntitieArray, ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRBDSaveValidator_2", (String)"bos-ext-hr", (Object[])new Object[0]));
        } else {
            this.addErrorMessage(dataEntitieArray, ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRBDSaveValidator_3", (String)"bos-ext-hr", (Object[])new Object[0]));
        }
    }
}

