/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.util;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.ext.hr.web.dto.LoginOpDTO;
import kd.bos.ext.hr.web.util.HrUserCacheUtil;
import kd.bos.ext.hr.web.vo.HrUserContext;
import kd.bos.ext.hr.web.vo.HrUserVO;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class HrGuestUrlUtil {
    public static String getMobileHtmlUrl(String accountId, String loginConfigNumber, String bizUserId, String bizCustomParam) {
        String domainContextUrl = UrlService.getDomainContextUrl();
        StringBuilder sb = new StringBuilder();
        sb.append(domainContextUrl).append("/mobile.html").append("?accountId=").append(accountId).append("&loginConfigNumber=").append(loginConfigNumber).append("&bizUserId=").append(bizUserId);
        if (StringUtils.isNotEmpty((String)bizCustomParam)) {
            sb.append("&bizCustomParam=").append(bizCustomParam);
        }
        return sb.toString();
    }

    public static void hrLogout(IFormView formView) {
        HrUserVO hrUserVO = HrUserContext.get();
        String loginPageUriParam = hrUserVO.getLoginPageUriParam();
        String currClientType = hrUserVO.getCurrClientType();
        String loginType = hrUserVO.getLoginType();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        HashMap<String, String> urlMap = new HashMap<String, String>(2);
        urlMap.put("url", UrlService.getDomainContextUrl() + loginPageUriParam);
        urlMap.put("openStyle", "0");
        clientViewProxy.addAction("openUrl", urlMap);
        String hrGlobalSessionId = HrUserContext.getGlobalSessionId();
        String accountId = RequestContext.get().getAccountId();
        HrUserCacheUtil.remove(accountId, hrGlobalSessionId);
        LoginOpDTO loginOpDTO = new LoginOpDTO(HrGuestUrlUtil.transFromUserID(hrUserVO.getRealBizUserId(), loginType), "logout", "logout", currClientType);
        DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"insertLoginOpLog", (Object[])new Object[]{loginOpDTO});
    }

    public static String transFromUserID(String realBizUserId, String loginType) {
        switch (loginType) {
            case "1": {
                return "P" + realBizUserId;
            }
            case "2": {
                return "E" + realBizUserId;
            }
            case "3": {
                return "A" + realBizUserId;
            }
        }
        return realBizUserId;
    }
}

