/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.wf.listener;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.bpmn.model.CustomParam;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskInfo;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractActivityListener {
    private static final String CLOUD_ID = "hrmp";
    private static final String APP_ID = "hrcs";
    private static final String ACT_WFSERVICE_NAME = "IHRCSActivityWorkflowService";
    private static final String METHOD_NAME = "notify";
    private static final String BOS_EXT_HR = "bos-ext-hr";
    private static final String HR_SCHEME = "hr_scheme";
    private static final String SPLIT_STR = "\\$\\$";
    private static final String ACT_SERVICE_NAME = "IHRCSActivityService";
    Integer FLOW_BY_HANDLE = 1;
    Integer FLOW_BY_ACTIVATE = 2;

    protected abstract Log getLogger();

    protected void notifyActivity(AgentExecution execution) {
        this.getLogger().info("ActivityEnterNodeListener : Got callback ");
        this.getLogger().info("ActivityEnterNodeListener : Got bizBillId: [{}], bizBillNumber: [{}]", (Object)execution.getBusinessKey(), (Object)execution.getEntityNumber());
        WorkflowElement workflowElement = execution.getCurrentFlowElement();
        String nodeId = workflowElement.getId();
        String bizBillId = execution.getBusinessKey();
        String bizEntityNumber = execution.getEntityNumber();
        List customParams = (List)workflowElement.getPropertyValue("customParams");
        if (NumberUtils.isCreatable((String)bizBillId)) {
            DynamicObjectCollection entryEntity;
            List activityIds;
            Long activityId = Long.parseLong(customParams.stream().filter(CustomParam::isBuiltIn).findAny().orElseThrow(() -> new IllegalArgumentException("Can not get activity id from custom params.")).getId());
            DynamicObject instanceDyn = (DynamicObject)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)"IHRCSActivityGroupInsService", (String)"queryActivityGroupInsById", (Object[])new Object[]{Long.parseLong(bizBillId)});
            if (null != instanceDyn && !(activityIds = (entryEntity = instanceDyn.getDynamicObjectCollection("entryentity")).stream().filter(entry -> "1".equals(entry.getString("status"))).map(entry -> entry.getLong("activity.id")).collect(Collectors.toList())).contains(activityId)) {
                this.getLogger().info("Skip activity: {}.", (Object)activityId);
                return;
            }
        }
        DynamicObject bizBillInfo = BusinessDataServiceHelper.loadSingle((Object)bizBillId, (String)bizEntityNumber);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)bizEntityNumber);
        String billName = AbstractActivityListener.extractBillProperty(bizBillInfo, mainType, "name");
        String billNumber = AbstractActivityListener.extractBillProperty(bizBillInfo, mainType, "number");
        this.getLogger().info("ActivityEnterNodeListener : enter HRActivity Node ,billname: [{}],billnumber :[{}]", (Object)billName, (Object)billNumber);
        Long startUserId = execution.getStartUserId();
        String schemeVerStr = (String)execution.getVariable(HR_SCHEME);
        Long wfProDefId = execution.getProcessDefinitionId();
        Long wfCurTaskId = execution.getCurrentTaskId();
        Long wfProInsId = execution.getProcessInstanceId();
        List approverList = execution.getCurrentApprover();
        String[] info = schemeVerStr.split(SPLIT_STR);
        if (info.length != 2) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65b9\u6848\u5b57\u7b26\u4e32\u201c%s\u201d\u89e3\u6790\u9519\u8bef\u3002", (String)"ActivityEnterNodeListener_1", (String)BOS_EXT_HR, (Object[])new Object[0]), schemeVerStr));
        }
        this.getLogger().info("ActivityEnterNodeListener : enter HRActivity Node,customparamsize is " + customParams.size());
        try {
            OperationResult result = (OperationResult)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)ACT_WFSERVICE_NAME, (String)METHOD_NAME, (Object[])new Object[]{nodeId, bizBillId, bizEntityNumber, startUserId, schemeVerStr, approverList, wfProDefId, wfCurTaskId, wfProInsId, workflowElement.getPropertyValue("customParams")});
            Long actId = (Long)result.getSuccessPkIds().get(0);
            String schemeVer = info[1];
            String schemeNum = info[0];
            this.dealWithWF(actId, schemeVer, schemeNum);
            this.getLogger().info("ActivityEnterNodeListener : HRActivity Node finished successful");
        }
        catch (KDException e) {
            this.getLogger().error("ActivityEnterNodeListener : Got callback 2 error.");
            throw e;
        }
        finally {
            this.getLogger().info("ActivityEnterNodeListener : workflow Notify activity service finish.");
        }
    }

    private static String extractBillProperty(DynamicObject bizBillInfo, MainEntityType mainType, String property) {
        Map bizFieldsMap;
        String billpPoperty = "";
        if (mainType != null && (bizFieldsMap = mainType.getAllFields()).containsKey(property)) {
            billpPoperty = bizBillInfo.getString(property);
        }
        return billpPoperty;
    }

    private void dealWithWF(Long actId, String schemeVer, String schemeNum) {
        Integer flowParam = (Integer)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)ACT_SERVICE_NAME, (String)"getFlowParam", (Object[])new Object[]{actId});
        if (this.FLOW_BY_ACTIVATE.compareTo(flowParam) == 0) {
            this.consentWorkFlowTask(actId, RequestContext.get().getCurrUserId(), "");
        } else if (this.FLOW_BY_HANDLE.compareTo(flowParam) != 0) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65b9\u6848\u5b57\u7b26\u4e32\u201c%s\u201d\u89e3\u6790\u9519\u8bef\u3002", (String)"ActivityEnterNodeListener_1", (String)BOS_EXT_HR, (Object[])new Object[0]), flowParam));
        }
    }

    private void consentWorkFlowTask(Long actInsId, Long userId, String auditMessage) {
        String decOptionNumber = "consent";
        this.completeWorkFlowTask(actInsId, userId, decOptionNumber, auditMessage);
    }

    private void completeWorkFlowTask(Long actInsId, Long userId, String decOptionNumber, String auditMessage) {
        DynamicObject actInsInfo = (DynamicObject)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)ACT_SERVICE_NAME, (String)"getActivityInsById", (Object[])new Object[]{"wfcurtaskid,handlers", actInsId});
        Long taskId = actInsInfo.getLong("wfcurtaskid");
        if (userId == null || userId.compareTo(0L) == 0) {
            userId = RequestContext.get().getCurrUserId();
        }
        try {
            TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
            this.getLogger().info(MessageFormat.format("find taskInfo ? {0} ,actInsId is {1},taskId is {2}", taskInfo, actInsId, taskId));
            if (taskInfo != null) {
                HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
                variables.put("nocomment", true);
                WorkflowServiceHelper.completeTask((Long)taskId, (Long)userId, (String)decOptionNumber, (String)auditMessage, variables);
                this.getLogger().info("Complete workflow with nocomment.");
                Comment comment = WorkflowServiceHelper.createNewComment();
                comment.setTaskId(taskId);
                comment.setType("comment");
                comment.setTime(TimeServiceHelper.now());
                comment.setResultName((ILocaleString)ResManager.getLocaleString((String)"\u5904\u7406\u4e2d", (String)"AbstractActivityListener_1", (String)BOS_EXT_HR));
                comment.setActivityName(taskInfo.getName());
                WorkflowServiceHelper.addComment((Comment)comment);
                this.getLogger().info("Complete workflow with add comment.");
            }
        }
        catch (KDException ex) {
            this.getLogger().info(String.format("taskId : %d actInsId: %d", taskId, actInsId), (Object)ex);
            throw ex;
        }
    }

    private ILocaleString getAssignee(DynamicObject actInsInfo) {
        Map<Long, ILocaleString> assignerMap = actInsInfo.getDynamicObjectCollection("handlers").stream().distinct().collect(Collectors.toMap(it -> it.getLong("fbasedataid.id"), it -> it.getLocaleString("fbasedataid.name"), (oldValue, newValue) -> oldValue));
        ArrayList<Long> assignerIds = new ArrayList<Long>(assignerMap.keySet());
        List userMainOrgList = UserServiceHelper.getUserMainOrgId(assignerIds);
        Map<Long, Long> userMainOrgMap = userMainOrgList.stream().collect(Collectors.toMap(it -> (Long)new ArrayList(it.keySet()).get(0), it -> new ArrayList(it.values()).stream().findAny().orElse(0L), (oldValue, newValue) -> oldValue));
        List mainOrgIdList = userMainOrgList.stream().flatMap(it -> it.values().stream()).distinct().collect(Collectors.toList());
        DynamicObject[] mainOgrItems = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("fisadministrative", "=", (Object)"1"), new QFilter("id", "in", mainOrgIdList)});
        Map<Long, ILocaleString> mainOrgMap = Arrays.stream(mainOgrItems).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getLocaleString("name"), (oldValue, newValue) -> oldValue));
        HashMap mulLang = new HashMap();
        assignerMap.forEach((tempUserId, tempUserName) -> {
            Long tempMainOrgId = (Long)userMainOrgMap.get(tempUserId);
            ILocaleString mainOrgName = (ILocaleString)mainOrgMap.get(tempMainOrgId);
            if (null != tempMainOrgId && 0L != tempMainOrgId && null != mainOrgName) {
                mainOrgName.forEach((localeId, mainOrgNameStr) -> mulLang.compute(localeId, (key, value) -> {
                    String newValue = "";
                    if (null != value && !"".equals(value)) {
                        newValue = value + "   ;   ";
                    }
                    if (null != mainOrgNameStr && !"".equals(mainOrgNameStr.trim())) {
                        return newValue + (String)tempUserName.get(key) + "  " + mainOrgNameStr;
                    }
                    return newValue + (String)tempUserName.get(key);
                }));
            } else {
                tempUserName.forEach((localeId, tempUserNameStr) -> mulLang.compute(localeId, (key, value) -> {
                    if (null != value && !"".equals(value)) {
                        return value + "   ;   " + tempUserNameStr;
                    }
                    return tempUserNameStr;
                }));
            }
        });
        return LocaleString.fromMap(mulLang);
    }
}

