/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.wf.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class RuleEngineWFExtendPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        if (!StringUtils.isEmpty((String)value)) {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Long sceneId = (Long)((Map)valueMap.get("scene")).get("id");
            Long strategyId = (Long)((Map)valueMap.get("strategy")).get("id");
            this.getModel().setValue("scene", (Object)sceneId);
            this.getModel().setValue("strategy", (Object)strategyId);
            ComboEdit comboEdit = (ComboEdit)this.getControl("outparam");
            ComboProp comboProp = (ComboProp)comboEdit.getProperty();
            comboProp.setDefaultValue(valueMap.get("outparam"));
            this.fillOutParam(sceneId, strategyId);
            ComboEdit inputComboEdit = (ComboEdit)this.getControl("inputparam");
            ComboProp inputComboProp = (ComboProp)inputComboEdit.getProperty();
            inputComboProp.setDefaultValue(valueMap.get("inputparam"));
            DynamicObject scene = (DynamicObject)this.getModel().getValue("scene");
            this.fillInputParam(inputComboEdit, scene.getDynamicObjectCollection("sceneinputparams"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("strategy");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("scene".equals(name)) {
            this.getModel().setValue("strategy", null);
            this.clearParam("inputparam");
            this.clearParam("outparam");
            DynamicObject scene = (DynamicObject)this.getModel().getValue("scene");
            if (scene != null) {
                this.fillInputParam((ComboEdit)this.getControl("inputparam"), scene.getDynamicObjectCollection("sceneinputparams"));
                this.getView().updateView("inputparam");
            }
        } else if ("strategy".equals(name)) {
            this.clearParam("outparam");
            DynamicObject scene = (DynamicObject)this.getModel().getValue("scene");
            DynamicObject strategy = (DynamicObject)this.getModel().getValue("strategy");
            if (scene != null && strategy != null) {
                this.fillOutParam(scene.getLong("id"), strategy.getLong("id"));
                this.getView().updateView("outparam");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Control control = (Control)beforeF7SelectEvent.getSource();
        if ("strategy".equals(control.getKey())) {
            DynamicObject scene = (DynamicObject)this.getView().getModel().getValue("scene");
            if (scene == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u573a\u666f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleEngineWFExtendPlugin_0", (String)"bos-ext-hr", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)2);
            qFilterList.add(new QFilter("scene", "=", scene.get("id")));
            qFilterList.add(new QFilter("entrybulist", "is not null", null));
            showParameter.getListFilterParameter().setQFilters((List)qFilterList);
        }
    }

    public void customEvent(CustomEventArgs e) {
        if ("validate".equalsIgnoreCase(e.getKey())) {
            StringBuilder stringBuilder = new StringBuilder();
            Object scene = this.getModel().getValue("scene");
            String inputParam = (String)this.getModel().getValue("inputparam");
            Object strategy = this.getModel().getValue("strategy");
            String outParam = (String)this.getModel().getValue("outparam");
            if (scene == null) {
                stringBuilder.append(ResManager.loadKDString((String)"\u573a\u666f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleEngineWFExtendPlugin_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)inputParam)) {
                stringBuilder.append(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleEngineWFExtendPlugin_1", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
            if (strategy == null) {
                stringBuilder.append(ResManager.loadKDString((String)"\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleEngineWFExtendPlugin_2", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)outParam)) {
                stringBuilder.append(ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleEngineWFExtendPlugin_3", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
            if (stringBuilder.length() > 0) {
                this.getPageCache().put("validateResult", stringBuilder.toString());
            }
        }
    }

    private void fillInputParam(ComboEdit comboEdit, DynamicObjectCollection params) {
        ArrayList data = Lists.newArrayListWithExpectedSize((int)params.size());
        params.stream().filter(param -> Objects.equals("dynamicObject", param.getString("inputparamstype"))).forEach(param -> data.add(new ComboItem(new LocaleString(param.getString("inputname")), param.getString("inputnumber"))));
        comboEdit.setComboItems((List)data);
    }

    private void fillOutParam(Long sceneId, Long strategyId) {
        List resultList = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"brm", (String)"IBRMSceneParamService", (String)"getPolicyResultParams", (Object[])new Object[]{sceneId, strategyId});
        ComboEdit comboEdit = (ComboEdit)this.getControl("outparam");
        ArrayList data = Lists.newArrayListWithExpectedSize((int)resultList.size());
        resultList.forEach(resultMap -> data.add(new ComboItem(new LocaleString((String)resultMap.get("name")), SerializationUtils.toJsonString((Object)resultMap))));
        comboEdit.setComboItems((List)data);
    }

    private void clearParam(String param) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(param);
        ComboProp comboProp = (ComboProp)comboEdit.getProperty();
        comboProp.setDefaultValue(null);
        comboEdit.setComboItems(null);
        this.getView().updateView(param);
    }
}

