/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.wf.plugin.activity;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.extitf.ITaskPlugin;
import kd.bos.workflow.engine.task.TaskInfo;

public class ActivityCompleteHandlePlugin
implements ITaskPlugin {
    private static final Log LOGGER = LogFactory.getLog(ActivityCompleteHandlePlugin.class);
    private static final String ENTITY_NAME = "hrcs_activityins";
    private static final String EVENT_NAME_COMPLETE = "complete";
    private static final String WF_TASK_ID = "wfcurtaskid";
    private static final String GLOBAL_TASK_ID = "globaltaskid";
    private static final String COMMA = ",";
    private static final String HANDLERS = "handlers";
    private static final String DEC_OPTION_NUMBER_KEY = "auditNumber";
    private static final String AUDIT_MESSAGE_KEY = "auditMessage";

    public void handleTask(AgentTask agentTask, String eventName, Map<String, Object> params) {
        try {
            LOGGER.info("Got event name:{} and params:{}.", (Object)eventName, params);
            if (EVENT_NAME_COMPLETE.equalsIgnoreCase(eventName)) {
                Long globalTaskId = agentTask.getId();
                DynamicObject activityIns = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"wfcurtaskid,handlers", (QFilter[])new QFilter[]{new QFilter(GLOBAL_TASK_ID, "=", (Object)globalTaskId)});
                LOGGER.info("Got activity instance:{} with global task id:{}.", (Object)activityIns, (Object)globalTaskId);
                if (null != activityIns) {
                    DynamicObjectCollection handlers = activityIns.getDynamicObjectCollection(HANDLERS);
                    Long wfTaskId = activityIns.getLong(WF_TASK_ID);
                    Long handlerId = handlers.isEmpty() ? 0L : ((DynamicObject)handlers.get(0)).getLong("fbasedataid_id");
                    String decOptionNumber = (String)params.get(DEC_OPTION_NUMBER_KEY);
                    String auditMessage = (String)params.get(AUDIT_MESSAGE_KEY);
                    LOGGER.info("Complete workflow task:{}, handler:{}, decOptionNumber:{}, auditMessage:{}, params:{}.", new Object[]{wfTaskId, handlerId, decOptionNumber, auditMessage, params});
                    TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
                    LOGGER.info("Got taskInfo: {} with wfTaskId:{}.", (Object)taskInfo, (Object)wfTaskId);
                    if (null != taskInfo) {
                        WorkflowServiceHelper.completeTask((Long)wfTaskId, (Long)handlerId, (String)decOptionNumber, (String)auditMessage, (Map)Maps.newHashMap());
                    }
                    LOGGER.info("Complete workflow task success.");
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Got handle task exception.", (Throwable)exception);
            throw exception;
        }
    }
}

