/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.wf.plugin.activity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.wf.plugin.activity.BillContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFCustomParam;

public class ActivityWFErrorSuspendPlugin
implements IEventServicePlugin {
    private static final Log LOGGER = LogFactory.getLog(ActivityWFErrorSuspendPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        LOGGER.info("Got params: {}", (Object)evt.getSource());
        try {
            List list = SerializationUtils.fromJsonStringToList((String)evt.getSource(), Map.class);
            Map map = (Map)list.get(0);
            String currentNodeId = (String)map.get("currentNodeId");
            Long processInstanceId = (Long)map.get("processInstanceId");
            Long processDefId = (Long)map.get("processdefinitionId");
            String entityNumber = (String)map.get("enNumber");
            if (BillContainer.BILLS.contains(entityNumber)) {
                List elements = WorkflowServiceHelper.getProcElementsByProcDefId((Long)processDefId);
                elements.stream().filter(it -> "HRActivity".equalsIgnoreCase(it.getType()) && currentNodeId.equalsIgnoreCase(it.getId())).findAny().map(item -> (WFAuditTask)item).ifPresent(item -> {
                    Map variables = WorkflowServiceHelper.getVariablesByProcInstId((Long)processInstanceId, (String[])new String[]{"hr_scheme"});
                    Long activityId = Long.parseLong(((WFCustomParam)item.getCustomParams().get(0)).getId());
                    String activityScheme = (String)variables.get("hr_scheme");
                    List approverList = Optional.ofNullable(item.getParticipant().getParticipant()).map(participants -> participants.stream().filter(participant -> "person".equals(participant.getType())).flatMap(participant -> Arrays.stream(participant.getValue().split(","))).map(Long::parseLong).collect(Collectors.toList())).orElseGet(() -> Collections.emptyList());
                    String billId = (String)map.get("businKey");
                    String billNo = (String)map.get("billNo");
                    String exceptionMessage = (String)map.get("exceptionMessage");
                    Long creatorId = QueryServiceHelper.query((String)"QueryServiceHelper.wf_operationlog", (String)"wf_operationlog", (String)"ownerid", (QFilter[])new QFilter[]{new QFilter("activityid", "=", (Object)currentNodeId), new QFilter("procinstid", "=", (Object)processInstanceId), new QFilter("procdefid", "=", (Object)processDefId)}, (String)"step desc", (int)1).stream().findAny().map(it -> it.getLong("ownerid")).orElse(0L);
                    LOGGER.info("WFErrorSuspend. ProcessDefId: {}, processInsId: {}, currentNodeId: {}, creatorId: {}, entityNumber: {}, billId: {}, billNo: {}, activityScheme: {}, activityId: {}, exceptionMessage: {}", new Object[]{processDefId, processInstanceId, currentNodeId, creatorId, entityNumber, billId, billNo, activityScheme, activityId, exceptionMessage});
                    DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSActivityWorkflowService", (String)"notifyForErrorSuspend", (Object[])new Object[]{processDefId, processInstanceId, currentNodeId, creatorId, entityNumber, billId, billNo, activityScheme, activityId, approverList, exceptionMessage});
                });
            } else {
                LOGGER.info("Can not match bill[{}], BILLS is {}.", (Object)entityNumber, BillContainer.BILLS);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Got exception.", (Throwable)exception);
        }
        return null;
    }
}

