/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.wf.plugin.activity;

import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.wf.plugin.activity.BillContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ActivityWFNodeLeavePlugin
implements IEventServicePlugin {
    private static final Log LOGGER = LogFactory.getLog(ActivityWFNodeLeavePlugin.class);
    private static final String META_NUMBER_WF_HI_COMMENT = "wf_hicomment";
    private static final String VALUE_DECISION_TYPE_TERMINATE = "terminate";
    private static final String FIELD_DECISION_TYPE = "decisiontype";
    private static final String FIELD_PROCESS_INSTANCE_ID = "processinstanceid";
    private static final String FIELD_ACTIVITY_ID = "activityid";
    private static final String FIELD_ENTITY_NUMBER = "entitynumber";
    private static final String FIELD_USER_ID = "userid";
    private static final String PARAM_CURRENT_NODE_ID = "currentNodeId";
    private static final String PARAM_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String PARAM_EN_NUMBER = "enNumber";
    private static final String PARAM_BUSINESS_KEY = "businKey";

    public Object handleEvent(KDBizEvent evt) {
        DynamicObject insDecisionType;
        LOGGER.info("Got params: {}", (Object)evt.getSource());
        List list = SerializationUtils.fromJsonStringToList((String)evt.getSource(), Map.class);
        Map params = (Map)list.get(0);
        String currentNodeId = (String)params.get(PARAM_CURRENT_NODE_ID);
        Long processInstanceId = (Long)params.get(PARAM_PROCESS_INSTANCE_ID);
        String entityNumber = (String)params.get(PARAM_EN_NUMBER);
        String billId = (String)params.get(PARAM_BUSINESS_KEY);
        if (BillContainer.BILLS.contains(entityNumber) && this.checkIfIsActivityBill(entityNumber).booleanValue() && (insDecisionType = this.getProcessInsDecisionType(currentNodeId, processInstanceId, entityNumber)) != null && VALUE_DECISION_TYPE_TERMINATE.equals(insDecisionType.getString(FIELD_DECISION_TYPE))) {
            DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSActivityWorkflowService", (String)"notifyForDisagreeAndTerminate", (Object[])new Object[]{processInstanceId, billId, entityNumber, insDecisionType.getLong(FIELD_USER_ID)});
        }
        return super.handleEvent(evt);
    }

    private Boolean checkIfIsActivityBill(String entityNumber) {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSActivityWorkflowService", (String)"isActivityBillEntityNumber", (Object[])new Object[]{entityNumber});
    }

    private DynamicObject getProcessInsDecisionType(String currentNodeId, Long processInsId, String entityNumber) {
        if (StringUtils.isEmpty((CharSequence)currentNodeId) || processInsId == null || StringUtils.isEmpty((CharSequence)entityNumber)) {
            return null;
        }
        QFilter activityFilter = new QFilter(FIELD_ACTIVITY_ID, "=", (Object)currentNodeId);
        QFilter entityNumberFilter = new QFilter(FIELD_ENTITY_NUMBER, "=", (Object)entityNumber);
        QFilter processInsFilter = new QFilter(FIELD_PROCESS_INSTANCE_ID, "=", (Object)processInsId);
        return QueryServiceHelper.queryOne((String)META_NUMBER_WF_HI_COMMENT, (String)"decisiontype,userid", (QFilter[])new QFilter[]{entityNumberFilter, processInsFilter, activityFilter});
    }
}

