/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.bizuniquecode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.ext.bd.bizuniquecode.BizUniqueCodeMappingHelper;
import kd.bos.ext.bd.bizuniquecode.BizUniqueCodeStorageHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BizUniqueCodeHelper {
    private static final Log LOG = LogFactory.getLog(BizUniqueCodeHelper.class);
    private static final Map<String, Boolean> initTableMap = new ConcurrentHashMap<String, Boolean>(4);
    private static final String TABLE_NAME = "T_GBS_BIZUNIQUECODE";
    private static final String CREATE_TABLE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_GBS_BIZUNIQUECODE')CREATE TABLE T_GBS_BIZUNIQUECODE (FUNIQUECODEVALUE VARCHAR(128) DEFAULT ' ' NOT NULL,FCREATEDTIME DATETIME,FMAPPINGID INT DEFAULT 0 NOT NULL);";
    private static final String CREATE_MAPPING_TABLE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_GBS_BIZUNIQUECODEMAPPING')CREATE TABLE T_GBS_BIZUNIQUECODEMAPPING (FID INT DEFAULT 0 NOT NULL,FBILLTYPE VARCHAR(64) DEFAULT ' ' NOT NULL);";
    private static final String CREATE_PK_ID = "EXEC P_ALTERPK 'PK_T_GBS_BIZUNIQUECODE', 'T_GBS_BIZUNIQUECODE', 'FMAPPINGID,FUNIQUECODEVALUE', '1'";
    private static final String CREATE_MAPPING_PK_ID = "EXEC P_ALTERPK 'PK_T_GBS_BIZUNIQUECODEMAPPING', 'T_GBS_BIZUNIQUECODEMAPPING', 'FID', '1'";
    private static final String CREATE_INDEX_TIME = " IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_GBS_BIZUNIQUECODEFCREATEDTIME') CREATE INDEX IDX_GBS_BIZUNIQUECODEFCREATEDTIME ON T_GBS_BIZUNIQUECODE (FCREATEDTIME );";
    private static final String CREATE_MAPPING_INDEX = " IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_GBS_BIZUNIQUECODEMAPPING') CREATE UNIQUE INDEX IDX_GBS_BIZUNIQUECODEMAPPING ON T_GBS_BIZUNIQUECODEMAPPING ( FBILLTYPE );";

    public static void saveUniqueCode(DynamicObject[] dyns, String billType, String dbRouteKey, String propertyName) {
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        BizUniqueCodeHelper.initTable(dbRoute);
        int billTypeHash = BizUniqueCodeMappingHelper.getInstance().getMappingTable(dbRoute, billType);
        List<DynamicObject> fromDatabaseDyns = Arrays.stream(dyns).filter(dyn -> dyn.getDataEntityState().getFromDatabase()).collect(Collectors.toList());
        List bizUniqueCodeDyns = Arrays.stream(dyns).filter(dyn -> StringUtils.isNotEmpty((CharSequence)dyn.getString(propertyName))).collect(Collectors.toList());
        List<String> uniqueCodeValues = bizUniqueCodeDyns.stream().map(dyn -> dyn.getString(propertyName)).collect(Collectors.toList());
        Date date = new Date();
        ArrayList records = Lists.newArrayListWithCapacity((int)uniqueCodeValues.size());
        for (String uniqueCodeValue : uniqueCodeValues) {
            records.add(new Object[]{uniqueCodeValue, billTypeHash, date});
        }
        try {
            if (!fromDatabaseDyns.isEmpty()) {
                BizUniqueCodeHelper.deleteUniqueCode(fromDatabaseDyns.toArray(new DynamicObject[0]), billType, dbRouteKey, propertyName, billTypeHash);
            }
            if (!records.isEmpty()) {
                BizUniqueCodeStorageHelper.batchSave(dbRoute, records);
            }
        }
        catch (Exception e) {
            LOG.warn("\u4fdd\u5b58\u9632\u91cd\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            TXHandle h = TX.notSupported();
            Throwable throwable = null;
            try {
                try {
                    List<String> byUniqueCodeValuesAndBillTypeHash = BizUniqueCodeStorageHelper.getByUniqueCodeValuesAndBillTypeHash(dbRoute, uniqueCodeValues, billTypeHash);
                    String message = !byUniqueCodeValuesAndBillTypeHash.isEmpty() ? String.format(ResManager.loadKDString((String)"\u5355\u636e\u7684\u4e1a\u52a1\u552f\u4e00\u7801\u503c\u5df2\u5b58\u5728: %s", (String)"BizUniqueCodeHelper_0", (String)"bos-ext-bd", (Object[])new Object[0]), String.join((CharSequence)",", byUniqueCodeValuesAndBillTypeHash)) : String.format(ResManager.loadKDString((String)"\u5355\u636e\u7684\u4e1a\u52a1\u552f\u4e00\u7801\u503c\u5df2\u5b58\u5728: unknown", (String)"BizUniqueCodeHelper_1", (String)"bos-ext-bd", (Object[])new Object[0]), String.join((CharSequence)",", byUniqueCodeValuesAndBillTypeHash));
                    throw new KDException(message);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        h.close();
                    }
                }
                throw throwable3;
            }
        }
    }

    public static void deleteUniqueCode(DynamicObject[] dyns, String billType, String dbRouteKey, String propertyName, int billTypeHash) {
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        List ids = Arrays.stream(dyns).map(dyn -> dyn.get("id")).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)billType, (String)propertyName, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        List<String> uniqueCodeValues = dynamicObjects.stream().map(dyn -> dyn.getString(0)).collect(Collectors.toList());
        BizUniqueCodeStorageHelper.delete(dbRoute, uniqueCodeValues, billTypeHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTable(DBRoute dbRoute) {
        try (TXHandle tx = TX.notSupported();){
            if (dbRoute == null) {
                return;
            }
            String tableExitsKey = BizUniqueCodeHelper.getKey(dbRoute);
            if (!initTableMap.getOrDefault(tableExitsKey, false).booleanValue() && !DB.exitsTable((DBRoute)dbRoute, (String)TABLE_NAME)) {
                DLock lock = DLock.create((String)tableExitsKey, (String)"tableExitsKey");
                lock.lock();
                try {
                    DB.execute((DBRoute)dbRoute, (String)CREATE_TABLE_SQL);
                    DB.execute((DBRoute)dbRoute, (String)CREATE_PK_ID);
                    DB.execute((DBRoute)dbRoute, (String)CREATE_INDEX_TIME);
                    DB.execute((DBRoute)dbRoute, (String)CREATE_MAPPING_TABLE_SQL);
                    DB.execute((DBRoute)dbRoute, (String)CREATE_MAPPING_PK_ID);
                    DB.execute((DBRoute)dbRoute, (String)CREATE_MAPPING_INDEX);
                }
                finally {
                    lock.unlock();
                }
            }
            initTableMap.put(tableExitsKey, true);
        }
    }

    private static String getKey(DBRoute routeKey) {
        StringBuilder sb = new StringBuilder(RequestContext.get().getTenantId());
        sb.append("_");
        sb.append(RequestContext.get().getAccountId());
        sb.append("_");
        sb.append(routeKey.getRouteKey());
        return sb.toString();
    }
}

