/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.bizuniquecode;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.ext.bd.bizuniquecode.BizUniqueCodeStorageHelper;

public class BizUniqueCodeMappingHelper {
    private static final Map<String, Integer> mappingTableMap = new ConcurrentHashMap<String, Integer>(16);
    private static final BizUniqueCodeMappingHelper INSTANCE = new BizUniqueCodeMappingHelper();

    private BizUniqueCodeMappingHelper() {
    }

    public static BizUniqueCodeMappingHelper getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMappingTable(DBRoute dbRoute, String billType) {
        String key = BizUniqueCodeMappingHelper.getKey(billType);
        Integer hash = mappingTableMap.get(key);
        if (hash != null) {
            return hash;
        }
        DLock lock = DLock.create((String)key, (String)"billTypeKey");
        lock.lock();
        try {
            hash = mappingTableMap.get(key);
            if (hash != null) {
                int n = hash;
                return n;
            }
            Integer fid = BizUniqueCodeStorageHelper.loadMappingId(dbRoute, billType);
            if (fid == null) {
                fid = BizUniqueCodeStorageHelper.saveMappingTable(dbRoute, billType);
            }
            mappingTableMap.put(key, fid);
            int n = fid;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private static String getKey(String billType) {
        StringBuilder sb = new StringBuilder(RequestContext.get().getTenantId());
        sb.append("_");
        sb.append(RequestContext.get().getAccountId());
        sb.append("_");
        sb.append(billType);
        return sb.toString();
    }
}

