/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class RequireTypeHelper {
    private static final String ALGO_KEY = RequireTypeHelper.class.getName();
    public static final String DIM_MATERIAL_KEY = "materialKey";
    public static final String DIM_ORG_KEY = "orgKey";
    public static final String DIM_MATERIAL_INV_KEY = "materialInvKey";
    public static final String DIM_REQUIRE_TYPE_KEY = "requireTypeKey";
    public static final String GZ004 = "GZ004";
    public static final String GZ005 = "GZ005";
    public static final String GZ007 = "GZ007";
    public static final String GZ009 = "GZ009";

    public static Map<Long, Set<Long>> queryRequireTypeRange(Set<Long> manuStrGroupIdSet) {
        HashMap<Long, Set<Long>> requireTypeRangeMap = new HashMap<Long, Set<Long>>(manuStrGroupIdSet.size());
        Map<Long, Set<Long>> manuStrategyMap = RequireTypeHelper.queryManuStrategyMap(manuStrGroupIdSet);
        HashSet<Long> allManuStrategyIdSet = new HashSet<Long>(manuStrGroupIdSet.size());
        for (Set<Long> manuStrategyIdSet : manuStrategyMap.values()) {
            allManuStrategyIdSet.addAll(manuStrategyIdSet);
        }
        if (allManuStrategyIdSet.isEmpty()) {
            return requireTypeRangeMap;
        }
        Map<Long, Long> requireTypeMap = RequireTypeHelper.queryRequireTypeMap(allManuStrategyIdSet);
        HashSet<Long> allRequireTypeIdSet = new HashSet<Long>(requireTypeMap.size());
        allRequireTypeIdSet.addAll(requireTypeMap.values());
        if (allRequireTypeIdSet.isEmpty()) {
            return requireTypeRangeMap;
        }
        Set<Long> enableRequireTypeIdSet = RequireTypeHelper.queryEnableRequireTypeIdSet(allRequireTypeIdSet);
        if (enableRequireTypeIdSet.isEmpty()) {
            return requireTypeRangeMap;
        }
        for (Long manuStrGroupId : manuStrGroupIdSet) {
            Set<Long> manuStrategyIdSet = manuStrategyMap.get(manuStrGroupId);
            if (manuStrategyIdSet == null || manuStrategyIdSet.isEmpty()) continue;
            for (Long manuStrategyId : manuStrategyIdSet) {
                Long requireTypeId = requireTypeMap.get(manuStrategyId);
                if (!enableRequireTypeIdSet.contains(requireTypeId)) continue;
                Set requireTypeIdSet = requireTypeRangeMap.computeIfAbsent(manuStrGroupId, v -> new HashSet(16));
                requireTypeIdSet.add(requireTypeId);
            }
        }
        return requireTypeRangeMap;
    }

    private static Set<Long> queryEnableRequireTypeIdSet(Set<Long> requireTypeIdSet) {
        HashSet<Long> enableRequireTypeIdSet = new HashSet<Long>(requireTypeIdSet.size());
        QFilter[] requireTypeFilters = new QFilter[]{new QFilter("id", "in", requireTypeIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DataSet requireTypeDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_requiretype", (String)"id", (QFilter[])requireTypeFilters, null);
        for (Row row : requireTypeDataSet) {
            Long requireTypeId = row.getLong("id");
            enableRequireTypeIdSet.add(requireTypeId);
        }
        return enableRequireTypeIdSet;
    }

    private static Map<Long, Long> queryRequireTypeMap(Set<Long> manuStrategyIdSet) {
        HashMap<Long, Long> requireTypeMap = new HashMap<Long, Long>(manuStrategyIdSet.size());
        QFilter[] manuStrategyFilters = new QFilter[]{new QFilter("id", "in", manuStrategyIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DataSet manuStrategyDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_manustrategy", (String)"id, requiretype", (QFilter[])manuStrategyFilters, null);
        for (Row row : manuStrategyDataSet) {
            Long manuStrategyId = row.getLong("id");
            manuStrategyId = manuStrategyId == null ? Long.valueOf(0L) : manuStrategyId;
            Long requireTypeId = row.getLong("requiretype");
            requireTypeId = requireTypeId == null ? Long.valueOf(0L) : requireTypeId;
            requireTypeMap.put(manuStrategyId, requireTypeId);
        }
        return requireTypeMap;
    }

    private static Map<Long, Set<Long>> queryManuStrategyMap(Set<Long> manuStrGroupIdSet) {
        HashMap<Long, Set<Long>> manuStrategyMap = new HashMap<Long, Set<Long>>(manuStrGroupIdSet.size());
        QFilter[] manuStrGroupFilters = new QFilter[]{new QFilter("id", "in", manuStrGroupIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DataSet manuStrGroupDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_manustrategygroup", (String)"id, entryentity.manustrategy", (QFilter[])manuStrGroupFilters, null);
        for (Row row : manuStrGroupDataSet) {
            Long manuStrGroupId = row.getLong("id");
            manuStrGroupId = manuStrGroupId == null ? Long.valueOf(0L) : manuStrGroupId;
            Long manuStrategyId = row.getLong("entryentity.manustrategy");
            manuStrategyId = manuStrategyId == null ? Long.valueOf(0L) : manuStrategyId;
            Set idSet = manuStrategyMap.computeIfAbsent(manuStrGroupId, v -> new HashSet(16));
            idSet.add(manuStrategyId);
        }
        return manuStrategyMap;
    }

    public static Map<Long, Long> queryManuStrGroup(Set<Long> materialInvSet) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", materialInvSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        String selectFields = "id, manustrategygroup";
        DataSet materialInvDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_materialinventoryinfo", (String)selectFields, (QFilter[])filters, null);
        HashMap<Long, Long> manuStrGroupMap = new HashMap<Long, Long>(16);
        for (Row row : materialInvDataSet) {
            Long materialInvId = row.getLong("id");
            materialInvId = materialInvId == null ? Long.valueOf(0L) : materialInvId;
            Long manuStrGroupId = row.getLong("manustrategygroup");
            manuStrGroupId = manuStrGroupId == null ? Long.valueOf(0L) : manuStrGroupId;
            manuStrGroupMap.put(materialInvId, manuStrGroupId);
        }
        return manuStrGroupMap;
    }

    public static Map<String, Long> queryManuStrGroup(Long orgId, Set<Long> materialIdSet) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        QFilter[] filters = new QFilter[]{baseDataFilter, new QFilter("masterid", "in", materialIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        String selectFields = "id, createorg, masterid, manustrategygroup";
        DataSet materialInvDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_materialinventoryinfo", (String)selectFields, (QFilter[])filters, null);
        HashMap<String, Long> manuStrGroupMap = new HashMap<String, Long>(16);
        for (Row row : materialInvDataSet) {
            Long createOrgId = row.getLong("createorg");
            createOrgId = createOrgId == null ? Long.valueOf(0L) : createOrgId;
            Long materialId = row.getLong("masterid");
            materialId = materialId == null ? Long.valueOf(0L) : materialId;
            Long manuStrGroupId = row.getLong("manustrategygroup");
            manuStrGroupId = manuStrGroupId == null ? Long.valueOf(0L) : manuStrGroupId;
            String keyStr = RequireTypeHelper.buildMapKey(orgId, materialId);
            if (!orgId.equals(createOrgId) && manuStrGroupMap.containsKey(keyStr)) continue;
            manuStrGroupMap.put(keyStr, manuStrGroupId);
        }
        return manuStrGroupMap;
    }

    public static String buildMapKey(long orgId, long materialId) {
        return String.format("%1$s_%2$s", orgId, materialId);
    }

    public static Map<String, String> parsingManuStrategyDimKey(String entityName, DynamicObject manuStrConfig, String requireTypeKey) {
        List<Map<String, String>> dimKeyList = RequireTypeHelper.parsingManuStrategyDimKey(entityName, manuStrConfig);
        for (Map<String, String> dimMap : dimKeyList) {
            String[] splitKeyArr;
            String fieldKey = dimMap.getOrDefault(DIM_REQUIRE_TYPE_KEY, "");
            for (String splitKey : splitKeyArr = fieldKey.split("\\.")) {
                if (!splitKey.equals(requireTypeKey)) continue;
                return dimMap;
            }
        }
        HashMap<String, String> dimMap = new HashMap<String, String>(8);
        return dimMap;
    }

    private static List<Map<String, String>> parsingManuStrategyDimKey(String entityName, DynamicObject manuStrConfig) {
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(10);
        ArrayList<String> billTypes = new ArrayList<String>(3);
        billTypes.add(entityName);
        if (manuStrConfig == null) {
            String billTypeId = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Form);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)billTypeId, (String)"bos_formmeta", (String)"parentid");
            if (dynamicObject == null) {
                return dimList;
            }
            String parentBillTypeId = dynamicObject.getString("parentid_id");
            String parentBillType = MetadataDao.getNumberById((String)parentBillTypeId);
            if (StringUtils.isBlank((CharSequence)parentBillType)) {
                return dimList;
            }
            String selectFields = "id, entryentity.billentity, subentryentity.dimension, subentryentity.field";
            QFilter[] filters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1"), new QFilter("entryentity.billentity", "=", (Object)parentBillType)};
            manuStrConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_manustrconfig", (String)selectFields, (QFilter[])filters);
            if (manuStrConfig == null) {
                return dimList;
            }
            billTypes.add(parentBillType);
        }
        DynamicObjectCollection entryEntity = manuStrConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entryEntity) {
            String billEntityName;
            DynamicObject billEntity = entryRow.getDynamicObject("billentity");
            if (billEntity == null || !billTypes.contains(billEntityName = billEntity.getPkValue().toString())) continue;
            DynamicObjectCollection subEntryEntity = entryRow.getDynamicObjectCollection("subentryentity");
            boolean isMatchDim = false;
            for (DynamicObject subEntryRow : subEntryEntity) {
                String dimNumber;
                DynamicObject dimension = subEntryRow.getDynamicObject("dimension");
                if (dimension == null || !GZ009.equals(dimNumber = dimension.getString("number"))) continue;
                isMatchDim = true;
                break;
            }
            if (!isMatchDim) continue;
            String materialKey = "";
            String orgKey = "";
            String materialInvKey = "";
            String requireTypeKey = "";
            for (DynamicObject subEntryRow : subEntryEntity) {
                DynamicObject dimension = subEntryRow.getDynamicObject("dimension");
                if (dimension == null) continue;
                String dimNumber = dimension.getString("number");
                if (GZ007.equals(dimNumber)) {
                    materialInvKey = subEntryRow.getString("field");
                    continue;
                }
                if (GZ005.equals(dimNumber)) {
                    materialKey = subEntryRow.getString("field");
                    continue;
                }
                if (GZ004.equals(dimNumber)) {
                    orgKey = subEntryRow.getString("field");
                    continue;
                }
                if (!GZ009.equals(dimNumber)) continue;
                requireTypeKey = subEntryRow.getString("field");
            }
            HashMap<String, String> dimMap = new HashMap<String, String>(8);
            dimMap.put(DIM_MATERIAL_INV_KEY, materialInvKey);
            dimMap.put(DIM_MATERIAL_KEY, materialKey);
            dimMap.put(DIM_ORG_KEY, orgKey);
            dimMap.put(DIM_REQUIRE_TYPE_KEY, requireTypeKey);
            dimList.add(dimMap);
        }
        return dimList;
    }

    public static DynamicObject getManuStrConfigFromCache(String entityName) {
        QFilter[] filters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1"), new QFilter("entryentity.billentity", "=", (Object)entityName)};
        String selectFields = "id, entryentity.billentity, subentryentity.dimension, subentryentity.field";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_manustrconfig", (String)selectFields, (QFilter[])filters);
    }
}

