/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.bd.thread.ExtRejectedException;
import kd.bos.ext.bd.thread.ExtRejectedPolicy;
import kd.bos.ext.bd.thread.ExtThreadExecutorService;
import kd.bos.ext.bd.thread.ExtThreadService;
import kd.bos.ext.bd.thread.IExtUnifiedTaskType;
import kd.bos.unifiedthreadpool.exception.RejectedExecutionException;

public class ExtDefaultExecutor
implements ExtThreadExecutorService {
    static final ExtDefaultExecutor INSTANCE = new ExtDefaultExecutor();

    @Override
    public void execute(Runnable runnable, IExtUnifiedTaskType taskType, RequestContext requestContext, OperationContext operationContext, ExtRejectedPolicy policy) {
        try {
            ExtThreadService.get(taskType).execute(runnable, taskType.getName(), requestContext, operationContext == null ? null : operationContext.copy());
        }
        catch (ExtRejectedException exc) {
            switch (policy) {
                case AbortPolicy: {
                    throw new RejectedExecutionException("Task " + exc.run.toString() + " rejected from " + exc.executor.toString());
                }
                case DiscardPolicy: {
                    break;
                }
                case CallerRunsPolicy: {
                    runnable.run();
                    break;
                }
                case DiscardOldestPolicy: {
                    if (exc.executor.isShutdown()) break;
                    exc.executor.pollTask(exc.run);
                    exc.executor.execute(exc.run);
                    break;
                }
            }
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable, IExtUnifiedTaskType taskType, RequestContext requestContext, OperationContext operationContext, ExtRejectedPolicy policy) {
        try {
            return ExtThreadService.get(taskType).submit(callable, taskType.getName(), requestContext, operationContext == null ? null : operationContext.copy());
        }
        catch (ExtRejectedException exc) {
            switch (policy) {
                case AbortPolicy: {
                    throw new RejectedExecutionException("Task " + exc.run.toString() + " rejected from " + exc.executor.toString());
                }
                case DiscardPolicy: {
                    break;
                }
                case CallerRunsPolicy: {
                    FutureTask<T> futureTask = new FutureTask<T>(callable);
                    futureTask.run();
                    return futureTask;
                }
                case DiscardOldestPolicy: {
                    if (exc.executor.isShutdown()) break;
                    exc.executor.pollTask(exc.run);
                    exc.executor.execute(exc.run);
                    break;
                }
            }
            return null;
        }
    }
}

