/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.thread;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.bd.thread.ExtRejectedException;
import kd.bos.ext.bd.thread.ExtRejectedPolicy;
import kd.bos.ext.bd.thread.ExtTaskType;
import kd.bos.ext.bd.thread.ExtThreadExecutorService;
import kd.bos.ext.bd.thread.IExtUnifiedTaskType;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.tasktype.TaskType;

public class ExtThreadService {
    private static final ThreadExecutorService THREAD_POOL = ThreadPoolFactory.create((String)"cus", (String)"xinghan-cus-threadpool", (ThreadPoolStrategy)ExtThreadService.getDefaultThreadPoolStrategy());

    private static ThreadPoolStrategy getDefaultThreadPoolStrategy() {
        ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
        ExtTaskType[] scmcTypes = ExtTaskType.values();
        ArrayList<TaskType> taskTypes = new ArrayList<TaskType>(scmcTypes.length);
        for (ExtTaskType scmcType : scmcTypes) {
            taskTypes.add(scmcType.build());
        }
        strategy.register(taskTypes);
        strategy.setMaxThreadNum(50);
        strategy.setMinThreadNum(10);
        strategy.setOverflowThreadNum(20);
        strategy.setThreadIdeMinutes(1L);
        strategy.setRejectedExecutionHandler((run, executor) -> {
            throw new ExtRejectedException(executor, run);
        });
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ThreadExecutorService get(IExtUnifiedTaskType taskTypeEnum) {
        TaskType taskType = ExtThreadService.getTaskType(taskTypeEnum);
        if (taskType == null) {
            IExtUnifiedTaskType iExtUnifiedTaskType = taskTypeEnum;
            synchronized (iExtUnifiedTaskType) {
                taskType = ExtThreadService.getTaskType(taskTypeEnum);
                if (taskType == null) {
                    taskType = new TaskType(taskTypeEnum.getName(), taskTypeEnum.getPriority(), taskTypeEnum.getThreadLimitedModel(), (Object)taskTypeEnum.getThreadLimitedValue(), taskTypeEnum.getTaskQueueMaxSize());
                    THREAD_POOL.addTaskType(taskType);
                }
            }
        }
        return THREAD_POOL;
    }

    private static TaskType getTaskType(IExtUnifiedTaskType taskTypeEnum) {
        TaskType taskType = null;
        try {
            taskType = THREAD_POOL.getTaskType(taskTypeEnum.getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return taskType;
    }

    public static void execute(Runnable command, IExtUnifiedTaskType taskType) {
        ExtThreadService.execute(command, taskType, null);
    }

    public static void execute(Runnable command, IExtUnifiedTaskType taskType, RequestContext context) {
        ExtThreadService.execute(command, taskType, context, null);
    }

    public static void execute(Runnable command, IExtUnifiedTaskType taskType, RequestContext context, OperationContext oc) {
        ExtThreadService.execute(command, taskType, context, oc, null);
    }

    public static void execute(Runnable command, IExtUnifiedTaskType taskType, RequestContext context, OperationContext oc, ExtRejectedPolicy policy) {
        policy = policy == null ? ExtRejectedPolicy.CallerRunsPolicy : policy;
        ExtThreadExecutorService executeService = policy.getExecuteService();
        executeService.execute(command, taskType, context, oc, policy);
    }

    public static <T> Future<T> submit(Callable<T> task, IExtUnifiedTaskType taskType) {
        return ExtThreadService.submit(task, taskType, null, null);
    }

    public static <T> Future<T> submit(Callable<T> task, IExtUnifiedTaskType taskType, RequestContext context) {
        return ExtThreadService.submit(task, taskType, context, null);
    }

    public static <T> Future<T> submit(Callable<T> task, IExtUnifiedTaskType taskType, RequestContext context, OperationContext oc) {
        return ExtThreadService.submit(task, taskType, context, oc, null);
    }

    public static <T> Future<T> submit(Callable<T> task, IExtUnifiedTaskType taskType, RequestContext context, OperationContext oc, ExtRejectedPolicy policy) {
        policy = policy == null ? ExtRejectedPolicy.CallerRunsPolicy : policy;
        ExtThreadExecutorService executeService = policy.getExecuteService();
        return executeService.submit(task, taskType, context, oc, policy);
    }
}

