/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.dhc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class DocTrackUp
extends DefaultDynamicFormOperate {
    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
    }

    protected OperationResult invokeOperation() {
        Set<Long> pkIds = this.getSelectedPkIds();
        if (pkIds == null || pkIds.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8054\u67e5\u7684\u6570\u636e", (String)"DocTrackUp_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return null;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_lookuptracker");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String linkNodesJson = this.loadAndSeriLinkNodes(pkIds);
        if (StringUtils.isBlank((CharSequence)linkNodesJson)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"DocTrackUp_2", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return null;
        }
        Object lookUpTrackerUseList = SystemParamServiceHelper.loadPublicParameterFromCache((String)"lookuptracker_use_list");
        String isUseList = lookUpTrackerUseList == null ? String.valueOf(false) : lookUpTrackerUseList.toString();
        showParameter.getCustomParams().put("lookuptracker_use_list", isUseList);
        showParameter.getCustomParams().put("linknodes", linkNodesJson);
        showParameter.getCustomParams().put("lookuptype", this.getLookUpType());
        this.getView().showForm(showParameter);
        return null;
    }

    protected String getLookUpType() {
        return "lookup";
    }

    protected Set<Long> getSelectedPkIds() {
        HashSet<Long> pkIds;
        block4: {
            ReportList reportList;
            Map state;
            Object rowIndex;
            block5: {
                block3: {
                    pkIds = new HashSet<Long>(4);
                    if (!(this.getView() instanceof IListView)) break block3;
                    IListView listView = (IListView)this.getView();
                    for (ListSelectedRow row : listView.getSelectedRows()) {
                        if (!(row.getPrimaryKeyValue() instanceof Long)) continue;
                        Long pkId = (Long)row.getPrimaryKeyValue();
                        pkIds.add(pkId);
                    }
                    break block4;
                }
                if (!(this.getView() instanceof IBillView)) break block5;
                IBillView billView = (IBillView)this.getView();
                IBillModel billModel = (IBillModel)billView.getModel();
                if (!(billModel.getPKValue() instanceof Long)) break block4;
                Long pkId = (Long)billModel.getPKValue();
                pkIds.add(pkId);
                break block4;
            }
            if (this.getView() instanceof IReportView && (rowIndex = (state = (reportList = (ReportList)this.getView().getControl("reportlistap")).getEntryState().getState()).get("selRows")) instanceof List) {
                List rowIndexList = (List)rowIndex;
                IReportListModel reportModel = reportList.getReportModel();
                for (Object indexTmp : rowIndexList) {
                    if (!(indexTmp instanceof Integer)) continue;
                    Integer index = (Integer)indexTmp;
                    DynamicObject selectedRow = reportModel.getRowData(index.intValue());
                    pkIds.add(selectedRow.getLong("id"));
                }
            }
        }
        return pkIds;
    }

    protected Map<String, HashSet<Long>> getSelectedBillIdMap(Set<Long> pkIds) {
        HashMap<String, HashSet<Long>> entityMap = new HashMap<String, HashSet<Long>>(4);
        QFilter qFilter = new QFilter("id", "in", pkIds);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"dhc_mybilllist", (String)"billid,billno,bill.number", (QFilter[])new QFilter[]{qFilter});
        if (dyos != null) {
            for (DynamicObject dynamicObject : dyos) {
                HashSet<Long> billIds;
                long billId = dynamicObject.getLong("billid");
                String billNumber = dynamicObject.getString("bill.number");
                if (entityMap.containsKey(billNumber)) {
                    billIds = (HashSet<Long>)entityMap.get(billNumber);
                    billIds.add(billId);
                    continue;
                }
                billIds = new HashSet<Long>(4);
                billIds.add(billId);
                entityMap.put(billNumber, billIds);
            }
        }
        return entityMap;
    }

    protected String loadAndSeriLinkNodes(Set<Long> pkIds) {
        List nodes = null;
        Map<String, HashSet<Long>> entityMap = this.getSelectedBillIdMap(pkIds);
        if (!entityMap.isEmpty()) {
            for (Map.Entry<String, HashSet<Long>> entry : entityMap.entrySet()) {
                nodes = BFTrackerServiceHelper.loadLinkUpNodes((String)entry.getKey(), (String)"", (Long[])entry.getValue().toArray(new Long[0]));
            }
        }
        if (nodes != null && !nodes.isEmpty()) {
            for (BFRowLinkUpNode node : nodes) {
                for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                    sNode.setSNodes(new HashMap(2));
                }
            }
            return SerializationUtils.serializeToBase64((Object)nodes);
        }
        return null;
    }
}

