/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fircm.workflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fircm.dto.ApproveTaskResult;
import kd.bos.ext.fircm.dto.WorkFlowNodeCreditRecordDto;
import kd.bos.ext.fircm.enums.WorkFlowAuditTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.ssc.task.workflow.dto.CreditPointDTO;

public class CreditScoreAccountWorkflowPlugin
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(CreditScoreAccountWorkflowPlugin.class);
    private static final String CREDITSUBSCOREINFO = "creditSubScoreInfo";
    private static final Set<String> ALLOWFLOWTYPES = new /* Unavailable Anonymous Inner Class!! */;
    private static final Set<String> ALLOWUSERTASKNODEEVENT = new /* Unavailable Anonymous Inner Class!! */;

    public void notify(AgentExecution execution) {
        String eventName;
        WorkflowElement currentFlowElement = execution.getCurrentFlowElement();
        String flowType = currentFlowElement == null ? null : currentFlowElement.getType();
        if (!this.isAllowExecute(flowType, eventName = execution.getEventName())) {
            log.error(String.format("CreditScoreAccountWorkflowPlugin#notify call error,don't allow execute.flowType:%s,eventName:%s", flowType, eventName));
            return;
        }
        String flowCSSInfoStr = (String)execution.getVariable(CREDITSUBSCOREINFO);
        if (flowCSSInfoStr == null || flowCSSInfoStr.isEmpty()) {
            return;
        }
        List flowCSSInfo = SerializationUtils.fromJsonStringToList((String)flowCSSInfoStr, WorkFlowNodeCreditRecordDto.class);
        if (flowCSSInfo.size() < 1) {
            return;
        }
        this.handleCreditSubInfo(flowCSSInfo, execution);
    }

    private void handleCreditSubInfo(List<WorkFlowNodeCreditRecordDto> creditSubInfo, AgentExecution execution) {
        String billId = execution.getBusinessKey();
        String entityNumber = execution.getEntityNumber();
        String billNumber = ((ExecutionEntityImpl)execution).getBillNo();
        Long creatorId = ((ExecutionEntityImpl)execution).getCreatorId();
        CreditPointDTO creditPointDTO = new CreditPointDTO(billId, entityNumber, billNumber, creatorId.longValue());
        Long userIdByAppObj = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditArgAppObj", (Object[])new Object[]{creditPointDTO.getBillNumber(), creditPointDTO.getBillId()});
        Optional.ofNullable(userIdByAppObj).ifPresent(arg_0 -> ((CreditPointDTO)creditPointDTO).setUserId(arg_0));
        if (creditPointDTO.getUserId() == -1L) {
            log.error(String.format("handleCreditSubInfo error, billType:{%s}, billNo:{%s}", creditPointDTO.getBillNumber(), creditPointDTO.getBillNo()));
            return;
        }
        Map<Long, Map<String, Object>> distinctSubScores = this.getDistinctSubScores(creditSubInfo);
        HashSet<Long> handledIds = new HashSet<Long>(8);
        for (Map.Entry<Long, Map<String, Object>> item : distinctSubScores.entrySet()) {
            Long id = item.getKey();
            Map<String, Object> detailMap = item.getValue();
            String description = (String)detailMap.get("description");
            Object hisTaskId = detailMap.get("hisTaskId");
            if (hisTaskId != null) {
                creditPointDTO.setHisTaskId(((Long)hisTaskId).longValue());
            }
            String creditPointDTOStr = SerializationUtils.toJsonString((Object)creditPointDTO);
            try {
                if (id.equals(0L)) {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"insertCreditModLogOfZero", (Object[])new Object[]{creditPointDTOStr, "2", description});
                } else {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"deductCreditPoints", (Object[])new Object[]{Collections.singletonList(id), "2", creditPointDTOStr, description});
                }
                handledIds.add(id);
            }
            catch (Exception e) {
                log.error(String.format("handleCreditSubInfo call ICreditService error,creditPointDTOStr:%s,distinctSubScores:%s,handledSubScores:%s", creditPointDTOStr, distinctSubScores, handledIds), (Throwable)e);
                this.removeHandledIds(handledIds, creditSubInfo);
                execution.setVariable(CREDITSUBSCOREINFO, (Object)SerializationUtils.toJsonString(creditSubInfo));
                throw new KDException((Throwable)e, new ErrorCode("handleCreditSubInfo call ICreditService error:", e.getMessage()), new Object[0]);
            }
        }
        execution.setVariable(CREDITSUBSCOREINFO, (Object)"");
    }

    private boolean isAllowExecute(String flowType, String eventName) {
        boolean isAllow = false;
        if (ALLOWFLOWTYPES.contains(flowType)) {
            if ("UserTask".equalsIgnoreCase(flowType)) {
                if (ALLOWUSERTASKNODEEVENT.contains(eventName)) {
                    isAllow = true;
                }
            } else {
                isAllow = true;
            }
        } else if (flowType == null && "withdraw_audited_proc".equals(eventName)) {
            isAllow = true;
        }
        return isAllow;
    }

    private Map<Long, Map<String, Object>> getDistinctSubScores(List<WorkFlowNodeCreditRecordDto> creditSubInfo) {
        HashMap<Long, Map<String, Object>> re = new HashMap<Long, Map<String, Object>>(8);
        for (WorkFlowNodeCreditRecordDto item : creditSubInfo) {
            List approveTaskResults = item.getApproveTaskResults();
            String flowNodeName = item.getFlowNodeName();
            for (ApproveTaskResult approveTaskResult : approveTaskResults) {
                List creditScoreIds = approveTaskResult.getCreditScoreId();
                String auditType = approveTaskResult.getAuditType();
                String description = flowNodeName + approveTaskResult.getResultDescription();
                long hisTaskId = approveTaskResult.getHisTaskId();
                if (!WorkFlowAuditTypeEnum.isInclude((String)auditType)) {
                    log.info("handleCreditSubInfo invoke an creditRecord of error auditType:" + item);
                    continue;
                }
                for (Long creditScoreId : creditScoreIds) {
                    Map singleScoreMap = re.computeIfAbsent(creditScoreId, k -> new HashMap(2));
                    Object oldDescription = singleScoreMap.get("description");
                    String newDescription = oldDescription == null ? description : oldDescription + "\u3001" + description;
                    singleScoreMap.put("description", newDescription);
                    if (hisTaskId <= 0L) continue;
                    singleScoreMap.put("hisTaskId", hisTaskId);
                }
            }
        }
        return re;
    }

    private void removeHandledIds(Set<Long> handledIds, List<WorkFlowNodeCreditRecordDto> creditSubInfo) {
        Iterator<WorkFlowNodeCreditRecordDto> recordDtoIterator = creditSubInfo.iterator();
        while (recordDtoIterator.hasNext()) {
            WorkFlowNodeCreditRecordDto recordDto = recordDtoIterator.next();
            List approveTaskResults = recordDto.getApproveTaskResults();
            Iterator taskResultIterator = approveTaskResults.iterator();
            while (taskResultIterator.hasNext()) {
                ApproveTaskResult taskResult = (ApproveTaskResult)taskResultIterator.next();
                List creditScoreIds = taskResult.getCreditScoreId();
                creditScoreIds.removeIf(handledIds::contains);
                if (creditScoreIds.size() >= 1) continue;
                taskResultIterator.remove();
            }
            if (approveTaskResults.size() >= 1) continue;
            recordDtoIterator.remove();
        }
    }
}

