/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.operation.image;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ImageRescanService
extends EntityOperateService {
    private static final Log log = LogFactory.getLog(ImageRescanService.class);

    protected void executeOperate(DynamicObject[] dynamicObjects) {
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
    }

    public OperationResult excute(Object[] ids) throws Exception {
        String userID = String.valueOf(RequestContext.get().getUserId());
        OperationResult operationResult = super.excute(ids);
        if (operationResult.getAllErrorOrValidateInfo().size() > 0) {
            return operationResult;
        }
        QFilter filter = new QFilter("billid", "=", (Object)String.valueOf(ids[0]));
        QFilter[] filters = new QFilter[]{filter};
        ORM orm = ORM.create();
        DynamicObjectCollection doc = orm.query("task_billimagemap", "id,billid,billtype,imagenumber,imagestate,needimagescan", filters);
        log.info("\u83b7\u53d6\u5230\u7684\u5f71\u50cf\u6620\u5c04\u8bb0\u5f55:" + doc.size());
        if (doc == null || doc.size() == 0) {
            operationResult.setMessage(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e0d\u652f\u6301\u5f71\u50cf\u3002", (String)"SscWorkFlowFormatPlugin_4", (String)"bos-ext-ssc", (Object[])new Object[0]));
            operationResult.setSuccess(false);
            return operationResult;
        }
        DynamicObject mapInfo = (DynamicObject)doc.get(0);
        String imageNumber = mapInfo.getString("imagenumber");
        String imagestate = mapInfo.getString("imagestate");
        String needimagescan = mapInfo.getString("needimagescan");
        log.info("\u83b7\u53d6\u5230\u7684imageNumber:" + imageNumber + " \u5f71\u50cf\u72b6\u6001\u4e3a\uff1a" + imagestate);
        if (StringUtils.isBlank((CharSequence)imageNumber)) {
            operationResult.setMessage(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e0d\u652f\u6301\u5f71\u50cf\u3002", (String)"SscWorkFlowFormatPlugin_4", (String)"bos-ext-ssc", (Object[])new Object[0]));
            operationResult.setSuccess(false);
            return operationResult;
        }
        if (!imagestate.equals("2") && !imagestate.equals("4")) {
            operationResult.setMessage(ResManager.loadKDString((String)"\u53ea\u6709\u6b63\u5e38\u6216\u5f71\u50cf\u91cd\u4f20\u72b6\u6001\u7684\u5355\u636e\u624d\u53ef\u4ee5\u9000\u626b\u3002", (String)"SscWorkFlowFormatPlugin_8", (String)"bos-ext-ssc", (Object[])new Object[0]));
            operationResult.setSuccess(false);
            return operationResult;
        }
        Map variables = this.getOption().getVariables();
        log.info("\u64cd\u4f5c\u53d8\u91cf\uff1a" + variables);
        if (variables.containsKey("auditnumber")) {
            operationResult.setMessage(ResManager.loadKDString((String)"\u6821\u9a8c\u6210\u529f,\u53ef\u4ee5\u9000\u626b\u3002", (String)"SscWorkFlowFormatPlugin_9", (String)"bos-ext-ssc", (Object[])new Object[0]));
            operationResult.setSuccess(true);
            return operationResult;
        }
        try {
            log.info("\u5f00\u59cb\u6267\u884c\u9000\u626b\u64cd\u4f5c");
            ImageServiceHelper.imageRscan((String)imageNumber, (String)ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u5ba1\u6279\u9000\u56de\u91cd\u626b", (String)"SscWorkFlowFormatPlugin_12", (String)"bos-ext-ssc", (Object[])new Object[0]), (String)userID);
            this.updateImagestateIntoRescan(imageNumber, "3");
            if ("2".equals(needimagescan)) {
                log.info("\u53d8\u66f4\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868 \u662f\u5426\u9700\u8981\u5f71\u50cf\u626b\u63cf\u5b57\u6bb5\u503c\u4e3a 2");
                this.updateImageScanIntoRescan(imageNumber);
            }
            operationResult.setMessage(ResManager.loadKDString((String)"\u5f71\u50cf\u9000\u56de\u91cd\u626b\u6210\u529f\u3002", (String)"SscWorkFlowFormatPlugin_10", (String)"bos-ext-ssc", (Object[])new Object[0]));
            operationResult.setSuccess(true);
        }
        catch (Exception e) {
            operationResult.setMessage(e.getMessage());
            operationResult.setSuccess(false);
        }
        return operationResult;
    }

    private void updateImagestateIntoRescan(String imageNumber, String imageState) {
        QFilter filter = new QFilter("imagenumber", "=", (Object)imageNumber);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject image = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"id,imagestate", (QFilter[])filters);
        if (image == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e0d\u652f\u6301\u5f71\u50cf\u3002", (String)"SscWorkFlowFormatPlugin_4", (String)"bos-ext-ssc", (Object[])new Object[0]));
        }
        image.set("imageState", (Object)imageState);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{image});
    }

    private void updateImageScanIntoRescan(String imageNumber) {
        QFilter filter = new QFilter("imagenumber", "=", (Object)imageNumber);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject image = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"id,imagestate,needimagescan", (QFilter[])filters);
        if (image == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e0d\u652f\u6301\u5f71\u50cf\u3002", (String)"SscWorkFlowFormatPlugin_4", (String)"bos-ext-ssc", (Object[])new Object[0]));
        }
        image.set("needimagescan", (Object)Character.valueOf('1'));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{image});
    }
}

