/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BillAttributeControlV2FormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BillAttributeControlV2FormPlugin.class);
    private IClientViewProxy clientViewProxy = null;
    private OperationStatus billStatus = null;
    private boolean globalModify = false;

    public void initialize() {
        super.initialize();
        if (this.billStatus == null) {
            this.billStatus = this.getView().getFormShowParameter().getStatus();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean isQualityTask = formShowParameter.getCustomParam("isQualityTask") != null && (Boolean)formShowParameter.getCustomParam("isQualityTask") != false;
        String billAttributeConfigJSON = (String)formShowParameter.getCustomParam("billAttributeConfig");
        List configList = new ArrayList(10);
        if (StringUtils.isNotEmpty((String)billAttributeConfigJSON)) {
            configList = SerializationUtils.fromJsonStringToList((String)billAttributeConfigJSON, Map.class);
        }
        HashMap<String, Map> configMap = new HashMap<String, Map>(16);
        for (Map ctrlApInfo : configList) {
            configMap.put(ctrlApInfo.get("ctrlapnumber").toString(), ctrlApInfo);
        }
        HashSet<String> needDisplayTbs = new HashSet<String>(8);
        HashSet<String> needHideTbs = new HashSet<String>(8);
        for (Map.Entry entry : configMap.entrySet()) {
            boolean hide;
            Map config = (Map)entry.getValue();
            String ctrlApNumber = (String)config.get("ctrlapnumber");
            boolean hasPoint = false;
            if (ctrlApNumber.indexOf(46) >= 0) {
                int pointIndex = ctrlApNumber.lastIndexOf(46);
                ctrlApNumber = ctrlApNumber.substring(pointIndex + 1);
                hasPoint = true;
            }
            String hideKey = isQualityTask ? "qualitytaskhide" : "hide";
            String ctrlApType = (String)config.get("ctrlaptype");
            List<String> ctrlApTypes = Arrays.asList("AdvConToolbarAp", "BarItemAp", "MBarItemAp", "AdvConBarItemAp");
            if ("field".equals(ctrlApType)) {
                boolean modify = !isQualityTask && config.getOrDefault("modify", false) != false;
                boolean hide2 = config.getOrDefault(hideKey, false);
                this.setFieldApVisibleAndEnable(ctrlApNumber, modify, hide2);
                continue;
            }
            if (ctrlApTypes.contains(ctrlApType)) {
                hide = config.getOrDefault(hideKey, true);
                this.extractHideOrDisplay(needDisplayTbs, needHideTbs, ctrlApNumber, hasPoint, hide);
                continue;
            }
            if (!"labelorimage".equals(ctrlApType)) continue;
            hide = config.getOrDefault(hideKey, false);
            this.setLabelOrImageVisible(ctrlApNumber, hide);
        }
        List<Control> ctrlList = Collections.singletonList(this.getView().getRootControl());
        this.loopAndHideToolBar(ctrlList, needDisplayTbs);
        if (!OperationStatus.VIEW.equals((Object)this.billStatus) && !needHideTbs.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, needHideTbs.toArray(new String[needHideTbs.size()]));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"titlepanelflex"});
    }

    private void setFieldApVisibleAndEnable(String fieldNumber, boolean modify, boolean hide) {
        Control ctrlAp = this.getControl(fieldNumber);
        String entryKey = null;
        if (ctrlAp instanceof FieldEdit) {
            FieldEdit field = (FieldEdit)ctrlAp;
            entryKey = field.getEntryKey();
        }
        if (hide) {
            this.getView().setVisible(Boolean.FALSE, new String[]{fieldNumber});
        }
    }

    private void extractHideOrDisplay(Set<String> needDisplayTbs, Set<String> needHideTbs, String ctrlApNumber, boolean hasPoint, boolean hide) {
        if (!hasPoint && !hide) {
            needDisplayTbs.add(ctrlApNumber);
        } else if (hasPoint && hide) {
            needHideTbs.add(ctrlApNumber);
        }
    }

    private void setLabelOrImageVisible(String ctrlApNumber, boolean hide) {
        if (hide) {
            return;
        }
        Control ctrlAp = this.getControl(ctrlApNumber);
        if (ctrlAp instanceof Label || ctrlAp instanceof Image) {
            this.setCtrlMetadataVisible(ctrlApNumber);
            this.getView().setVisible(Boolean.TRUE, new String[]{ctrlApNumber});
        }
    }

    private void setCtrlMetadataVisible(String ctrlApNumber) {
        if (StringUtils.isNotEmpty((String)ctrlApNumber)) {
            HashMap<String, Integer> prop = new HashMap<String, Integer>(1);
            prop.put("vi", 63);
            this.getView().updateControlMetadata(ctrlApNumber, prop);
        }
    }

    private void loopAndHideToolBar(List<Control> ctrlList, Set<String> needDisplayTbs) {
        if (ctrlList == null || ctrlList.size() == 0) {
            return;
        }
        for (Control control : ctrlList) {
            String key = control.getKey();
            if ("pagepanel".equals(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
                continue;
            }
            if (control instanceof Toolbar) {
                if (!OperationStatus.VIEW.equals((Object)this.billStatus) && needDisplayTbs.contains(key)) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{key});
                continue;
            }
            if (!(control instanceof Container)) continue;
            this.loopAndHideToolBar(((Container)control).getItems(), needDisplayTbs);
        }
    }
}

