/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;

public class SscSaveValidatorPlugin
extends AbstractBillPlugIn {
    private static Log log = LogFactory.getLog(SscSaveValidatorPlugin.class);
    private static final String PREFIX = "ssc_er_bill_";

    public void initialize() {
        super.initialize();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        MainEntityType entityType = model.getDataEntityType();
        String billEntityName = entityType.getName();
        HashSet<String> erBillEntitySet = new HashSet<String>(Arrays.asList("er_tripreimbursebill", "er_dailyreimbursebill", "er_publicreimbursebill", "er_dailyloanbill"));
        this.isInheritErBill(erBillEntitySet, entityType);
        if (!erBillEntitySet.contains(billEntityName) && !this.isInheritErBill(erBillEntitySet, entityType)) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            log.error("errror: parentView is null");
            return;
        }
        IPageCache parentPageCache = parentView.getPageCache();
        log.info("\u7236\u9875\u9762\u8868\u5355id: formId = " + parentView.getEntityId() + ". \u5f00\u59cb\u8bb0\u5f55\u5355\u636e\u5404\u5206\u5f55\u884c\u6570");
        DynamicObject dataEntity = model.getDataEntity(true);
        List collectionProperties = dataEntity.getDynamicObjectType().getProperties().getCollectionProperties(true);
        log.info("collectionProperties.size = " + collectionProperties.size());
        StringBuilder sb = new StringBuilder();
        for (ICollectionProperty collProperty : collectionProperties) {
            if (!(collProperty instanceof EntryProp)) continue;
            String entryName = collProperty.getName();
            String rowCount = String.valueOf(model.getEntryRowCount(entryName));
            sb.append(String.format(ResManager.loadKDString((String)"%1$s[%2$s] \u521d\u59cb\u884c\u6570:%3$s\n", (String)"SscSaveValidatorPlugin_0", (String)"bos-ext-ssc", (Object[])new Object[0]), collProperty.getDisplayName(), entryName, rowCount));
            parentPageCache.put(PREFIX + entryName, rowCount);
        }
        if (sb.length() > 0) {
            log.info(sb.toString());
        }
    }

    private boolean isInheritErBill(Set<String> erBillEntitySet, MainEntityType entityType) {
        String[] inheritEntities = entityType.getInheritPath().split(",");
        int len = inheritEntities.length;
        for (int i = 0; i < len; ++i) {
            String inheritEntityNum = MetadataDao.getEntityNumberById((String)inheritEntities[i]);
            if (!erBillEntitySet.contains(inheritEntityNum)) continue;
            return true;
        }
        return false;
    }
}

