/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.util;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ArtiCheckPointUtil {
    private static final Log logger = LogFactory.getLog(ArtiCheckPointUtil.class);

    public static QFilter analysisFilter(String entityNumber, String conditionJson) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    public static boolean isArtiCheckPointSelectedOfList(IFormView view, List<Long> taskIdList) {
        List taskIds = taskIdList.stream().map(id -> id + "").collect(Collectors.toList());
        QFilter taskFilter = new QFilter("taskid", "in", taskIds);
        QFilter taskbillchildFilter = QFilter.isNotNull((String)"entryentityarticheck.articheck.id").and("entryentityarticheck.articheck.id", "!=", (Object)0L);
        DynamicObjectCollection articheckpointrecords = QueryServiceHelper.query((String)"task_articheckpointrecord", (String)"iscontented,taskid", (QFilter[])new QFilter[]{taskFilter});
        if (articheckpointrecords != null && articheckpointrecords.size() > 0) {
            for (DynamicObject articheckpointrecord : articheckpointrecords) {
                taskIdList.remove(articheckpointrecord.getLong("taskid"));
                if (articheckpointrecord.getBoolean("iscontented")) continue;
                String subject = ArtiCheckPointUtil.getSubjectFromTask(articheckpointrecord.getString("taskid"));
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"ArtiCheckPointUtil_1", (String)"bos-ext-ssc", (Object[])new Object[0]), subject));
                return false;
            }
            if (taskIdList.size() == 0) {
                return true;
            }
        }
        long count = 0L;
        ORM orm = ORM.create();
        try (DataSet taskRows = orm.queryDataSet("task_task", "task_task", "id as taskid,billtype,tasktypeid,subject,billid", new QFilter[]{new QFilter("id", "in", taskIdList)});
             DataSet billtypeRows = orm.queryDataSet("task_taskbill", "task_taskbill", "id as taskbillid,entryentity.tasktype as tasktype,entryentity.childpkid as childid,bindbill.number as bindbillnumber", null);
             DataSet childBilltypeRows = orm.queryDataSet("task_taskbill_child", "task_taskbill_child", "id as taskbillchildid,entryentityarticheck.articheck.isselected as articheckpointselected,entryentityarticheck.checkconditionjson_tag as checkconditionjson,entryentityarticheck.checkcondition as checkcondition", taskbillchildFilter.toArray());
             DataSet resultRows = taskRows.join(billtypeRows, JoinType.INNER).on("billtype", "taskbillid").on("tasktypeid", "tasktype").select(new String[]{"taskid", "subject", "childid", "billid", "bindbillnumber"}).finish().join(childBilltypeRows, JoinType.INNER).on("childid", "taskbillchildid").select(new String[]{"taskid", "subject", "billid", "bindbillnumber", "articheckpointselected", "checkconditionjson", "checkcondition"}).finish();){
            Iterator iterator = resultRows.iterator();
            while (true) {
                if (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    if (StringUtils.isNotBlank((CharSequence)row.getString("checkcondition")) && !ArtiCheckPointUtil.meetCondition(row.getString("bindbillnumber"), row.getString("checkconditionjson"), row.get("billid"))) continue;
                    ++count;
                    if (row.getBoolean("articheckpointselected").booleanValue()) continue;
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"ArtiCheckPointUtil_1", (String)"bos-ext-ssc", (Object[])new Object[0]), row.getString("subject")));
                    logger.info("count:" + count);
                    boolean bl = false;
                    return bl;
                    continue;
                }
                break;
            }
        }
        logger.info("count:" + count);
        return true;
    }

    private static String getSubjectFromTask(String taskid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(taskid), (String)"task_task", (String)"subject");
        return dynamicObject.getString("subject");
    }

    private static boolean meetCondition(String bindEntityNumber, String conditionJson, Object billId) {
        QFilter qFilter = ArtiCheckPointUtil.analysisFilter(bindEntityNumber, conditionJson);
        try {
            billId = Long.parseLong(String.valueOf(billId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        qFilter.and("id", "=", billId);
        return QueryServiceHelper.exists((String)bindEntityNumber, (QFilter[])qFilter.toArray());
    }
}

